(herald maxsuspend (env tsys (link suspend)))

(define (suspend obj out-spec x?)
  (set (experimental?) x?)
  (really-suspend obj out-spec 'o))

;;; Look at a Unix a.out description and template.doc

(define initial-symbol-count 6)


(define-constant SIZE-OF-HEADERS 164)
(define-constant RELOC-SIZE 10)
(define-constant MAGIC #o524)
(define-constant RELOC #x2001)                          
(define-constant TEXT-SYM 0)
(define-constant DATA-SYM 2)

(define (vgc-foreign foreign)
  (let* ((heap (lstate-impure *lstate*))
         (addr (+area-frontier heap))
         (name (foreign-name foreign))
         (desc (object nil
                 ((heap-stored self) (lstate-impure *lstate*))
                 ((heap-offset self) addr)
                 ((write-descriptor self stream)
                  (write-data stream (fx+ addr tag/extend)))
                 ((write-store self stream)
                  (write-int stream header/foreign)
                  (write-slot name stream)
                  (write-int stream 0)))))
    (set (+area-frontier heap) (fx+ addr 12))
    (push (+area-objects heap) desc)                
    (set-lp-table-entry (lstate-reloc *lstate*) foreign desc)
    (generate-slot-relocation name (fx+ addr 4))
    (cymbal-thunk (symbol->string name) 0)
    (foreign-reloc-thunk (lstate-symbol-count *lstate*) (fx+ addr 8))
    (modify (lstate-symbol-count *lstate*) (lambda (x) (fx+ x 1)))
    desc))

(define (generate-slot-relocation obj slot-address)
  (cond ((or (fixnum? obj) (immediate? obj)))
        ((eq? (heap-stored (vgc obj)) (lstate-impure *lstate*))
         (reloc-thunk DATA-SYM slot-address))
        (else
         (reloc-thunk TEXT-SYM slot-address))))

(define (text-relocation addr)
  (reloc-thunk TEXT-SYM addr))

(define (data-relocation addr)
  (reloc-thunk DATA-SYM addr))

(define (reloc-thunk type address) nil)

(define (foreign-reloc-thunk type address) 
  (push (lstate-data-reloc *lstate*)
        (cons address type)))
            
(lset the-string-table nil)

(define (cymbal-thunk stryng value)
 (push (lstate-symbols *lstate*)
  (object (lambda (stream)                    
            (xcond ((fx<= (string-length stryng) 8)
                    (write-string stream stryng)
                    (do ((i (string-length stryng) (fx+ i 1)))
                        ((fx= i 8))  
                      (vm-write-byte stream 0)))
                   ((table-entry the-string-table stryng)
                    => (lambda (offset)
                         (write-int stream 0)
                         (write-int stream offset))))
            (cond ((fixnum? value)            ; undefined external (foreign)
                   (write-int stream 0)
                   (write-half stream 0)    ; section number
                   (write-half stream 0)    ; type
                   (vm-write-byte stream 2))
                  (else
                   (write-int stream
			      (fx+ (if (eq? value (lstate-null *lstate*))
				       3
				       (extend-elt value 0))
				   (lstate-pure-size *lstate*)))
                   (write-half stream 2)    ; section
                   (write-half stream 0)    ; type
                   (vm-write-byte stream 2)))
            (vm-write-byte stream 0)
            (vm-write-byte stream 0)
            (vm-write-byte stream 0))
          ((cymbal-thunk.stryng self) stryng))))

(define-operation (cymbal-thunk.stryng thunk))

(define (write-slot obj stream)
  (cond ((fixnum? obj)
         (write-fixnum stream obj))
        ((immediate? obj)
         (write-immediate stream obj))
        ((null? obj)
         (write-descriptor (lstate-null *lstate*) stream))
        ((lp-table-entry (lstate-reloc *lstate*) obj)
         => (lambda (desc) (write-descriptor desc stream)))
        (else
         (error "bad immediate type ~s" obj))))

(define-integrable (write-data stream int)
  (write-int stream (fx+ #x400000 int)))

(define-integrable (write-text stream int)
  (write-int stream (fx+ #x60 int)))

(define (write-immediate stream imm)
  (let ((int (descriptor->fixnum imm)))
    (write-half stream (fx+ (fixnum-ashl int 2) 1))
    (write-half stream (fixnum-ashr int 14))))


(define (write-scratch stream obj i)
  (let ((offset (fixnum-ashl i 2)))
    (write-half stream (mref-16-u obj offset))
    (write-half stream (mref-16-u obj (fx+ offset 2)))))

(define (write-int stream int)
  (write-half stream int)
  (let ((int (fixnum-ashr int 16)))
    (write-half stream int)))

(define (write-half stream int)
  (vm-write-byte stream int)
  (let ((int (fixnum-ashr int 8)))
    (vm-write-byte stream int)))

(define (write-fixnum stream fixnum)
  (write-half stream (fixnum-ashl fixnum 2))
  (write-half stream (fixnum-ashr fixnum 14)))

(define (make-global-cymbal proc name)
  (cond ((lp-table-entry (lstate-reloc *lstate*) proc)
       => (lambda (desc)                                
            (cymbal-thunk (string-downcase! (symbol->string name))
                          desc)
            (modify (lstate-symbol-count *lstate*) (lambda (x) (fx+ x 1)))))
        (else
         (error "~s not defined" name))))


(define (write-link-file stream)
  (make-global-cymbal big_bang 'big_bang)
  (make-global-cymbal interrupt_dispatcher 'interrupt_dispatcher)
  (cymbal-thunk "the_slink" (lstate-null *lstate*))
  (modify (lstate-symbol-count *lstate*) (lambda (x) (fx+ x 1)))
  (write-header     stream)
  (write-text-section-header stream)
  (write-data-section-header stream)
  (write-bss-section-header stream)
  (write-area       stream (lstate-pure *lstate*))
  (write-area       stream (lstate-impure *lstate*))
  (write-relocation stream) 
  (write-cymbal&stryng-table stream (reverse (lstate-symbols *lstate*))))

(define (write-header stream)
    (write-half stream MAGIC)                 ;magic number
    (write-half stream 3)                     ; # of sections
    (write-int stream 0)                      ; time and date 
    (write-int stream (cymbal-table-offset))
    (write-int stream (lstate-symbol-count *lstate*))
    (write-half stream 0)                      ; no extra header
    (write-half stream #o404))                  ; flags

(define (write-text-section-header stream)   
  (write-string stream ".text")
  (vm-write-byte stream 0)
  (vm-write-byte stream 0)
  (vm-write-byte stream 0)
  (write-int stream 0)      ; phys addr
  (write-int stream 0)      ; virtual addr
  (write-int stream (lstate-pure-size *lstate*))
  (write-int stream SIZE-OF-HEADERS)
  (write-int stream 0)      ; no reloc
  (write-int stream 0)      ; no line numbers
  (write-half stream 0)      
  (write-half stream 0)      
  (write-int stream #x20)
  (write-int stream 0)      
  (write-int stream 0))      
  
(define (write-data-section-header stream)   
  (write-string stream ".data")
  (vm-write-byte stream 0)
  (vm-write-byte stream 0)
  (vm-write-byte stream 0)
  (write-int stream (lstate-pure-size *lstate*))      ; phys addr
  (write-int stream (lstate-pure-size *lstate*))      ; virtual addr
  (write-int stream (+area-frontier (lstate-impure *lstate*)))
  (write-int stream (+ SIZE-OF-HEADERS (lstate-pure-size *lstate*)))
  (write-int stream (+ SIZE-OF-HEADERS 
                       (lstate-pure-size *lstate*)
                       (+area-frontier (lstate-impure *lstate*))))
  (write-int stream 0)      ; no line numbers
  (write-half stream (length (lstate-data-reloc *lstate*)))
  (write-half stream 0)      
  (write-int stream #x40)
  (write-int stream 0)      
  (write-int stream 0))      

(define (write-bss-section-header stream)   
  (write-string stream ".bss")
  (vm-write-byte stream 0)
  (vm-write-byte stream 0)
  (vm-write-byte stream 0)
  (vm-write-byte stream 0)
  (write-int stream (fx+ (+area-frontier (lstate-impure *lstate*))
                         (lstate-pure-size *lstate*)))      ; phys addr
  (write-int stream (fx+ (+area-frontier (lstate-impure *lstate*))
                         (lstate-pure-size *lstate*)))      ; virt addr
  (write-int stream 0)
  (write-int stream 0)
  (write-int stream 0)
  (write-int stream 0)      
  (write-half stream 0)
  (write-half stream 0)      
  (write-int stream #x80)
  (write-int stream 0)      
  (write-int stream 0))      

(define (cymbal-table-offset)
  (+ SIZE-OF-HEADERS 
     (lstate-pure-size *lstate*)
     (+area-frontier (lstate-impure *lstate*))
     (* RELOC-SIZE (length (lstate-data-reloc *lstate*)))))

(define (write-area stream area)
  (walk (lambda (x) (write-store x stream))
        (reverse! (+area-objects area))))


(define (write-relocation stream)
  (walk (lambda (item)      
          (write-int stream (fx+ (car item) (lstate-pure-size *lstate*)))
          (write-int stream (cdr item))
          (write-half stream #x2001))
        (sort-list! (lstate-data-reloc *lstate*)
                    (lambda (x y)      
                       (fx< (car x) (car y))))))


(define (write-map-entry stream name value) nil)

(define  (write-text-and-data-cymbals stream)
    (write-string stream ".text")
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)
    (write-int  stream 0)
    (write-half stream 1)    ; section
    (write-half stream 0)    ; type
    (vm-write-byte stream 3)
    (vm-write-byte stream 1)
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)

    (write-int stream (lstate-pure-size *lstate*))
    (write-int stream 0)
    (write-int stream 0)
    (write-int stream 0)
    (write-int stream 0)

    (write-string stream ".data")
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)
    (write-int  stream (lstate-pure-size *lstate*))
    (write-half stream 2)    ; section
    (write-half stream 0)    ; type
    (vm-write-byte stream 3)
    (vm-write-byte stream 1)
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)

    (write-int stream (+area-frontier (lstate-impure *lstate*)))
    (write-int stream (length (lstate-data-reloc *lstate*)))
    (write-int stream 0)
    (write-int stream 0)
    (write-int stream 0)
 
    (write-string stream ".bss")
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)
    (write-int  stream (fx+ (lstate-pure-size *lstate*) 
                            (+area-frontier (lstate-impure *lstate*))))
    (write-half stream 3)    ; section
    (write-half stream 0)    ; type
    (vm-write-byte stream 3)
    (vm-write-byte stream 1)
    (vm-write-byte stream 0)
    (vm-write-byte stream 0)

    (write-int stream 0)
    (write-int stream 0)
    (write-int stream 0)
    (write-int stream 0)
    (write-int stream 0))
 
(define (write-cymbal&stryng-table stream cyms)
  (let ((size (make-stryng-table cyms)))   
    (write-text-and-data-cymbals stream)
    (walk (lambda (cym) (cym stream)) cyms)
    (write-stryng-table stream size cyms)))        

(define (make-stryng-table cyms)
  (set the-string-table (make-string-table 'stryngs))
  (iterate loop ((i 4) (cyms cyms))
      (cond ((null? cyms) i)
            (else
             (let* ((string (cymbal-thunk.stryng (car cyms)))
                    (len (string-length string)))
               (cond ((fx<= len 8)
                      (loop i (cdr cyms)))
                     (else                      
                      (set (table-entry the-string-table string) i)
                      (loop (fx+ i (fx+ len 1)) (cdr cyms)))))))))
                                                       

(define (write-stryng-table stream size cyms)
  (write-int stream size)
  (do ((cyms cyms (cdr cyms)))
      ((null? cyms))
    (let* ((string (cymbal-thunk.stryng (car cyms)))
           (len (string-length string)))
      (cond ((fx<= len 8))
            (else                      
             (write-string stream string)
             (vm-write-byte stream 0))))))


