/*
 *			D Y N L O A D . C 
 *
 * This file contains functions to help dynamically load foreign UNIX files
 * into a running T process.
 *
 * written by Dorab Patel <dorab@neptune.cs.ucla.edu>
 * December 24, 1986
 * Copyright Dorab Patel (C) 1986
 * Permission is given to distribute this software free to anyone
 * using it for a non-commercial purpose. Comments/bug reports/fixes
 * are encouraged.
 *
 * $Revision: 1.1 $
 *
 * $Log:	dynload.c,v $
 * Revision 1.1  86/12/24  18:20:44  dorab
 * Broken Revision
 * 
 */

#include <nlist.h>
#define N_TEXT 0x4

int loadhelp(objFile, relocFile, tmpFile, libString, otherString)
char *objFile, *relocFile, *tmpFile, *libString, *otherString;
{
  return -1;			/* Always return error. */
}

/*
 * return the address of the function functionName in the namelist 
 * of the file fileName.
 * the calling procedure had better make sure that fileName exists.
 */
unsigned long
nlistone(fileName,functionName)
char *fileName, *functionName;
{
  struct nlist nl[2];
  int rc;

  nl[1].n_un.n_name = '\0';	/* terminate the name list */
  nl[0].n_un.n_name = functionName; /* put the function name in */
  rc = nlist(fileName,nl);	/* call nlist */
  if (rc < 0 || (nl[0].n_type == (unsigned char) 0 /* check for errors */
		 && nl[0].n_value == (unsigned long) 0))
    return ((unsigned long) 0);
  if (nl[0].n_type & N_TEXT)	/* if it is in the text segment i.e. is a function */
    return(nl[0].n_value);	/* return the address */
  else
    return ((unsigned long) 0); /* not a function */
}
