/* This file contains main and the argument processing for T. */

#include <stdio.h>
char *malloc();			/* Use malloc to get space. */

#define MIN_HEAP_SIZE (1 << 19)	/* .5 Mb */
#define DEFAULT_HEAP_SIZE (1 << 22) /* 4 Mb  */

int main(argc, argv)
     int argc;
     char *argv[];
{
  long heap_wanted = -1;
  long debug = 0;
  long errors = 0;
  char *the_heaps;
  long total, aligned_total;
  long heap_size, aligned_heap_size;

  int ac = argc - 1;
  char **av = argv + 1;

  for (; ac > 0; ac--, av++)
    if (av[0][0] == '-')
      switch (av[0][1]) {
      case 'h':
        (*av)++;
        if (strcmp(*av, "h") != 0 && strcmp(*av, "heap") != 0) break;
	ac--; av++;
	if (ac == 0) { errors++; break; }
	heap_wanted = atoi(*av);
	if (heap_wanted <= 0) errors++;
	if (heap_wanted < MIN_HEAP_SIZE) {
	  fprintf(stderr,"Heap requested is too small.\n");
	  heap_wanted = MIN_HEAP_SIZE;
	}
	break;
      case 'd':
        if (strcmp(*av, "d") != 0 && strcmp(*av, "debug") != 0) break;
	debug = -1;
	break;
      }
  if (errors != 0) {
    fprintf(stderr,"Usage: %s [-d] [-h <heap size in bytes>]\n", argv[0]);
    exit (1);
  }

  heap_size = heap_wanted > 0 ? heap_wanted : DEFAULT_HEAP_SIZE;

  the_heaps = malloc( heap_size * 2 );
  if (the_heaps == NULL)  {
    fprintf(stderr,
	    "T could not allocate two heaps of %d bytes.\n", heap_size);
    fprintf(stderr,
	    "Please retry with smaller heaps by using the -h switch.\n");
    exit(1);
  }

  total = (long) the_heaps;

  /* make heaps smaller (if necessary) for quadword alignment */

  aligned_total = (total + 15) & 0xFFFFFFF0;
  aligned_heap_size = ( ((heap_size * 2) - (aligned_total - total))
		       & 0xFFFFFFF0 );

  heap_size = aligned_heap_size / 2;

  /* print message if any command line flag is given */

  if (heap_wanted != -1)
    fprintf(stderr,"%d bytes per heap\n", heap_size);

  return start_t( aligned_total, (aligned_total + heap_size),
		 heap_size, argc, argv, debug);
}

void gc_interrupt()
{
  fprintf(stderr,
	  "Interrupted during GC; 'q' to exit, anything else to continue GC.\n");
  if (getchar() == 'q')
    exit(0);
}

extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;

void get_unix_error_msg(t, size)
     char *t;
     int size;
{
  char *r; char *s;    
  r = sys_errlist[ errno ];
  s = t + size;
  while (t < s && ((*t++ = *r++) != '\0'));
}
