(herald splap)

(define lap-pseudo-ops (make-table 'lap-pseudo-ops))
(define lap-instructions (make-table 'lap-instruction))

(define-local-syntax (define-lap-instruction n1 n2)
  `(set (table-entry lap-instructions ',n1) ,n2))


(define-local-syntax (define-lap-syntax pattern . body)
  `(set (table-entry lap-pseudo-ops ',(car pattern))
	(object (lambda ,(cdr pattern) ,@body)
	  ((identification self) ',(car pattern)))))

(define-local-syntax (define-j-syntax j)
  `(define-lap-syntax (,j arg1 arg2 label)
     (*jlap ,(concatenate-symbol 'jump-op/ j) arg1 arg2 label)))

(define-local-syntax (define-arith-syntax op)
  `(define-lap-syntax (,op arg1 arg2 . arg3)
     (*arithlap ,(concatenate-symbol 'risc/ op) arg1 arg2
		(if arg3 (car arg3) arg2))))
 
(define-j-syntax j=)
(define-j-syntax jn=)
(define-j-syntax j<)
(define-j-syntax j<=)
(define-j-syntax j>)
(define-j-syntax j>=)
(define-j-syntax uj<)
(define-j-syntax uj>)
(define-j-syntax uj<=)
(define-j-syntax uj>=)

(define-lap-syntax (jbr lab)
  (emit-jump lab))

(define-lap-syntax (jl lab)
  (emit-branch-and-link lab))

(define (*jlap jop arg1 arg2 label)
  (let ((next (cons label nil)))
    (emit-compare jop (lap-eval arg1) (lap-eval arg2) label next)
    (emit-tag next)))

(define (*arithlap inst arg1 arg2 arg3)
  (emit inst (lap-eval arg1) (lap-eval arg2) (lap-eval arg3)))

(define-lap-syntax (move a b)
  (emit risc/add (lap-eval a) zero (lap-eval b)))

(import t-implementation-env bignum?)

(define-lap-syntax (movec a b)
  (let ((num (eval a orbit-env))
	(tar (lap-eval b)))
    (xcond ((bignum? num)
	    (emit sparc/sethi (unsigned-num
			    (bignum-bit-field num 10 22)) tar)
	    (emit risc/or
		  (unsigned-num (bignum-bit-field num 0 10))
		  tar tar))
           ((13bit? num)
	    (emit risc/add (machine-num num) zero tar))
	   ((fixnum? num)
	    (emit sparc/sethi (unsigned-num
			    (fixnum-logand #x3fffff (fixnum-ashr num 10))) tar)
	    (emit risc/or
		  (unsigned-num (fixnum-logand #x3ff num))
		  tar tar)))))

(define-lap-syntax (template pointer nargs nary?)
  (asemit stemplate1 '(()))
  (asemit template2 '())
  (asemit laptemplate3 (list pointer nargs nary?)))

(define-lap-syntax (movea lab reg)
  (emit-branch-and-link 8)
  (emit risc/add (label-offset lab) link-reg (lap-eval reg)))

(define-lap-syntax (clear size mem)
  (emit risc/store size zero (lap-eval mem)))

(define-lap-syntax (store size reg mem)
    (emit risc/store size (lap-eval reg) (lap-eval mem)))

(define-lap-syntax (load size mem reg)
    (emit risc/load size (lap-eval mem) (lap-eval reg)))
#|
(define-lap-syntax (jalr reg)
  (emit sparc/jmpl (lap-eval reg) link-reg))

(define-lap-syntax (jr reg)
  (emit sparc/jmpl (lap-eval reg) zero))

(define-lap-syntax (restore)
  (emit sparc/restore zero (machine-num 0) zero))
|#
(define-lap-syntax (jalr reg)
  (emit sparc/jmpl (lap-eval `(d@r ,reg 0)) link-reg))

(define-lap-syntax (jr reg)
  (emit sparc/jmpl (lap-eval `(d@r ,reg 0)) zero))


(define-arith-syntax add)
(define-arith-syntax sub)
(define-arith-syntax or)
(define-arith-syntax and)
(define-arith-syntax xor)
(define-arith-syntax sra)
(define-arith-syntax srl)
(define-arith-syntax sll)
(define-lap-instruction sethi sparc/sethi)
(define-lap-instruction noop sparc/noop)
(define-lap-instruction save sparc/save)
(define-lap-instruction restore sparc/restore)
(define-lap-instruction iflush sparc/iflush)
(define-lap-instruction jmpl sparc/jmpl)

(set (table-entry lap-pseudo-ops 'mask)
     (table-entry lap-pseudo-ops 'and))

(define %%car 1)
(define %%cdr -3)
	   
(define native-registers 
  '((%g0 . 0)
    (%g1 . 1)
    (%g2 . 2)
    (%g3 . 3)
    (%g4 . 4)
    (%g5 . 5)
    (%g6 . 6)
    (%g7 . 7)
    (%o0 . 8)
    (%o1 . 9)
    (%o2 . 10)
    (%o3 . 11)
    (%o4 . 12)
    (%o5 . 13)
    (%sp . 14)
    (%o7 . 15)
    (%l0 . 16)
    (%l1 . 17)
    (%l2 . 18)
    (%l3 . 19)
    (%l4 . 20)
    (%l5 . 21)
    (%l6 . 22)
    (%l7 . 23)
    (%i0 . 24)
    (%i1 . 25)
    (%i2 . 26)
    (%i3 . 27)
    (%i4 . 28)
    (%i5 . 29)
    (%fp . 30)
    (%i7 . 31)))

(walk (lambda (pair)
	(*define orbit-env (car pair) (car pair)))
      native-registers)


(define %o0 ass-reg)
(define %o1 extra-args)
(define %o2 extra)  
(define %o3 parassign-extra)  
(define %o4 vector)  
(define %o5 scratch)  

(define %i0 a8)
(define %i1 a9)
(define %i2 a10)
(define %i3 A11)
(define %i4 AN)
(define %i5 AN+1)
(define %i7 crit-reg)

