(herald spemit)

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

              
(define (generate-move ref1 ref2)
  (if (neq? ref1 ref2)
      (cond ((and (pair? ref1) (null? (cdr ref1)))
	     (generate-move-address (car ref1) ref2))
	    ((register? ref2)
	     (cond ((register? ref1)
		    (emit risc/add ref1 zero ref2))
		   ((and (pair? ref1)
			 (eq? (car ref1) 'lit))
		    (move-small-number (cdr ref1) ref2))
		   (else
		    (emit risc/load 'l ref1 ref2))))
	    ((register? ref1)
	     (emit risc/store 'l ref1 ref2))
	    (else
	     (if (and (pair? ref1) (eq? (car ref1) 'lit))
		 (move-small-number (cdr ref1) extra)
		 (emit risc/load 'l ref1 extra))
	     (emit risc/store 'l extra ref2)))))

(define (generate-move-addressable x mreg)
  (if (eq? x 0) (generate-move zero mreg)
  (let ((reg (if (register? mreg) mreg extra)))
  (xcond ((eq? x '#t)
	  (emit risc/add (machine-true-value) zero reg))
         ((eq? x '#f)
	  (emit risc/add nil-reg zero reg))
         ((representable-fixnum? x 'move)
	  (move-small-number (fx* x 4) reg))
	 ((fixnum? x)
	 (emit sparc/sethi (unsigned-num
			 (fixnum-logand #x3fffff (fixnum-ashr x 8))) reg)
	 (emit risc/or
	       (unsigned-num (fixnum-logand #x3ff (fixnum-ashl x 2)))
	       reg reg))
	((char? x)
	 (let ((x (char->ascii x)))
	   (cond ((fx<= x #b1111)	;12 bits unsigned, yikes!
		  (emit risc/or (unsigned-num (fx+ (fixnum-ashl x 8)
						   header/char))
				    zero reg))
		 (else
		  (emit sparc/sethi (unsigned-num
				     (fixnum-bit-field x 2 6)) reg)
		  (emit risc/or (unsigned-num
				 (fx+ (fixnum-ashl (fixnum-logand #b11 x) 8)
				      header/char))
			reg reg))))))
  (generate-move reg mreg))))

(define (move-small-number x reg)
  (emit risc/add (machine-num x) zero reg))

(define (emit-noop)
  (emit sparc/noop))

                                     
(define (generate-move-address from to)
  (cond ((register? to)
         (if (or (atom? from)
                 (neq? (car from) to)
                 (neq? (cdr from) 0))
             (emit risc/add (machine-num (cdr from)) (car from) to)))
        (else
	 (emit risc/add (machine-num (cdr from)) (car from) extra)
         (emit risc/store 'l extra to))))

(define (need-stack-frame)
  (modify (lambda-max-temps *lambda*)
	  (lambda (max-temp)
	    (max 1 max-temp))))


(define (generate-move-pcrel from to)
  (need-stack-frame)
  (emit-branch-and-link 8) ;one past delay
  (let ((thing (tp-offset from)))	;this really stinks
    (cond ((register? to)
	   (emit sparc/sethi thing to)
	   (emit risc/or thing to to)
	   (emit risc/add to link-reg to))
	(else
	 (emit sparc/sethi thing extra)
	 (emit risc/or thing extra extra)
	 (emit risc/add extra link-reg extra)
	 (emit risc/store 'l extra to)))))
               
(define-integrable (generate-slink-call offset)
;  (need-stack-frame)
  (emit risc/load 'l (reg-offset nil-reg offset) extra)
  (emit sparc/jmpl (reg-offset extra 0) extra)
  (emit risc/add (machine-num template-return-offset) extra extra) ;3 template + current/delay
  (emit-bogus-stack-template))

(define-integrable (generate-slink-jump offset)
  (emit risc/load 'l (reg-offset nil-reg offset) extra)
  (emit sparc/jmpl (reg-offset extra 0) zero))

(define-integrable (generate-jump label)
  (emit-jump label))

(define-integrable (generate-avoid-jump label)
  (emit-avoid-jump label))

(define-integrable (generate-save-jump-and-link l)
  (emit-branch-and-link l)
  (emit risc/add (machine-num template-return-offset) link-reg link-reg)) ;skip template

(define-integrable (generate-save-avoid-jump-and-link l)
  (emit-branch-and-link l)
  (emit risc/add (machine-num template-return-offset) link-reg link-reg)) ;skip template


(define (generate-general-call-and-link proc-var n-args)
  (cond ((and (or (variable-binder proc-var)
		  (var-is-vcell? proc-var)))
	 (generate-move (machine-num (fx+ n-args 1)) NARGS)
	 (emit risc/load 'l (reg-offset nil-reg slink/icall) extra)
	 (emit sparc/jmpl (reg-offset extra 0) link-reg))
	(else
         (generate-move (machine-num (fx+ n-args 1)) NARGS)
	 (emit risc/load 'l (reg-offset P (fx- tag/extend CELL)) extra)
         (emit sparc/jmpl (reg-offset extra 2) link-reg)))
  (emit risc/add (machine-num template-return-offset) link-reg link-reg)) ;skip template
    

(define (generate-general-call proc-var n-args)
  (cond ((and (or (variable-binder proc-var)
		  (var-is-vcell? proc-var)))
	 (emit risc/load 'l (reg-offset nil-reg slink/icall) extra)
	 (emit sparc/jmpl (reg-offset extra 0) zero)
	 (generate-move (machine-num (fx+ n-args 1)) NARGS))
	(else
         (emit risc/load 'l (reg-offset P (fx- tag/extend CELL)) extra)
	 (emit sparc/jmpl (reg-offset extra 2) zero)
         (generate-move (machine-num (fx+ n-args 1)) NARGS))))


(define (generate-return n-args)               
  (emit sparc/jmpl (reg-offset link-reg 0) zero)
  (generate-move (machine-num (fx- -1 n-args)) NARGS))

(define (emit op . args)
  (asemit op (map! ->field-group args)))


(define (->field-group operand)
  (xcond ((fixnum? operand)
	  (register->field-group operand))
         ((atom? operand) operand)
         ((fixnum? (car operand))
	  (list 'reg-offset (symbolic->machine-reg (car operand)) (cdr operand)))
	 ((atom? (car operand)) operand)))

(define (symbolic->machine-reg reg) reg)

(define (register->field-group reg)
  (xcond ((fx< reg *real-registers*) (symbolic->machine-reg reg))
         ((fx< reg *slots*)
	  (list 'reg-offset FP
	       (fx* CELL (fx- reg *real-registers*))))))



(define (generate-future node)
  (let* ((lam ((call-arg 2) node))
	 (closure (environment-closure (lambda-env lam))))
    (cond ((eq? closure *unit*)
	   (lambda-queue lam)
	   (free-register node AN)
	   (lock AN)
	   (generate-move (access-value node lam) AN))
	  (else
	   (make-heap-closure node closure)
	   (lock AN)))
    (free-register node AN-1)
    (unlock AN)
    (generate-slink-call slink/*future)
    (mark-continuation node AN))) 
