(herald orbit_changes)

(set (print-env-warnings?) nil)
(set *compile-primops?* nil)
(define (cs x) (create-support x x))
;(set (table-entry *modules* 'bignum) '(osys vax_bignum))
(load-quietly '(mp marchconstants t) orbit-env)
(set (orbit-syntax-table) (env-syntax-table t-implementation-env))
(comment
(walk load '((assembler expand)
                (assembler fg_spec)  
             (assembler fg_expr)  
          (assembler as_syntax)))
)

(define *files*
  '((mfe fix)
    (mbe strategy)
    (mbe live)
    (mbe closure)
    (mbe bookkeep)
    (mbe generate)
    (mbe generate_y)
    (mbe parassign)
    (mbe reg)
    (mbe lookup)
    (mbe comex)
    (mbe marchbookkeep)
    (mbe marchgen)
    (mbe marchlocgen)
    (mbe marcharithgen)
    (mbe marchemit)
    (mbe as)
    (mbe marchas)
    (mbe marchis)
    ))

(define (orbit-march-setup directory)
  (set *object-file-extension* 'cho)
  (set *information-file-extension* 'chi)
  (set *noise-file-extension* 'chn)
  (orbit-setup directory)
  (set (table-entry *modules* 'constants) `(,directory marchconstants))
  (set (table-entry *modules* 'primops)   `(,directory marchprimops))
  (set (table-entry *modules* 'arith)     `(,directory marcharith))
  (set (table-entry *modules* 'low)       `(,directory marchlow))
  nil)

(define (orbit-march-init . directory)
  (orbit-march-setup (if directory (car directory) '#f))
  (orbit-init 'base
              'constants
              'primops
              'locations
              'low
              'open
              'carcdr
              'arith
              'aliases))


(define (make-proclaims types)
  (iterate loop ((types types) (vars '()) (procs '()))
    (cond ((null? types)
           (return (reverse! vars) (reverse! procs)))
          (else
           (let ((var (generate-symbol 't)))
             (loop (cdr types) (cons var vars) (cons var procs)))))))

(eval '(define-syntax (future expr)
	 `(*future (,(t-syntax 'lambda) () ,expr)))
      t-implementation-env)

(block (set *t-exports* (cons '*future *t-exports*)) nil)
(walk (lambda (x) (load x orbit-env)) *files*)
;(load-if-present '(mbe fix) orbit-env)

(orbit-march-init 'mp)

(comment
(define (comsys system . start)
  (walk (lambda (file)
	  (xcase (car file)
            ((osys)
	     (set (tc-syntax-table) (env-syntax-table t-implementation-env))
	     (comfile file))
	    ((t3_primops)
	     (set (tc-syntax-table) primop-syntax-table)
	     (bind ((write-support-file false))
	       (comfile file)))))
	(let ((files (xcase system
		       ((z) *zvm-system*)
		       ((t) *t-system*))))
	  (if start (mem alikev? (car start) files) files))))
)	
#|

  (let* ((link-env (make-locale orbit-env 'link-env)))
    (*define standard-env 'link-env link-env)
    (load '(mlink defs )         link-env)
    (load '(mlink linker )       link-env)
    (load '(mlink march_link) link-env)
    (load-if-present '(mlink fix) link-env)
    (*define standard-env  'link (*value link-env 'link)))
|#


(*define user-env 'listing (*value orbit-env 'quicklist))

(set (print-env-warnings?) t)

