/* National Institute of Standards and Technology (NIST)
/* National Computer System Laboratory (NCSL)
/* Office Systems Engineering (OSE) Group
/* ********************************************************************
/*                            D I S C L A I M E R
/*                              (March 8, 1989)
/*  
/* There is no warranty for the NIST NCSL OSE SGML parser and/or the NIST
/* NCSL OSE SGML parser validation suite.  If the SGML parser and/or
/* validation suite is modified by someone else and passed on, NIST wants
/* the parser's recipients to know that what they have is not what NIST
/* distributed, so that any problems introduced by others will not
/* reflect on our reputation.
/* 
/* Policies
/* 
/* 1. Anyone may copy and distribute verbatim copies of the SGML source
/* code as received in any medium.
/* 
/* 2. Anyone may modify your copy or copies of SGML parser source code or
/* any portion of it, and copy and distribute such modifications provided
/* that all modifications are clearly associated with the entity that
/* performs the modifications.
/* 
/* NO WARRANTY
/* ===========
/* 
/* NIST PROVIDES ABSOLUTELY NO WARRANTY.  THE SGML PARSER AND VALIDATION
/* SUITE ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
/* EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
/* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
/* THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS
/* WITH YOU.  SHOULD THE SGML PARSER OR VALIDATION SUITE PROVE DEFECTIVE,
/* YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
/* 
/* IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NIST BE LIABLE FOR
/* DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR OTHER SPECIAL,
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
/* INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA
/* BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A
/* FAILURE OF THE PROGRAM TO OPERATE WITH PROGRAMS NOT DISTRIBUTED BY
/* NIST) THE PROGRAM, EVEN IF YOU HAVE BEEN ADVISED OF THE POSSIBILITY OF
/* SUCH DAMAGES, OR FOR ANY CLAIM BY ANY OTHER PARTY.
*/

/************************************************************************/
/*   TITLE:          SGML PARSER                                        */
/*   SYSTEM:         DTD PROCESSOR                                      */
/*   SUBSYSTEM:                                                         */
/*   SOURCE FILE:    DTD.H                                              */
/*   AUTHOR:         Jim Heath                                          */
/*                                                                      */
/*   DATE CREATED:                                                      */
/*   LAST MODIFIED:                                                     */
/*                                                                      */
/*                  REVISIONS                                           */
/*   WHEN      WHO            WHY                                       */
/************************************************************************/
#define PERROR(x)	{perror(x); exit(1);}
#define REGISTER register
#define TREEFILE	(1 << 0) 
#define SYMBFILE	(1 << 1)
#define ATTRTEMP	(1 << 2)
#define PREFFILE	(1 << 3)
#define GREFFILE	(1 << 4)
#define ATTRFILE	(1 << 5)
#define DOCFILE		(1 << 6)
#define XCPTFILE	(1 << 7)
#define DTDFILE		(1 << 8)
#define POSFILE     (1 << 9)
#define INCLFILE    (1 << 10)
#define EXCLFILE    (1 << 11)
#define CMFILE      (1 << 12)
#define ENTITYFILE  (1 << 13)
/* ======================================================== */
typedef char SGMLNAME [NAMELEN + 1];
/* ======================================================== */
#define NOTATIONFLAG 	(1 << 0)
#define CONREFFLAG      (1 << 1)
/* ======================================================== */
#define      IN_DECL            (1 << 0)
#define      IN_ENTITY          (1 << 1)
#define      DECL_IS_IN_ENTITY  (1 << 2)

#define      SETFLAG(x)         (specflag |= x)
#define      TESTFLAG(x)        ((specflag & x) == x)
#define      CLEARFLAG(x)       (specflag &= (~(x)))
/* ======================================================== */
#define      EOS                '\0'
#define      DOCTYPELEN         9
#define      FPRINTF(list)      fprintf list
/* ======================================================== */
#define INPNAME(ptr, len, xlat) inpitem (ptr, len, \
                                         isnmstrt, isnmchar, xlat, NO)
#define INPNBR(ptr, len, xlat) inpitem (ptr, len, \
                                        ISDIGIT, ISDIGIT, xlat, NO)
#define INPRNINAME(ptr, len, xlat) inpitem (ptr, len, \
                                            isnmstrt, isnmchar, xlat, YES)

#define INPNMTOKEN(ptr, len, xlat) inpitem (ptr, len, \
                                            isnmchar, isnmchar, xlat, NO)
#define INPNUMTOKEN(ptr, len, xlat) inpitem (ptr, len, \
                                            ISDIGIT, isnmchar, xlat, NO)

/* ======================================================== */
/* defines representing the number of characters comprising */
/* one pair of appropriate delimeters.                      */
/* ======================================================== */
#define STARTTAGSIZE   2   /* < > */
#define ENDTAGSIZE     3   /* </ > */
#define MSSIZE         6   /* <![ ]]> */
#define MDSIZE         3   /* <! > */
/* ======================================================== */
/* defines to be used in inputing separator chracters.      */
/* ======================================================== */
#define PS             0
#define TS             1    /* defines reprsenting separator types */
#define DS             2
#define INPPS() inpsep(PS) /* macro def for inputting PS's */
#define INPDS() inpsep(DS) /* macro def for inputting DS's */
/* ======================================================== */

#define CLRDECL()       dodecl(ON, NULL, (char *)NULL, (char **)NULL)
#define ADDCHAR(c)      dodecl(OFF, c, (char *)NULL, (char **)NULL)
#define ADDSTRING(ptr)  dodecl(OFF, NULL, ptr,(char **)NULL)
#define GETDECLADDR(ptr) dodecl(OFF, NULL, (char *)NULL, ptr)
/* ======================================================== */
/* defines representing entity name types.                  */
/* ======================================================== */
#define PARM_ENT_NAME  0  /* parameter entity name type */
#define GEN_ENT_NAME   1  /* general entity name type */
/* ======================================================== */
/* defines used in the processing of the document type      */
/* definition.                                              */
/* ======================================================== */
typedef enum {KW_DOCTYPE = 200, KW_ELEMENT, KW_ENTITY, KW_RNIDEFAULT,
              KW_ANY, KW_CDATA, KW_RCDATA, KW_SDATA, KW_PI, KW_EMPTY,
              KW_STARTTAG, KW_ENDTAG, KW_MS, KW_MD, KW_ATTLIST,
              KW_ID, KW_IDREF, KW_IDREFS, KW_NAME, KW_NAMES,
              KW_NMTOKEN, KW_NMTOKENS, KW_NOTATION, KW_NUMBER,
              KW_NUMBERS, KW_NUTOKEN, KW_NUTOKENS, KW_REQUIRED,
              KW_CURRENT, KW_CONREF, KW_IMPLIED, KW_FIXED, KW_GROUP,
              KW_LIT, KW_UNFIXED, KW_SYSTEM, KW_PUBLIC, KW_NDATA
              } KEYWORDS;
/* ======================================================== */
/* define representing the largest length of a number used  */
/* as a "character number" within a character reference.    */
/* ======================================================== */
#define MAX_CHAR_IN_DELIM_NUM  NAMELEN
/* ======================================================== */
#define      CMTRC              (1 << 1)
#define      SIMPTRC            (1 << 2)
#define      CONTEXTTRC         (1 << 3)
#define      FILETRC            (1 << 4)
#define      FUNCTRC            (1 << 5)
#define      WAITFORCR          (1 << 6)
#define      ALLOWSYNTXERRS     (1 << 7)
/* ======================================================== */

#define      MAXELTS            256
#define      ABORT(x)           syntxerr(x)
#define      MAXDFLTLEN         512
/* ======================================================== */
#define     ERROR      -1
#ifndef     NO
#define     NO         0
#endif
#ifndef     YES
#define     YES        1
#endif
#ifndef     FALSE
#define     FALSE      0
#endif
#ifndef     TRUE
#define     TRUE       1
#endif
#ifndef     NULL
#define     NULL      '\0'
#endif

#define     NONE       0
#define     CTRLZ      0x1A
#define     SPACE      ' '
#define     RE         0x0D
#define     RS         0x0A
#define     TAB        0x09
#define     OFF        0
#define     ON         1
#define     BAD        0
#define     GOOD       1
#define     MDC        '>'
#define     GRPO       '('
#define     GRPC       ')'
#define     DSO        '['
#define     DSC        ']'
#define     PERO       '%'
#define     ERO        '&'
#define     LIT        '"'
#define     LITA       0x27
#define     REFC       ';'
#define     CR         0x0D
#define     LF         0x0A
#define     ILLCHAR    (char) 0xFF
#define     RNI        '#'
#define     EE         (char) 0xFE
/* ======================================================== */
#ifndef     SEEK_STRT
#define     SEEK_STRT     0
#endif
#ifndef     SEEK_CURRENT
#define     SEEK_CURRENT   1
#endif
#ifndef     SEEK_END
#define     SEEK_END       2
#endif
/* ======================================================== */
/* ======================================================== */


#define    GETC(a)       getc(a)
#define    UNGETC(a,b)     ungetc(a,b)
/* ======================================================== */
/*
   CONTEXT CODE (enum)
                 - this field is used to indicate the contextual requiredness
                   of a given token; its values are given by:
*/
   typedef enum  CONTEXT  {C_NEVERO,      /* NEVER OMISSABLE 
                                          ex. A in   (A?, B)            */
                           C_ALWAYSO,     /* ALWAYS OMISSABLE 
                                          ex. A in   (A, B)             */
                           C_SOMETIMESO,  /* SOMETIMES OMISSABLE
                                          ex. B in   (A?, B)*           */
                           C_FTO,         /* OMISSABLE FIRST TIME ONLY
                                          ex. A in (A+, B)              */
                           C_FTOWR,       /* OMISSABLE FIRST TIME THEN RESET 
                                          ex. B in (A, B+)+             */
                           C_FTOTSO};     /* FIRST TIME OMISSABLE THEN 
                                             SOMETIMES OMISSABLE 
                                          ex. B in (A?, B+)+            */
/* ======================================================== */

typedef    struct  TREEREC {
   char    Tinfo[8];
   int     Toi;
   int     Tcontreq;
} TREEREC;

typedef    struct  SYMBREC{
   int    Smin;
   char    Sname[NAMELEN];
   int    Sid;
} SYMBREC;

typedef    struct  {
   int     Dtoken;
   int     Doi;
   enum CONTEXT     Dcontreq;
} DTDREC;

/* ======================================================== */
#define     SYMTBLREF           'x'
/* ======================================================== */
#define     COMMA               -21
#define     AMPERSAND           -22
#define     AND                 AMPERSAND
#define     OR                  -23
#define     ENDAND              -25
/* ======================================================== */
/* ======================================================== */
/* ======================================================== */

/* the following documents the structure of the attribute file passed
   from the DTD processor; the file will (until we decide what to do
   with file options) be in D:DTDATTRIB.DAT.  The format is:

   TOKEN ID (int) 
                 - this will associate the following attributes with
                   an element name found in the symbol table.
   NUMBER of ATTRIBS (int)
                 - this is a count of the number of attributes associated
                   with the current element.
   ATTRIBUTE NAME (NAMELEN bytes, LJBF)
                 - this field contains the name of the attribute.
   DECLARED VALUE TOKEN (enum)
                 - this field contains a token for the declared value of
                   the attribute; it's values are given by:
*/
typedef enum declval {GROUP, ENUM_CDATA, ENTITY, ID, IDREF, NAME, NMTOKEN, 
               NUTOKEN, IDREFS, NAMES, NMTOKENS, NUTOKENS, NOTATION, 
               NUMBER, NUMBERS} DECLVAL;
/*
   DEFAULT CODE (enum)
                 - this field is used to indicate options for the default
                   value; it's values are given by:
*/
   typedef enum  adflt  {A_REQD, A_CURRENT, A_IMPLIED, A_UNFIXED,
                    A_FIXED, A_CONREF} ADFLT;

/*
   DEFAULT VALUE (ASCII Z-String)
                 - this field contains the default value for this 
                   attribute; this field is always present but may consist
                   of only the End-of-String ('\0') byte.
   NUMBER OF ITEMS IN GROUP (int)
                 - this field contains the count of the number of items 
                   in the group.
   DECLARED VALUES (NAMELEN bytes LJBF)
                 - this field contains the declared value(s) of the 
                   attribute; each value is null terminated with no
                   padding.
*/


