/* National Institute of Standards and Technology (NIST)
/* National Computer System Laboratory (NCSL)
/* Office Systems Engineering (OSE) Group
/* ********************************************************************
/*                            D I S C L A I M E R
/*                              (March 8, 1989)
/*  
/* There is no warranty for the NIST NCSL OSE SGML parser and/or the NIST
/* NCSL OSE SGML parser validation suite.  If the SGML parser and/or
/* validation suite is modified by someone else and passed on, NIST wants
/* the parser's recipients to know that what they have is not what NIST
/* distributed, so that any problems introduced by others will not
/* reflect on our reputation.
/* 
/* Policies
/* 
/* 1. Anyone may copy and distribute verbatim copies of the SGML source
/* code as received in any medium.
/* 
/* 2. Anyone may modify your copy or copies of SGML parser source code or
/* any portion of it, and copy and distribute such modifications provided
/* that all modifications are clearly associated with the entity that
/* performs the modifications.
/* 
/* NO WARRANTY
/* ===========
/* 
/* NIST PROVIDES ABSOLUTELY NO WARRANTY.  THE SGML PARSER AND VALIDATION
/* SUITE ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
/* EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
/* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
/* THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS
/* WITH YOU.  SHOULD THE SGML PARSER OR VALIDATION SUITE PROVE DEFECTIVE,
/* YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
/* 
/* IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NIST BE LIABLE FOR
/* DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR OTHER SPECIAL,
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
/* INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA
/* BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A
/* FAILURE OF THE PROGRAM TO OPERATE WITH PROGRAMS NOT DISTRIBUTED BY
/* NIST) THE PROGRAM, EVEN IF YOU HAVE BEEN ADVISED OF THE POSSIBILITY OF
/* SUCH DAMAGES, OR FOR ANY CLAIM BY ANY OTHER PARTY.
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>


int appflag = 0;
char docname[128], pathname[128], entfilename[128], noption[128],
foption[128], hoption[128], poption[128], coption[128], debug1[128],
debug2[128], debug2a[128], debug3[128];

/*global*/  int main();
/*global*/  void process();
/*global*/  void error();
/*global*/  void doparse1();
/*global*/  void doparse1a();
/*global*/  void doparse2a();
/*global*/  void doparse2b();
/*global*/  void doparse3();
/*global*/  void showline();

/* =============================================================== */
main(argc, argv)
int argc;
char *argv[];
{
   int j;
   printf("\n\nNBS FIPS-SGML Reference Parser\n\n");
   printf("Version 1.01\n");
   fflush(stdout);
   if (argc <= 1)
      error("insufficient number of arguments");
   for (j = 1; j < argc; j++)
      process(argv[j]);
   doparse1();
   doparse1a();
   doparse2a();
   doparse2b();
   doparse3();
}
/* =============================================================== */
void process (arg)
unsigned char *arg;
{
   unsigned char temp[128];
   int infile, len;
   /* if this is the document name */
   if(*arg != '-') {
      if ((infile = open(arg, 0)) == -1){
         sprintf(temp, "unable to open document file:  %s", arg);
         error(temp);
      }
      close(infile);
      strcpy(docname, arg);
      return;
   }
   arg++;
   *arg = toupper(*arg);
   switch(*arg) {
   case 'S':
      appflag = 1;
      return;
   case 'T':
      strcpy(pathname, arg - 1);
      len = strlen(pathname) - 1;
      if (pathname[len] != '\\'){
         pathname[len + 1] = '\\';
         pathname[len + 2] = '\0';
      }
      return;
   case 'P':
      strcpy(entfilename, arg - 1);
      return;
   case 'N':
      strcpy(noption, "-N");
      return;
   case 'F':
      strcpy(foption, "-F");
      return;
   case 'H':
      strcpy(hoption, "-H");
      return;
   case '1':
      strcat(debug1, (arg - 1));
      strcat(debug1, " ");
      return;
   case '2':
      strcpy(debug2, (arg - 1));
      return;
   case 'A':
      strcpy(debug2a, (arg - 1));
      return;
   case '3':
      strcpy(debug3, (arg - 1));
      return;
   case 'X':
      return;
   default:
      sprintf(temp, "illegal command line option:  %s", (arg - 1));
      error(temp);
   }
}
/* =============================================================== */
void error(msg)
unsigned char *msg;
{
   printf("%s\n",msg);
   exit(1);
}
/* =============================================================== */
void doparse1()
{
   char *arg[10];
   int status;
   arg[0] = "parse1";
   arg[1] = docname;
   /*arg[2] = pathname;*/
   arg[2] = NULL;
   arg[3] = entfilename;
   arg[4] = debug1;
   arg[5] = foption;
   arg[6] = hoption;
   arg[7] = poption;
   arg[8] = NULL;
   showline(arg);
   if (fork() == 0) {
      exit(execv("./parse1", arg));
   }
   wait(&status);
   if (status != 0)
      exit(1);
}
/* =============================================================== */
void doparse1a()
{
   char *arg[10];
   int status;
   arg[0] = "parse1a";
   arg[1] = pathname;
   arg[2] = NULL;
   showline(arg);
   if (fork() == 0) {
      exit(execv("./parse1a", arg));
   }
   wait(&status);
   if (status != 0)
      exit(1);
}

/* =============================================================== */
void doparse2a()
{
   char *arg[10];
   int status;
   arg[0] = "parse2a";
   arg[1] = pathname;
   arg[2] = debug2a;
   arg[3] = foption;
   arg[4] = hoption;
   arg[5] = NULL;
   showline(arg);
   if (fork() == 0) {
      exit(execv("./parse2a", arg));
   }
   wait(&status);
   if (status != 0)
      exit(1);
}
/* =============================================================== */
void doparse2b()
{
   char *arg[10];
   int status;
   arg[0] = "parse2b";
   arg[1] = pathname;
   arg[2] = debug2a;
   arg[3] = foption;
   arg[4] = hoption;
   arg[5] = NULL;
   showline(arg);
   if (fork() == 0) {
      exit(execv("./parse2b", arg));
   }
   wait(&status);
   if (status != 0)
      exit(1);
}
/* =============================================================== */
void doparse3()
{
   int status;
   char *arg[10];
   char temp[256], temp2[256];
   int posfile, argindex = 0;
   long pos;
   strcpy(temp,pathname + 2);
   strcat(temp,"posfile.sgm");
   if ((posfile = open(temp,0)) == -1){
      sprintf(temp2,"unable to open %s", temp);
      error(temp2);
   }
   if (read(posfile, &pos, sizeof(pos)) != sizeof(pos)){
      sprintf(temp2,"error in reading %s", temp);
      error(temp2);
   }
   if(close(posfile) == -1){
      sprintf(temp2,"error in closing %s", temp);
      error(temp2);
   }
   unlink(temp);
   arg[argindex++] = "parse3";
   arg[argindex++] = docname;
   sprintf(temp2, "-P%ld", pos);
   arg[argindex++] = temp2;
   arg[argindex] = NULL;
   showline(arg);
   if (fork() == 0) {
      exit(execv("./parse3", arg));
   }
   wait(&status);
   if (status != 0)
      exit(1);
}
/* =============================================================== */
void showline(arg)
unsigned char *arg[];
{
   int j = 0;

   while (arg[j] != NULL)
      printf("%s ",arg[j++]);
   printf("\n");
}
/* =============================================================== */
