# conversion_service (C) JBH 2000
# make xxx from ps file


# version history
set pdf_service_ver "\$Id: tiff_service.tcl,v 1.1 2000-12-21 07:36:11+01 jbh Exp jbh $"
#   1.0     first release
#   1.1     initial directories changed if no config is found
#           output of tcl version in start-up error message
#           bug in save_conf removed 
#           more accurate .f_status (float)

#
# genral program setup
#
#set bytes_cp 0
wm resizable . 0 0
# buttons and label for program control
label .status -text idle
pack .status 
label .f_status -text ""
pack .f_status 
frame .fr_butt 
pack .fr_butt -side right
button .fr_butt.exit -text exit -command exit -width 10
pack .fr_butt.exit  -fill both -padx 3 -pady 3
button .fr_butt.go -text go -command go -width 10
pack .fr_butt.go  -fill both -padx 3 -pady 3
button .fr_butt.stop -text stop -command stop -width 10
pack .fr_butt.stop  -fill both -padx 3 -pady 3
button .fr_butt.conf -text settings -command conf  -width 10
pack .fr_butt.conf  -fill both -padx 3 -pady 20
# setting up status history
set hist_length 10
frame .fr_hist -relief sunken -borderwidth 3
pack .fr_hist -side left
for {set index 0} {$index<$hist_length} {incr index} {
    puts $index
    label .fr_hist.history$index -text "" -width 64 -justify left
    pack .fr_hist.history$index
}






# configuration window
toplevel .config
wm resizable .config 0 0
wm withdraw .config
label .config.src_l -text "source path"
grid .config.src_l -row 1 -col 0
entry .config.source -text "" -width 65
grid .config.source -row 1 -col 1
button .config.bt_source -text "browse" -width 10 -command set_source
grid .config.bt_source -row 1 -col 2
entry .config.prg -text "" -width 65
# coming from evo_trans changed to gswin path
label .config.prg_l -text "gswin32 path"
grid .config.prg_l -row 2 -col 0
grid .config.prg -row 2 -col 1
button .config.bt_prg -text "browse" -width 10 -command set_prg
grid .config.bt_prg -row 2 -col 2
label .config.trg_l -text "target path"
grid .config.trg_l -row 3 -col 0
entry .config.target -text "" -width 65
grid .config.target -row 3 -col 1
button .config.bt_targ -text "browse" -width 10  -command set_target
grid .config.bt_targ -row 3 -col 2
label .config.res_l -text resolution
grid .config.res_l -row 4 -col 0
frame .config.res_f
grid .config.res_f -row 4 -col 1
entry .config.res_f.res -text 300
pack .config.res_f.res -side left
button .config.res_f.b150 -text 150  -width 8 -command {set_res 150 }
pack .config.res_f.b150 -side left
button .config.res_f.b300 -text 300  -width 8 -command {set_res 300 }
pack .config.res_f.b300 -side left
button .config.res_f.b600 -text 600  -width 8 -command {set_res 600 }
pack .config.res_f.b600 -side left
button .config.res_f.b1200 -text 1200  -width 8 -command {set_res 1200 }
pack .config.res_f.b1200 -side left
label .config.dev_l -text device
grid .config.dev_l -row 5 -col 0
frame .config.dev_f
grid .config.dev_f -row 5 -col 1
entry .config.dev_f.dev -text pdfwrite 
pack .config.dev_f.dev -side left
button .config.dev_f.btiffg4 -text tiffg4  -width 8 -command {set_device tiffg4 tif}
pack .config.dev_f.btiffg4 -side left
button .config.dev_f.bpdf -text pdf -width 8 -command {set_device pdfwrite pdf}
pack .config.dev_f.bpdf -side left
button .config.dev_f.bpng -text png -width 8 -command {set_device png16m png}
pack .config.dev_f.bpng -side left
button .config.dev_f.bjpeg -text jpeg -width 8 -command {set_device jpeg jpg}
pack .config.dev_f.bjpeg -side left

label .config.ext_l -text extension
grid .config.ext_l -row 6 -col 0
frame .config.ext_f
grid .config.ext_f -row 6 -col 1
entry .config.ext_f.ext -text pdf 
pack .config.ext_f.ext -side left

button .config.bt_back -text "back" -width 10  -command back_main
grid .config.bt_back -row 7 -col 1


#
# setting output device
#
proc set_device { dev ext } {
    .config.dev_f.dev delete 0 end
    .config.dev_f.dev insert 0 $dev
    .config.ext_f.ext delete 0 end
    .config.ext_f.ext insert 0 $ext
                        }

#
# setting output resolution
#
proc set_res { res } {
    .config.res_f.res delete 0 end
    .config.res_f.res insert 0 $res
                        }




#
# stop running
#
proc stop {} {
.status config -text idle

}

#
# update history (moving all fields up and adding new item at end
#
proc update_history {new_entry} {
global hist_length
for {set index 1} {$index<$hist_length} {incr index} {
    set b_index [expr $index -1]
    .fr_hist.history$b_index configure -text [.fr_hist.history$index cget -text]
}
    .fr_hist.history[expr $hist_length -1] configure -text [file nativename $new_entry]
}

#
# start the checking process
#
proc go {} {
    global bytes_cp
    set src [.config.source get]
    set prg [.config.prg get]
    set trg [.config.target get]
    set ext [.config.ext_f.ext get]
    set res [.config.res_f.res get]
    set dev [.config.dev_f.dev get]
    set a ""
    # setting status to running
    .status configure -text running...
    for {set c 1} {$c>0} {set c 1} {
        update
        if {[string compare [.status cget -text]  idle]==0} {break}
#        set b $a
        set a [glob -nocomplain [file join $src *.ps] [file join $src *.prn]]
        after 50
        if {[llength $a]>0} { 
            set f_src  [lrange $a 0 0]
            set mt1 [file mtime $f_src]
            after 500
            set mt2 [file mtime $f_src]  
            after 500
            if {$mt1==$mt2 && [file readable $f_src]==1} {
                set f_trg [file rootname [file join $trg [file tail $f_src]]].$ext
                .f_status configure -text [format "converting file %s" [file tail $f_src]]
                set cmdline [file nativename $prg] 
                append cmdline " -dNOPAUSE -dSAFER -sDEVICE=$dev -r$res   -sOutputFile="
#                append cmdline " -dNODISPLAY -dBATCH -dNOPAUSE -dSAFER -sDEVICE=pdfwrite  -r1200  -sPAPERSIZE=a4  -sOutputFile="
                append cmdline [file nativename $f_trg ]
                append cmdline " " [file nativename $f_src]
#                dbg $cmdline
                update
                .f_status configure -text [format "converting file %s " [file tail $f_src] ]
                update
                 set outID [open gs_jbh.bat w+]
                 puts $outID $cmdline
                 close $outID
                 catch [exec  gs_jbh.bat] gs_error
#                 exec  gs_jbh.bat
#                 dbg $gs_error
#                 exec $prg $cmdline
                 file delete gs_jbh.bat
                .f_status configure -text ""
                update_history [format "%s processed" $f_src]
                update
                file copy -force $f_src $trg
                file delete $f_src
                                           }
        }
    }
}

#
# 
#
proc conf {} {
#wm withdraw .
grab set .config
stop
wm deiconify .config

}


proc back_main {} {
save_conf
grab release .config
wm withdraw .config
wm deiconify .
}


proc set_source {} {
    set ini_path [.config.source get]
    if {[file isdirectory $ini_path]==0} {set ini_path [pwd]}
    set new_path [tk_chooseDirectory -initialdir $ini_path -title "set source path" -mustexist true -parent .config]
    if {[file isdirectory $new_path]==1} {
        .config.source delete 0 end
        .config.source insert 0 $new_path
    }
}


proc set_prg {} {
    set ini_val [.config.prg get]
    set ini_prg [file tail $ini_val]
    set ini_path [file dirname $ini_val]
    if {[file isfile $ini_val]==0} {
        set ini_prg gswin32c.exe
        set ini_path [pwd]
        }
    set new_prg [tk_getOpenFile -initialfile $ini_prg -initialdir $ini_path -title "set gswin32c path" -parent .config]
    if {[file isfile $new_prg]==1} {
        .config.prg delete 0 end
        .config.prg insert 0 $new_prg
    }
}

proc set_target {} {
    set ini_path [.config.target get]
    if {[file isdirectory $ini_path]==0} {set ini_path [pwd]}
    set new_path [tk_chooseDirectory -initialdir $ini_path -title "set target path" -mustexist true -parent .config]
    if {[file isdirectory $new_path]==1} {
        .config.target delete 0 end
        .config.target insert 0 $new_path
    }
}


proc save_conf {} {
if {[file isfile convert.cnf]==1} {
if {[file writable convert.cnf]==0} {
    tk_messageBox -message "Unable to write configuration file convert.cnf" -icon error -title "write error" -type ok 
    return
                                      }
                                    }
    set outID [open convert.cnf w+]
    puts $outID [.config.source get]
    puts $outID [.config.prg get]
    puts $outID [.config.target get]
    puts $outID [.config.res_f.res get]
    puts $outID [.config.dev_f.dev get]
    puts $outID [.config.ext_f.ext get]
    close $outID
}


proc load_conf {} {
if {[file exists convert.cnf]==1} {
    set inID [open convert.cnf r]
    .config.source delete 0 end
    .config.prg delete 0 end
    .config.target delete 0 end
    .config.source insert 0 [gets $inID]
    .config.prg insert 0 [gets $inID]
    .config.target insert 0 [gets $inID]
    .config.res_f.res delete 0 end
    .config.res_f.res insert 0 [gets $inID]
    .config.dev_f.dev delete 0 end
    .config.dev_f.dev insert 0 [gets $inID]
    .config.ext_f.ext delete 0 end
    .config.ext_f.ext insert 0 [gets $inID]
    
    close $inID
} else {
    tk_messageBox -message "Unable to open configuration file convert.cnf" -icon error -title "read error" -type ok 
}
}


proc dbg {msg} {
      tk_messageBox -message $msg -icon info -title "jbh debug" -type ok 

            }


set ver [info tclversion]
if {$ver>8.2} {
tk_messageBox -message [format "%s by jbh 2000 running under tcl/tk version %s" $pdf_service_ver $ver] -icon info -title "pdf service" -type ok 
              } else {
    tk_messageBox -message [format "You are using tcl/tk %s but at least version 8.3 is required" $ver] -icon error -title "dwg trans" -type ok 
    exit
                     }                  
load_conf
go