/*-
 * Proc_Detach.c --
 *	Simulate the Proc_Detach Sprite kernel call under UNIX.
 *
 * Copyright (c) 1986, 1988 by the Regents of the University of California
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 *
 */
#ifndef lint
static char rcsid[] =
	"$Header: /sprite/src/lib/mx/RCS/Proc_Detach.unix,v 1.1 90/01/29 14:04:49 ouster Exp $ SPRITE (Berkeley)";
#endif lint

#include <sprite.h>
/*-
 *-----------------------------------------------------------------------
 * Proc_Detach --
 *	Detach a process from its parent so the parent needn't wait for it
 *	any longer. The closest we can come to this under UNIX is to fork
 *	and have the parent exit so when the parent does wait for the
 *	child, it returns immediately. More we cannot do...
 *	None of the exit handlers are called when the parent to the
 *	newly-forked child exits. This is to avoid conflicts with the
 *	processes' streams.
 *
 * Results:
 *	A return status
 *
 * Side Effects:
 *	An extra process is created and continues in the place of the one
 *	which originally called Proc_Detach. That process exits with the
 *	given status.
 *-----------------------------------------------------------------------
 */
ReturnStatus
Proc_Detach (status)
    int		  status;     /* Status to pass to parent */
{
    int		  cPid;	      /* PID of newly-created child */

    cPid = fork();
    if (cPid < 0) {
	return 1;
    } else if (cPid != 0) {
	_exit (status);
    	/*NOTREACHED*/
    } else {
	return 0;
    }
}
