'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_StringMatch.man,v 1.1 89/05/15 16:15:36 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_StringMatch tcl
.VS
.BS
.SH NAME
Tcl_StringMatch \- test whether a string matches a pattern
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
int
\Tcl_StringMatch\fR(\fIstring\fR, \fIpattern\fR)
.SH ARGUMENTS
.AP char *string in
String to test.
.AP char *pattern in
Pattern to match against string.  May contain special
characters from the set *?\e[].
.BE

.SH DESCRIPTION
.PP
This utility procedure determines whether a string matches
a given pattern.  If it does, then \fBTcl_StringMatch\fR returns
1.  Otherwise \fBTcl_StringMatch\fR returns 0.  The algorithm
used for matching is the same algorithm used in the ``string match''
Tcl command and is similar to the algorithm used by the C-shell
for file name matching;  see the Tcl manual entry for details.

.SH KEYWORDS
match, pattern, string
.VE
