/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.EventDeleter;
import tcl.lang.IdleHandler;
import tcl.lang.TclEvent;
import tcl.lang.TclRuntimeError;
import tcl.lang.TimerEvent;
import tcl.lang.TimerHandler;

public class Notifier {
    private static Hashtable notifierTable = new Hashtable();
    private TclEvent firstEvent;
    private TclEvent lastEvent;
    private TclEvent markerEvent;
    Thread primaryThread;
    Vector timerList;
    int timerGeneration;
    boolean timerPending;
    Vector idleList;
    int idleGeneration;
    int refCount;

    /*
     * WARNING - void declaration
     */
    public static synchronized Notifier getNotifierForThread(Thread thread) {
        void var1_1;
        Notifier notifier = (Notifier)notifierTable.get(thread);
        if (notifier == null) {
            notifier = new Notifier(thread);
            notifierTable.put(thread, notifier);
        }
        return var1_1;
    }

    public synchronized void preserve() {
        if (this.refCount < 0) {
            throw new TclRuntimeError("Attempting to preserve a freed Notifier");
        }
        ++this.refCount;
    }

    public synchronized void release() {
        if (this.refCount == 0 && this.primaryThread != null) {
            throw new TclRuntimeError("Attempting to release a Notifier before it's preserved");
        }
        if (this.refCount <= 0) {
            throw new TclRuntimeError("Attempting to release a freed Notifier");
        }
        --this.refCount;
        if (this.refCount == 0) {
            notifierTable.remove(this.primaryThread);
            this.primaryThread = null;
        }
    }

    public synchronized void queueEvent(TclEvent evt, int position) {
        evt.notifier = this;
        if (position == 0) {
            evt.next = null;
            if (this.firstEvent == null) {
                this.firstEvent = evt;
            } else {
                this.lastEvent.next = evt;
            }
            this.lastEvent = evt;
        } else if (position == 1) {
            evt.next = this.firstEvent;
            if (this.firstEvent == null) {
                this.lastEvent = evt;
            }
            this.firstEvent = evt;
        } else if (position == 2) {
            if (this.markerEvent == null) {
                evt.next = this.firstEvent;
                this.firstEvent = evt;
            } else {
                evt.next = this.markerEvent.next;
                this.markerEvent.next = evt;
            }
            this.markerEvent = evt;
            if (evt.next == null) {
                this.lastEvent = evt;
            }
        } else {
            throw new TclRuntimeError("wrong position \"" + position + "\", must be TCL.QUEUE_HEAD, TCL.QUEUE_TAIL or TCL.QUEUE_MARK");
        }
        if (Thread.currentThread() != this.primaryThread) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void deleteEvents(EventDeleter deleter) {
        void var2_3;
        TclEvent prev = null;
        TclEvent evt = this.firstEvent;
        while (var2_3 != null) {
            if (deleter.deleteEvent(evt) == 1) {
                if (this.firstEvent == evt) {
                    this.firstEvent = evt.next;
                    if (evt.next == null) {
                        this.lastEvent = null;
                    }
                } else {
                    prev.next = evt.next;
                }
                if (this.markerEvent == evt) {
                    this.markerEvent = null;
                }
            } else {
                prev = evt;
            }
            evt = evt.next;
        }
    }

    synchronized int serviceEvent(int flags) {
        if ((flags & 0xFFFFFFFD) == 0) {
            flags |= 0xFFFFFFFD;
        }
        TclEvent evt = this.firstEvent;
        while (evt != null) {
            boolean b = evt.isProcessing;
            evt.isProcessing = true;
            if (!b && evt.processEvent(flags) != 0) {
                evt.isProcessed = true;
                TclEvent tclEvent = evt;
                synchronized (tclEvent) {
                    if (evt.needsNotify) {
                        evt.notifyAll();
                    }
                }
                if (this.firstEvent == evt) {
                    this.firstEvent = evt.next;
                    if (evt.next == null) {
                        this.lastEvent = null;
                    }
                    if (this.markerEvent == evt) {
                        this.markerEvent = null;
                    }
                } else {
                    TclEvent prev = this.firstEvent;
                    while (prev.next != evt) {
                        prev = prev.next;
                    }
                    prev.next = evt.next;
                    if (evt.next == null) {
                        this.lastEvent = prev;
                    }
                    if (this.markerEvent == evt) {
                        this.markerEvent = prev;
                    }
                }
                return 1;
            }
            evt.isProcessing = b;
            evt = evt.next;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int doOneEvent(int flags) {
        void var2_2;
        boolean result = false;
        if ((flags & 0xFFFFFFFD) == 0) {
            flags |= 0xFFFFFFFD;
        }
        while (true) {
            TimerHandler h;
            if ((flags & 0xFFFFFFFD) == 32) {
                return this.serviceIdle();
            }
            long sysTime = System.currentTimeMillis();
            if (!this.timerPending && this.timerList.size() > 0) {
                h = (TimerHandler)this.timerList.elementAt(0);
                if (h.atTime <= sysTime) {
                    TimerEvent event = new TimerEvent();
                    event.notifier = this;
                    this.queueEvent(event, 0);
                    this.timerPending = true;
                }
            }
            if (this.serviceEvent(flags) != 0) {
                result = true;
                break;
            }
            if ((flags & 0x20) != 0 && this.serviceIdle() != 0) {
                result = true;
                break;
            }
            if ((flags & 2) != 0) break;
            try {
                if (this.timerList.size() > 0) {
                    h = (TimerHandler)this.timerList.elementAt(0);
                    long waitTime = h.atTime - sysTime;
                    if (waitTime <= 0L) continue;
                    this.wait(waitTime);
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int serviceIdle() {
        void var1_1;
        boolean result = false;
        int gen = this.idleGeneration++;
        while (this.idleList.size() > 0) {
            IdleHandler h = (IdleHandler)this.idleList.elementAt(0);
            if (h.generation > gen) break;
            this.idleList.removeElementAt(0);
            if (h.invoke() == 0) continue;
            result = true;
        }
        return (int)var1_1;
    }

    private Notifier(Thread primaryTh) {
        this.primaryThread = primaryTh;
        this.firstEvent = null;
        this.lastEvent = null;
        this.markerEvent = null;
        this.timerList = new Vector();
        this.timerGeneration = 0;
        this.idleList = new Vector();
        this.idleGeneration = 0;
        this.timerPending = false;
        this.refCount = 0;
    }
}

