/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.JavaInvoke;
import tcl.lang.TclException;
import tcl.lang.TclObject;

class JavaPropCmd
implements Command {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        boolean query;
        int objIndex;
        boolean convert;
        if (argv.length < 3) {
            throw new TclException(interp, JavaPropCmd.usage(argv[0]));
        }
        String arg1 = argv[1].toString();
        if (arg1.length() >= 2 && "-noconvert".startsWith(arg1)) {
            convert = false;
            objIndex = 2;
            if (argv.length != 4) throw new TclException(interp, JavaPropCmd.usage(argv[0]));
            query = true;
        } else {
            convert = true;
            objIndex = 1;
            if (argv.length == 3) {
                query = true;
            } else {
                if (argv.length % 2 != 0) throw new TclException(interp, JavaPropCmd.usage(argv[0]));
                query = false;
            }
        }
        if (query) {
            interp.setResult(JavaInvoke.getProperty(interp, argv[objIndex], argv[objIndex + 1], convert));
            return;
        } else {
            int i = objIndex + 1;
            while (i < argv.length) {
                JavaInvoke.setProperty(interp, argv[objIndex], argv[i], argv[i + 1]);
                i += 2;
            }
            interp.resetResult();
        }
    }

    private static final String usage(TclObject cmd) {
        return "wrong # args: should be \"" + cmd + " ?-noconvert? object property\" or \"" + cmd + " object property value ?property value ...?\"";
    }

    JavaPropCmd() {
    }
}

