# about.tcl
#	The about box
#
proc About {win} {
    upvar #0 HM$win var
    global WebTk Register
    catch {destroy .about}
    toplevel .about -class about -bd 2 -relief raised
    wm title .about "WebTk $WebTk(version)"
    set info ""
    if [info exists Register(user)] {
	append info "\nRegistered to: $Register(user)"
	if [info exists Register(serial)] {
	    append info " #$Register(serial)"
	}
	append info \n
    }
    message .about.msg -aspect 2000 -justify center -bd 4 -relief ridge -text \
"Sun Microsystem Laboratories
WebTk $WebTk(version)
$info
Please mail comments and bug reports to:
Brent.Welch@eng.Sun.COM

Window Info
Tk $win
URL $var(S_url)"
    button .about.ok -command {destroy .about} -text OK

    pack .about.msg .about.ok -padx 10 -pady 10 
}
