#!/bin/sh
# \
exec tclsh "$0" "$@"

#######
# parse command line
#######
if {[llength $argv] != 3} {
  puts "Usage: $argv0 <originaldir> <newdir> <patchname>"
  exit 1
}

foreach {originaldir newdir patchname} $argv {}


#########
# figure out what's changed
#########
puts "checking for new/deleted files..."
set cwd [pwd]
cd $originaldir
set origfiles [eval exec find [glob *] -type f | sort]
cd $newdir
set newfiles [eval exec find [glob *] -type f | sort]
cd $cwd

set inboth ""
set created ""
foreach x $newfiles {
  if {[lsearch $origfiles $x] == -1} {
    lappend created $x
  } else {
    lappend inboth $x
  }
}
set deleted ""
foreach x $origfiles {
  if {[lsearch $newfiles $x] == -1} {
    lappend deleted $x
  }
}

#######
# create patch description file
#######
puts "comparing files that exist in both directories..."
set f [open $patchname.patchfiles w]
foreach x $created {
  puts $f "add $x [list [lrange [exec cksum [file join $newdir $x]] 0 1]]"
}

foreach x $deleted {
  puts $f "remove $x [list [lrange [exec cksum [file join $originaldir $x]] 0 1]]"
}

set patchfiles $created
foreach x $inboth {
  set newsum [lrange [exec cksum [file join $newdir $x]] 0 1]
  set oldsum [lrange [exec cksum [file join $originaldir $x]] 0 1]
  if {[string compare $newsum $oldsum] != 0} {
    puts $f "update $x [list $oldsum] [list $newsum]"
    lappend patchfiles $x
  }
}

close $f

#######
# create tarfile and manifest file
#######
puts "Creating tarfile..."
set manifest [open $patchname.tar.Z.manifest w]
set manifestpipe [open "| cut -f2 -d \" \" >@ $manifest" w]
set tarfile [open $patchname.tar.Z w]
cd $newdir
eval exec tar cvf - $patchfiles | compress >@ $tarfile 2>@ $manifestpipe
cd $cwd
close $manifestpipe
close $manifest
close $tarfile
