'\"
'\" Copyright (c) 1990-1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/menu.n,v 1.16 93/04/01 09:52:44 ouster Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS menu tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
menu \- Create and manipulate menu widgets
.SH SYNOPSIS
\fBmenu\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBactiveBackground\fR	\fBbackground\fR	\fBdisabledForeground\fR
\fBactiveBorderWidth\fR	\fBborderWidth\fR	\fBfont\fR
\fBactiveForeground\fR	\fBcursor\fR	\fBforeground\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBpostCommand\fR
.VS
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-postcommand\fR
.fi
.IP
If this option is specified then it provides a Tcl command to execute
each time the menu is posted.  The command is invoked by the \fBpost\fR
widget command before posting the menu.
.VE
.LP
.nf
Name:	\fBselector\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB\-selector\fR
.fi
.IP
For menu entries that are check buttons or radio buttons, this option
specifies the color to display in the selector when the check button
or radio button is selected.
.BE

.SH INTRODUCTION
.PP
The \fBmenu\fR command creates a new top-level window (given
by the \fIpathName\fR argument) and makes it into a menu widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the menu such as its colors and font.
The \fBmenu\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A menu is a widget that displays a collection of one-line entries arranged
in a column.  There exist several different types of entries,
each with different properties.  Entries of different types may be
combined in a single menu.  Menu entries are not the same as
entry widgets.  In fact, menu entries are not even distinct widgets;
the entire menu is one widget.
.PP
Menu entries are displayed with up to three
separate fields.  The main field is a label in the form of text or
a bitmap, which is determined by the \fB\-label\fR or \fB\-bitmap\fR
option for the entry.
If the  \fB\-accelerator\fR option is specified for an entry then a second
textual field is displayed to the right of the label.  The accelerator
typically describes a keystroke sequence that may be typed in the
application to cause the same result as invoking the menu entry.
The third field is a \fIselector\fR.  The selector is present only for
check-button or radio-button entries.  It indicates whether the entry
is selected or not, and is displayed to the left of the entry's
string.
.PP
In normal use, an entry becomes active (displays itself differently)
whenever the mouse pointer is over the entry.  If a mouse
button is released over the entry then the entry is \fIinvoked\fR.
The effect of invocation is different for each type of entry;
these effects are described below in the sections on individual
entries.
.PP
Entries may be \fIdisabled\fR, which causes their labels
and accelerators to be displayed
with dimmer colors.  A disabled entry cannot be activated or invoked.
Disabled entries may be re-enabled, at which point it becomes
possible to activate and invoke them again.

.SH "COMMAND ENTRIES"
.PP
The most common kind of menu entry is a command entry, which
behaves much like a button widget.  When a command entry is
invoked, a Tcl command is executed.  The Tcl
command is specified with the \fB\-command\fR option.

.SH "SEPARATOR ENTRIES"
.PP
A separator is an entry that is displayed as a horizontal dividing
line.  A separator may not be activated or invoked, and it has
no behavior other than its display appearance.

.SH "CHECK-BUTTON ENTRIES"
.PP
A check-button menu entry behaves much like a check-button widget.
When it is invoked it toggles back and forth between the selected
and deselected states.  When the entry is selected, a particular
value is stored in a particular global variable (as determined by
the \fB\-onvalue\fR and \fB\-variable\fR options for the entry);  when
the entry is deselected another value (determined by the
\fB\-offvalue\fR option) is stored in the global variable.
A selector box is displayed to the left of the label in a check-button
entry.  If the entry is selected then the box's center is displayed
in the color given by the \fBselector\fR option for the menu;
otherwise the box's center is displayed in the background color for
the menu.  If a \fB\-command\fR option is specified for a check-button
entry, then its value is evaluated as a Tcl command each time the entry
is invoked;  this happens after toggling the entry's
selected state.

.SH "RADIO-BUTTON ENTRIES"
.PP
A radio-button menu entry behaves much like a radio-button widget.
Radio-button entries are organized in groups of which only one
entry may be selected at a time.  Whenever a particular entry
becomes selected it stores a particular value into a particular
global variable (as determined by the \fB\-value\fR and
\fB\-variable\fR options for the entry).  This action
causes any previously-selected entry in the same group
to deselect itself.
Once an entry has become selected, any change to the entry's
associated variable will cause the entry to deselect itself.
Grouping of radio-button entries is determined by their
associated variables:  if two entries have the same associated
variable then they are in the same group.
A selector diamond is displayed to the left of the label in each
radio-button entry.  If the entry is selected then the diamond's
center is displayed in the color given by the \fBselector\fR option
for the menu;
otherwise the diamond's center is displayed in the background color for
the menu.  If a \fB\-command\fR option is specified for a radio-button
entry, then its value is evaluated as a Tcl command each time the entry
is invoked;  this happens after selecting the entry.

.SH "CASCADE ENTRIES"
.PP
A cascade entry is one with an associated menu (determined
by the \fB\-menu\fR option.  Cascade entries allow the construction
of cascading menus.  When the entry is activated, the
associated menu is posted just to the right of the entry;
that menu remains posted until the higher-level menu is unposted or
until some other entry is activated in the higher-level menu.
A cascade entry posts its associated menu by invoking a
Tcl command of the form
.RS
.IP
\fImenu\fB post \fIx y\fR
.RE
.LP
where \fImenu\fR is the path name of the associated menu, \fIx\fR
and \fIy\fR are the root-window coordinates of the upper-right
corner of the cascade entry, and \fIgroup\fR is the name of the
menu's group (as determined in its last \fBpost\fR widget command).
The lower-level menu is unposted by executing a Tcl command with
the form
.RS
.IP
\fImenu\fB unpost\fR
.RE
.LP
where \fImenu\fR is the name of the associated menu.
.LP
If a \fB\-command\fR option is specified for a cascade entry then it is
.VS
evaluated as a Tcl command each time the associated menu is posted (the
evaluation occurs before the menu is posted).
.VE

.SH "WIDGET COMMAND"
.PP
The \fBmenu\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.
.PP
Many of the widget commands for a menu take as one argument an
indicator of which entry of the menu to operate on.  These
indicators are called \fIindex\fRes and may be specified in
any of the following forms:
.TP 12
\fInumber\fR
Specifies the entry numerically, where 0 corresponds
to the top-most entry of the menu, 1 to the entry below it, and
so on.
.TP 12
\fBactive\fR
Indicates the entry that is currently active.  If no entry is
active then this form is equivalent to \fBnone\fR.  This form may
not be abbreviated.
.TP 12
\fBlast\fR
Indicates the bottommost entry in the menu.  If there are no
entries in the menu then this form is equivalent to \fBnone\fR.
This form may not be abbreviated.
.TP 12
\fBnone\fR
Indicates ``no entry at all'';  this is used most commonly with
the \fBactivate\fR option to deactivate all the entries in the
menu.  In most cases the specification of \fBnone\fR causes
nothing to happen in the widget command.
This form may not be abbreviated.
.TP 12
\fB@\fInumber\fR
In this form, \fInumber\fR is treated as a y-coordinate in the
menu's window;  the entry spanning that y-coordinate is used.
For example, ``\fB@0\fR'' indicates the top-most entry in the
window.  If \fInumber\fR is outside the range of the window
then this form is equivalent to \fBnone\fR.
.TP 12
\fIpattern\fR
If the index doesn't satisfy one of the above forms then this
form is used.  \fIPattern\fR is pattern-matched against the label of
each entry in the menu, in order from the top down, until a
matching entry is found.  The rules of \fBTcl_StringMatch\fR
are used.
.PP
The following widget commands are possible for menu widgets:
.TP
\fIpathName \fBactivate \fIindex\fR
Change the state of the entry indicated by \fIindex\fR to \fBactive\fR
and redisplay it using its active colors.
Any previously-active entry is deactivated.  If \fIindex\fR
is specified as \fBnone\fR, or if the specified entry is
disabled, then the menu ends up with no active entry.
Returns an empty string.
.TP
\fIpathName \fBadd \fItype \fR?\fIoption value option value ...\fR?
Add a new entry to the bottom of the menu.  The new entry's type
is given by \fItype\fR and must be one of \fBcascade\fR,
\fBcheckbutton\fR, \fBcommand\fR, \fBradiobutton\fR, or \fBseparator\fR,
or a unique abbreviation of one of the above.  If additional arguments
are present, they specify any of the following options:
.RS
.TP
\fB\-activebackground \fIvalue\fR
.VS
Specifies a background color to use for displaying this entry when it
is active.
If this option is specified as an empty string (the default), then the
\fBactiveBackground\fR option for the overall menu is used.
This option is not available for separator entries.
.VE
.TP
\fB\-accelerator \fIvalue\fR
Specifies a string to display at the right side of the menu entry.
Normally describes an accelerator keystroke sequence that may be
typed to invoke the same function as the menu entry.  This option
is not available for separator entries.
.TP
\fB\-background \fIvalue\fR
.VS
Specifies a background color to use for displaying this entry when it
is in the normal state (neither active nor disabled).
If this option is specified as an empty string (the default), then the
\fBbackground\fR option for the overall menu is used.
This option is not available for separator entries.
.VE
.TP
\fB\-bitmap \fIvalue\fR
Specifies a bitmap to display in the menu instead of a textual
label, in any of the forms accepted by \fBTk_GetBitmap\fR.
This option overrides the \fB\-label\fR option but may be reset
to an empty string to enable a textual label to be displayed.
This option is not available for separator entries.
.TP
\fB\-command \fIvalue\fR
For command, checkbutton, and radiobutton entries, specifies a
.VS
Tcl command to execute when the menu entry is invoked.
For cascade entries, specifies a Tcl command to execute
when the entry is activated (i.e. just before its submenu is
posted).
.VE
Not available for separator entries.
.TP
\fB\-font \fIvalue\fR
.VS
Specifies the font to use when drawing the label or accelerator
string in this entry.
If this option is specified as an empty string (the default) then
the \fBfont\fR option for the overall menu is used.
This option is not available for separator entries.
.VE
.TP
\fB\-label \fIvalue\fR
Specifies a string to display as an identifying label in the menu
entry.  Not available for separator entries.
.TP
\fB\-menu \fIvalue\fR
Available only for cascade entries.  Specifies the path name of
the menu associated with this entry.
.TP
\fB\-offvalue \fIvalue\fR
Available only for check-button entries.  Specifies the value to
store in the entry's associated variable when the entry is
deselected.
.TP
\fB\-onvalue \fIvalue\fR
Available only for check-button entries.  Specifies the value to
store in the entry's associated variable when the entry is selected.
.TP
\fB\-state \fIvalue\fR
.VS
Specifies one of three states for the entry:  \fBnormal\fR, \fBactive\fR,
or \fBdisabled\fR.  In normal state the entry is displayed using the
\fBforeground\fR option for the menu and the \fBbackground\fR
option from the entry or the menu.
The active state is typically used when the pointer is over the entry.
In active state the entry is displayed using the \fBactiveForeground\fR
option for the menu along with the \fBactivebackground\fR option from
the entry.
Disabled state means that the entry is insensitive:  it doesn't activate
and doesn't respond to mouse button presses or releases.
In this state the entry is displayed according to the 
\fBdisabledForeground\fR option for the menu and the
\fBbackground\fR option from the entry.
This option is not available for separator entries.
.TP
\fB\-underline \fIvalue\fR
Specifies the integer index of a character to underline in the entry.
This option is typically used to indicate keyboard traversal characters.
0 corresponds to the first character of the text displayed in the entry,
1 to the next character, and so on.
If a bitmap is displayed in the entry then this option is ignored.
This option is not available for separator entries.
.VE
.TP
\fB\-value \fIvalue\fR
Available only for radio-button entries.  Specifies the value to
store in the entry's associated variable when the entry is selected.
.TP
\fB\-variable \fIvalue\fR
Available only for check-button and radio-button entries.  Specifies
the name of a global value to set when the entry is selected.
For check-button entries the variable is also set when the entry
is deselected.  For radio-button entries, changing the variable
causes the currently-selected entry to deselect itself.
.LP
The \fBadd\fR widget command returns an empty string.
.RE
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBmenu\fR
command.
.TP
\fIpathName \fBdelete \fIindex1\fR ?\fIindex2\fR?
Delete all of the menu entries between \fIindex1\fR and
.VS
\fIindex2\fR inclusive.
If \fIindex2\fR is omitted then it defaults to \fIindex1\fR.
.VE
Returns an empty string.
.TP
\fIpathName \fBdisable \fIindex\fR
.VS
Change the state of the entry given by \fIindex\fR to \fBdisabled\fR
and redisplay the entry using its disabled colors.
Returns an empty string.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBentryconfigure \fIindex\fR \-state disabled\fR'' instead.
.VE
.TP
\fIpathName \fBenable \fIindex\fR
.VS
Change the state of the entry given by \fIindex\fR to \fBnormal\fR
and redisplay the entry using its normal colors.
Returns an empty string.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBentryconfigure \fIindex\fR \-state normal\fR'' instead.
.VE
.TP
\fIpathName \fBentryconfigure \fIindex\fR \fR?\fIoptions\fR?
This command is similar to the \fBconfigure\fR command, except that
it applies to the options for an individual entry, whereas \fBconfigure\fR
applies to the options for the menu as a whole.
\fIOptions\fR may have any of the values accepted by the \fBadd\fR
widget command.  If \fIoptions\fR are specified, options are modified
as indicated
in the command and the command returns an empty string.
If no \fIoptions\fR are specified, returns a list describing
the current options for entry \fIindex\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).
.TP
\fIpathName \fBindex \fIindex\fR
Returns the numerical index corresponding to \fIindex\fR, or
\fBnone\fR if \fIindex\fR was specified as \fBnone\fR.
.TP
\fIpathName \fBinvoke \fIindex\fR
Invoke the action of the menu entry.  See the sections on the
individual entries above for details on what happens.  If the
menu entry is disabled then nothing happens.  If the
entry has a command associated with it then the result of that
command is returned as the result of the \fBinvoke\fR widget
command.  Otherwise the result is an empty string.  Note:  invoking
a menu entry does not automatically unpost the menu.  Normally
the associated menubutton will take care of unposting the menu.
.TP
\fIpathName \fBpost \fIx y\fR
Arrange for the menu to be displayed on the screen at the root-window
coordinates given by \fIx\fR and \fIy\fR.  These coordinates are
adjusted if necessary to guarantee that the entire menu is visible on
the screen.  This command normally returns an empty string.
.VS
If the \fB\-postcommand\fR option has been specified, then its value is
executed as a Tcl script before posting the menu and the result of
that script is returned as the result of the \fBpost\fR widget
command.
If an error returns while executing the command, then the error is
returned without posting the menu.
.VE
.TP
\fIpathName \fBunpost\fR
Unmap the window so that it is no longer displayed.  If a
lower-level cascaded menu is posted, unpost that menu.  Returns an
empty string.
.TP
\fIpathName \fByposition \fIindex\fR
Returns a decimal string giving the y-coordinate within the menu
window of the topmost pixel in the entry specified by \fIindex\fR.


.SH "DEFAULT BINDINGS"
.PP
.VS
Tk automatically creates class bindings for menus that give them
the following default behavior:
.IP [1]
When the mouse cursor enters a menu, the entry underneath the mouse
cursor is activated;  as the mouse moves around the menu, the active
entry changes to track the mouse.
.IP [2]
When button 1 is released over a menu, the active entry (if any) is invoked.
.IP [3]
A menu can be repositioned on the screen by dragging it with mouse
button 2.
.IP [4]
A number of other bindings are created to support keyboard menu traversal.
See the manual entry for \fBtk_bindForTraversal\fR for details on these
bindings.
.PP
Disabled menu entries are non-responsive:  they don't activate and
ignore mouse button presses and releases.
.PP
The behavior of menus can be changed by defining new bindings for
individual widgets or by redefining the class bindings.
.VE

.SH BUGS
.PP
.VS
At present it isn't possible to use the
option database to specify values for the options to individual
entries.
.VE

.SH KEYWORDS
menu, widget
