# Bindings for managing the Beth window.


# BETH forking

# Initial .beth file
set config_file "$env(HOME)/.beth"

# Name of this interp
set me [winfo name .]

# Code inserted into ~/.beth to register new interp with broadcast.
set notify_me_code {
### Beth notification: }

# Beginning of notify code, to be recognized when removing it.
set notify_me_code_start $notify_me_code

append notify_me_code "
# WARNING: Do not edit these lines!
catch {send {" $me "} " {"tell_me [winfo name .]"} "}
"

# Removes beth configurations from beth config file
proc reset_config_file {} {
	global config_file notify_me_code_start
	set file [open $config_file r]
	set info [read $file]
	close $file

	set ending [string first $notify_me_code_start $info]
	if {($ending == -1)} {set newinfo $info
	} else {set newinfo [string range $info 0 [incr ending -1]]}
	set file [open $config_file w]
	puts -nonewline $file $newinfo
	close $file
}

# Adds beth registration code to beth config file
proc doctor_config_file {} {
	global config_file notify_me_code
	reset_config_file
	set file [open $config_file a]
	puts $file $notify_me_code
	close $file
}

# Called by remote interpreter to complete fork
proc tell_me {args} {
	global remote_interp
	reset_config_file
	set remote_interp $args
}

# Remote interp sets this variable to announce itself.
set remote_interp ""

# Creates a new beth interp, returns its name.
# 'exec cmd' should set up remote beth interp.
proc beth_fork {cmd} {
	global remote_interp
	set remote_interp ""
	reset_config_file
	doctor_config_file
	eval exec $cmd &
	tkwait variable remote_interp
	return $remote_interp
}


# Beth grab control

proc take_control {f} {
	catch {label $f.grab -text "Grab"}
	pack append $f $f.grab {left}
	update idletasks
	catch {grab -global .}
}

proc relinquish_control {f} {
	catch {grab release .}
	catch {destroy $f.grab}
}

proc toggle_control {f} {
	if {([grab status .] != "none")} {relinquish_control $f
	} else {take_control $f}
}

proc wm_raise {f} {
	set regrab [grab status .]
	wm iconify . ; wm deiconify .
	if {($regrab != "none")} {relinquish_control $f; take_control $f}
}


# Window configuration options
# To resize windows, we do a widget_resize on the text widget

# Used in a hack in window_move, this gets set to the outer border width later.
set border ""

# Returns proper window geometry (i.e. doing wm geometry . results does the
# Right Thing)
proc wm_geometry {} {
# A disgusting correction because the (my?) window manager moves the
# window around after I set it. Is there a better way to do this???
	scan [wm geometry .] {%dx%d+%d+%d} h v hp vp
	global border
	if {($border == "")} {
		scan [winfo geometry .] {%dx%d+%d+%d} ih iv ihp ivp
		set border [expr "$ihp - $hp"]
	}
	incr hp $border
	incr vp $border
	return "$hp $vp"
}

# Moves window up/down/left/right based on option and d (same as widget_resize)
proc window_move {option d} {
	set grid [wm grid .]
	scan [wm_geometry] "%d %d" hp vp

	if {($option == "-width")} {incr hp [expr "(0 $d)*[lindex $grid 2]"]
	} else {incr vp [expr "(0 $d)*[lindex $grid 3]"]}

	wm geometry . "+$hp+$vp"
	update idletasks
}

# Puts window on top/left edge of scrren based on option.
proc window_set {option} {
	global border
	scan [wm_geometry] "%d %d" hp vp

	if {($option == "-width")} {set string "+$border+$vp"
	} else {		set string "+$hp+$border"}

	wm geometry . $string
	update idletasks
}


# Misc. window-type functions

proc browse_something {f args} {
	set int [beth_fork $args]
	if {([grab status .] != "none")} {
		relinquish_control $f
		send $int take_control $f
}}

# Prints context of select region, or all of text if no select region exists.
proc print_region {t f} {
	global print_cmd
	if {([catch {$t get sel.first}])} {
		set beginning 1.0
		set end end
		flash_label $f -text "Printing text"
	} else {set beginning sel.first
		set end sel.last
		flash_label $f -text "Printing selection"
	}
	set p [open $print_cmd w]
	puts $p [$t get $beginning $end]
	flush $p
	close $p
}


# Window bindings.# Window bindings. f is a frame widget to put messages in.
proc windowbind {f} {
	global browse_cmd help_cmd
	bind Text <Meta-Control-c> "toggle_control $f"
	bind Text <Meta-Control-h> "browse_something $f $help_cmd"
	bind Text <Meta-i> "wm_raise $f"
	bind Text <Control-P> "print_region %W $f"
	bind Text <Meta-Control-x> "browse_something $f $browse_cmd"
	bind Text <Control-bracketleft> "widget_resize %W -height -1"
	bind Text <Control-bracketright> "widget_resize %W -width -1"
	bind Text <Control-braceleft> "widget_resize %W -height +1"
	bind Text <Control-braceright> "widget_resize %W -width +1"
	bind Text <Meta-bracketleft> "window_move -height -1"
	bind Text <Meta-bracketright> "window_move -width -1"
	bind Text <Meta-braceleft> "window_move -height +1"
	bind Text <Meta-braceright> "window_move -width +1"
	bind Text <Control-Meta-bracketleft> "window_set -height"
	bind Text <Control-Meta-bracketright> "window_set -width"

# Duplicate bindings
	bind Text <Control-Left> [bind Text <Control-bracketright>]
	bind Text <Control-Right> [bind Text <Control-braceright>]
	bind Text <Control-Up> [bind Text <Control-bracketleft>]
	bind Text <Control-Down> [bind Text <Control-braceleft>]
	bind Text <Meta-Left> [bind Text <Meta-bracketright>]
	bind Text <Meta-Right> [bind Text <Meta-braceright>]
	bind Text <Meta-Up> [bind Text <Meta-bracketleft>]
	bind Text <Meta-Down> [bind Text <Meta-braceleft>]
	bind Text <Control-Meta-Left> [bind Text <Control-Meta-bracketright>]
	bind Text <Control-Meta-Up> [bind Text <Control-Meta-bracketleft>]
}

windowbind $frame

after 2000 {flash_label $frame -text "Press Meta-Control-h for help"}
