# Binding procedures to protect text with certain tags.


# Adjusts selection to not include a tagged text at either end.
# Assumes tag begines at linestart, and gives an extra space of buffering.
proc prevent_select {t tag} {
	foreach marker {sel.first sel.first-1c sel.last sel.last-1c} {
		if {[lsearch [$t tag names $marker] $tag] >= 0} {
			set list [$t tag nextrange $tag "$marker linestart"]
			$t tag remove sel [lindex $list 0] "[lindex $list 1] +1c"
}}}

# Bind tag to not be partially selected. (It can still come inside a range
# of selected text, but not at either end)
proc prevent_select_bind {tag} {
	global Keys
	parse_bindings Text \
"S-B1-Motion S-Button-1 B1-Motion Triple-Button-1 Double-Button-1 Button-1 \
 C-K $Keys(C_W) $Keys(M_w)"	"+catch \{prevent_select %W $tag\}"
}


# If insert is over a char with tag on it, move it to the end of the tag.
# If back is not empty, move it to the beginning instead.
# Assumes tag begins at linestart and gives an extra space of buffering.
proc prevent_move {t tag {back ""}} {
	if {[winfo class $t] != "Text"} {return}
	if {([lsearch [$t tag names insert] $tag] < 0) &&
		([lsearch [$t tag names insert-1c] $tag] < 0)} {return}
	if {$back != ""} {
		$t mark set insert "[lindex [$t tag nextrange $tag \
					"insert linestart"] 0]-1c"
	} else {$t mark set insert "[lindex [$t tag nextrange $tag \
					"insert linestart"] 1]+1c"}
}

# Prevent text with tag to be traversed over by keyword traversal or mouse.
proc prevent_move_bind {tag} {
	global Keys
	parse_bindings Text \
"B1-Motion Triple-Button-1 Double-Button-1 Button-1 $Keys(C_a) $Keys(C_e) \
 $Keys(C_f) M-f C-l C-x $Keys(M_comma) $Keys(M_period)" \
				"+prevent_move %W $tag" \
"$Keys(C_b) M-b"		"+prevent_move %W $tag back"
	parse_bindings all \
"$Keys(C_n) $Keys(C_p) $Keys(C_v) $Keys(M_v) C-z M-z $Keys(M_less) \
 $Keys(M_greater)"		"+prevent_move %W $tag"
}


# Protects all chars under tag from being edited. Cmd is the editing that
# gets done, and it works on the range of chars between start and end.
# End defaults to start if unspecified.
# End and start may not be adjacent to any chars with tag.
proc prevent_edit {t tag cmd {start insert} {end ""}} {
	if {[catch {$t index $start}]} {beep ; return 0}
	if {$end == ""} {set end $start}
# Make sure start isn't tagged.
	if {[lsearch [$t tag names "$start-1c"] $tag] >= 0} {beep ; return 0}
# Make sure nothing between start and end is tagged.
	set indices [$t tag nextrange $tag $start]
	if {[llength $indices] == 2} {
		if {[$t compare [lindex $indices 0] < "$end +1c"]} {
			beep ; return 0}}
	eval $cmd
	return 1
}

# Keeps a tagged text from being killed.
proc prevent_kill_region {t tag} {
	if {![catch {set m [$t index mark]}]} {
		if {[$t compare $m <= insert]} {
			set start $m
			set end insert
		} else {set start insert
			set end $m}
		prevent_edit $t $tag "kill_region $t" $start $end
	} else {beep ; return 0}
}

# Keeps a character from being inserted within a tag.
proc prevent_self_insert {t tag c} {
	if {(![regexp . $c])} {return}
	if {[lsearch [$t tag names insert] $tag] >= 0} {beep ; return 0}
	if {[lsearch [$t tag names insert-1c] $tag] >= 0} {beep ; return 0}
	if {[lsearch [$t tag names insert+1c] $tag] >= 0} {beep ; return 0}
	global overwrite_mode
	if {$overwrite_mode && ([lsearch [$t tag names insert+2c] $tag] >= 0)
		&& ([$t get insert+1c] != "\n")} {beep ; return 0}

	$t insert insert $c
	$t tag remove $tag insert-1c
	if {$overwrite_mode && ([$t get insert+1c] != "\n")} {$t delete insert}
	global modified	;	set modified 1
	$t yview -pickplace insert
}

# Prevent any chars with tag from being edited.
proc prevent_edit_bind {tag} {
	global Keys
# Protect all text before prompt from editing commands.
	parse_bindings Text \
Key		"prevent_self_insert %W $tag %A" \
Tab		"prevent_edit %W $tag [list [bind Text <Tab>]]" \
$Keys(C_Delete)	"prevent_edit %W $tag [list [bind Text <Control-Delete>]] \
		sel.first sel.last" \
M-c		"prevent_edit %W $tag [list [bind Text <Meta-c>]]" \
C-d		"prevent_edit %W $tag [list [bind Text <Control-d>]] " \
M-d		"prevent_edit %W $tag [list [bind Text <Meta-d>]] \
		insert {insert wordend}" \
$Keys(C_h)	"prevent_edit %W $tag [list [bind Text <Delete>]] insert-1c" \
M-h		"prevent_edit %W $tag [list [bind Text <Meta-h>]] \
		{insert-2c wordstart} insert" \
C-k		"prevent_edit %W $tag [list [bind Text <Control-k>]] \
		insert {insert lineend +1c}" \
M-l		"prevent_edit %W $tag [list [bind Text <Meta-l>]] \
		insert {insert wordend}" \
$Keys(C_m)	"prevent_edit %W $tag [list [bind Text <Control-m>]]" \
C-o		"prevent_edit %W $tag [list [bind Text <Control-o>]]" \
C-q		"prevent_edit %W $tag [list [bind Text <Control-q>]]" \
C-t		"prevent_edit %W $tag [list [bind Text <Control-t>]] \
		insert-1c insert+1c" \
M-t		"prevent_edit %W $tag [list [bind Text <Meta-t>]] \
		{insert -2c wordstart -2c wordstart} {insert wordend}" \
M-u		"prevent_edit %W $tag [list [bind Text <Meta-u>]] \
		insert {insert wordend}" \
C-w		"prevent_kill_region %W $tag" \
$Keys(C_y)	"prevent_edit %W $tag [list [bind Text <Control-y>]]"
}
