#!/afs/ece/usr/tcl/bin/wish -f
# Top-level beth calling routine

# To run this program, you should make sure the top line reflects the location
# of wish on your system, and the following variable represent the location
# of the beth source directory.

if {![info exists beth_dir]} {
	set beth_dir /afs/ece/usr/svoboda/src/beth
}

#
#
# Beth takes any number of arguments. Args consist of options and configurations
# Each option brings up a separate Beth window. Configs modify all subsequent
# Beth window.
#
# Options
#	file		File to edit.
#	|cmd		Command to execute, load output
#	|cmd&		Command to execute, load output gradually
#	- 		stdin
#	=		stdin (gradually)
#	X		X-selection
# Configs
#	-c 		controls input (via a global grab)
#	-i 		iconified (overrides -c)
#	-b 		browse (instead of edit)
#	-t title	(to add to current window title)
#
#

# Initial .beth file locations
set config_file ".beth"
set config_dir1 $env(HOME)
set config_dir2 [pwd]

# Tempfile
set default_tmpfile "/tmp/beth.output"

# Traverse through the arguments and fork off some other Beth procs.
# This one will take the first option; no processes are created if only
# one option exists.

if {![info exists beth_exec]} {
	set beth_exec "beth"
}

if {(![info exists option])} {set option ""}
if {(![info exists configs])} {set configs ""}
set other_configs ""
set i 0
while {$i < $argc} {
	set item [lindex $argv $i]
	if {($item == "-t")} {
		incr i
		lappend other_configs $item [lindex $argv $i]
	} elseif {[string match -? $item]} {
		lappend other_configs $item
	} elseif {$option == ""} {
		set option $item
		set configs $other_configs
	} elseif {[string match \|* $item]} {
		eval exec $beth_exec $other_configs \"$item\" &
	} else {eval exec $beth_exec $other_configs $item &}
	incr i
}

if {($option == "") && ![info exists embedded]} {
	puts {Beth options: [-c] [-i] [-b] [-t title] [X - = file |cmd |cmd&]}
	exit 1
}

# Tell user what is being instantiated.
# puts "[pid]: beth $configs $option"

# Instantiate configs.
if {([string first -i $configs] >= 0)} {wm iconify .
} elseif {([string first -c $configs] >= 0)} {after 1000 {update ; take_control $frame}}
if {([set v [lsearch $configs -t]] >= 0)} {
	set title_comment [lindex $configs [incr v]]
} else {set title_comment {}
}

set cwd [pwd]

# Get text and entry widgets
source $beth_dir/widgets.tcl
source $beth_dir/entrybind.tcl

# Alter look if we are editing vs browsing
if {([string first -b $configs] >= 0)} {
	set edit_flag 0} else {set edit_flag 1}

# Name of this interp
set me [winfo name .]

catch {
if {($edit_flag) && [file exists $option] && ![file writable $option]} {
	set edit_flag 0
	flash_label $frame -text "File is unwritable"
}}

# Load other modules
source $beth_dir/dialog.tcl
source $beth_dir/browsebind.tcl
source $beth_dir/windowbind.tcl
source $beth_dir/searchbind.tcl
source $beth_dir/interpbind.tcl
source $beth_dir/keybind.tcl
if {$edit_flag} {
	source $beth_dir/filebind.tcl
	source $beth_dir/editbind.tcl
	source $beth_dir/replacebind.tcl
}

if {[file exists $config_dir1/$config_file]} {source $config_dir1/$config_file}
if {($config_dir1 != $config_dir2) &&
    [file exists $config_dir2/$config_file]} {
	source $config_dir2/$config_file}

proc set_start_title {wm_name} {
	global edit_flag title_comment
	if {$edit_flag} {
		wm title . "Edit: $wm_name $title_comment" ; wm iconname . "E $wm_name $title_comment"
	} else {wm title . "Browse: $wm_name $title_comment" ; wm iconname . "B $wm_name $title_comment"
}}


# Fill text widget with initial material, based on option
if {($option == "-")} {
	set path $cwd
	set name ""
	append wm_name $option
	if {![info exists dont_change_title]} {set_start_title $wm_name}
	after 0 beth_busy $text read_file_handler $text stdin 0
} elseif {($option == "=")} {
	set path $cwd
	append wm_name $option
	if {![info exists dont_change_title]} {set_start_title $wm_name}
	after 0 beth_busy $text read_file_handler $text stdin 1
} elseif {($option == "X")} {
	set path $cwd
	append wm_name $option
	if {![info exists dont_change_title]} {set_start_title $wm_name}
	if {[catch {$text insert insert "[selection get]"}]} {
		flash_label $frame -text "Cannot get X selection"
	}
	$text mark set insert 1.0
} elseif {($option != "")} {
	if {([string match \|* $option])} {
		set name $option
		set path $cwd
	} else {set name [file tail $option]
		if {([string index $option 0] == "/")} {
			set path [file dirname $option]
		} else {set path $cwd/[file dirname $option]}
	}
	append wm_name $name
	if {![info exists dont_change_title]} {set_start_title $wm_name}
	if {[file tail $path] == "."} {set path [file dirname $path]}
	after 0 load_file $text $frame \"$path\" \"$name\"
} else {set dont_change_title 1
	set path $cwd
}
cd $path
set cwd [pwd]

catch {set fsBox(name) $name}
catch {set fsBox(path) $path}

# Default generic shell command
set shell_cmd ""
# Make command
set make_cmd "$beth_exec \"| make |& cat &\" &"
# Print command
set print_cmd "| lpr -m -p -T [lindex [wm title .] 1]"
# Cmd to browse the X region
set browse_cmd "| $beth_exec - &"
# Cmd to view help
set help_cmd "$beth_exec -b $beth_dir/HELP &"

return 0
