# exwin.tcl
#
# Main window layout for the application
#
# Copyright (c) 1993 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

proc Exwin_Init {} {
    global exmhPrefs exwin
    Preferences_Resource exwin(scrollbarSide) scrollbarSide right
    Preferences_Add  {
	{exwin(ftextLines)	ftextLines 15	{Folder lines}
"Lines in the folder display window."}
	{exwin(mtextLines)	mtextLines 25	{Message lines}
"Lines in the message display window."}
    }

    trace variable exwin(ftextLines) w ExwinFixupFtextLines
    trace variable exwin(mtextLines) w ExwinFixupMtextLines
}
proc ExwinFixupFtextLines { args } {
    global exwin
    Exmh_Debug ExwinFixupFtextLines $exwin(ftextLines)
    $exwin(ftext) configure -height $exwin(ftextLines)
}
proc ExwinFixupMtextLines { args } {
    global exwin
    Exmh_Debug ExwinFixupMtextLines $exwin(mtextLines)
    $exwin(mtext) configure -height $exwin(mtextLines)
}


proc Exwin_Layout {} {
    global exwin exmh

    set fixed {top fill}
    set expand {top fill expand}

    wm minsize . 100 100
    Flag_Init

    # Top row of buttons for global ops and version string
    set exwin(mainButtons) [Widget_Frame . main Main $fixed]
    Buttons_Main $exwin(mainButtons)
    Label_MainSetup $exwin(mainButtons)

    # Folders with unread messages
    Fdisp_Window [Widget_Frame . flist Fdisp $fixed]

    # Second row of buttons for folder ops and current folder label
    set exwin(fopButtons) [Widget_Frame . fops Fops $fixed]
    Buttons_Folder $exwin(fopButtons)
    Label_FolderSetup $exwin(fopButtons)

    # Folder display (Ftoc)
    set exwin(ftext) [Widget_Text [Widget_Frame . ftoc Ftoc $fixed] \
				$exwin(ftextLines) -cursor hand2 -wrap none]
    Ftoc_Bindings $exwin(ftext)
    Ftoc_ColorConfigure $exwin(ftext)

    # Frame for faces, status, message buttons
    set mid     [Widget_Frame . mid Mid $fixed]
    Widget_SplitFrameR $mid Face Right
    set face $mid.left
    canvas $face.c -background white -width 48 -height 48
    set exwin(faceCanvas) $face.c
    # default image
    $face.c create bitmap 0 0 -anchor nw -bitmap @$exmh(library)/exmh.bitmap
    pack append $face $face.c {top}

    # Status line + MsgID
    set right $mid.right
    Widget_SplitFrameV $right Status Mops
    set exwin(status) [Widget_Entry $right.top msg {right expand fill}]
    Label_MessageSetup $right.top

    # Buttons for message ops, plus display of current message id
    set exwin(mopButtons) $right.bot
    Buttons_Message $exwin(mopButtons)

    # Message display
    set exwin(mtext) [Widget_Text [Widget_Frame . msg Msg $expand] \
				$exwin(mtextLines)]
    Msg_Setup $exwin(mtext)
    Bindings_Main $exwin(mtext)
    focus $exwin(mtext)
}
proc Exwin_FullFtoc {} {
    global exwin
    global tk_version
    if ![info exists exwin(fullFtoc)] {
	set exwin(fullFtoc) notFullScreen
    }
    if {$exwin(fullFtoc) == "notFullScreen"} {
	set exwin(fullFtoc) fullScreen
	if {$tk_version >= 3.3} {
	    set exwin(ftocPack) [pack newinfo .msg]
	    pack forget .msg
	    $exwin(ftext) configure -height \
		[expr $exwin(ftextLines)+$exwin(mtextLines)]
	} else {
	    set exwin(ftocPack) {top fill expand}
	    pack unpack .msg
	}
    } else {
	set exwin(fullFtoc) notFullScreen
	$exwin(ftext) configure -height $exwin(ftextLines)
	if {$tk_version >= 3.3} {
	    eval pack .msg $exwin(ftocPack)
	} else {
	    pack append . .msg $exwin(ftocPack)
	}

    }
}

proc Exwin_IconPosition { w icon } {
    # icon looks like +x+y, or -x-y, etc.
    set x 0 ; set y 0
    if {[llength $icon] == 1} {
	if [regexp {([\+-])([0-9]+)([\+-])([0-9]+)} $icon match s1 x s2 y] {
	    if {$s1 == "-"} {
		set x -$x
	    }
	    if {$s2 == "-"} {
		set y -$y
	    }
	}
    } else {
	set x [lindex $icon 0]
	set y [lindex $icon 1]
    }
    if {$x < 0} {
	# 48 depends on icon width
	set x [expr [winfo screenwidth $w]+$x-48]
    }
    if {$y < 0} {
	# 64 depends on icon height
	set y [expr [winfo screenheight $w]+$y-64]
    }
    if [catch {wm iconposition $w $x $y} err] {
	puts stderr "wm iconposition $w $x $y: $err"
    }
}
