# widgetBut.tcl
#
# Support routines for buttons (and menus) in exmh.  The main abstraction
# is the notion of sets of buttons that are enabled and disabled to
# reflect different modes in exmh.  For example, some buttons (and menu
# entries) are disabled when there is no current message.
#
# Copyright (c) 1993 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

proc Buttons_Init {} {
    global buttons
    set buttons(draftMode) 0
    set buttons(group,current) {}
    set buttons(group,nodraft) {}
    set buttons(group,range) {}
    set buttons(group,comp) {}
    set buttons(groupMenu,current) {}
    set buttons(groupMenu,nodraft) {}
    set buttons(groupMenu,range) {}
    set buttons(groupMenu,comp) {}
}
proc Buttons_Group { frame name buts } {
    global buttons
    foreach but $buts {
	lappend buttons(group,$name) $frame.$but
    }
    if {$name == "comp"} {
	set buttons(comp) $frame.[lindex $buts 0]
    }
}

proc Buttons_GroupMenu { menub name labels } {
    global buttons
    foreach l $labels {
	lappend buttons(groupMenu,$name) [list $menub $l]
    }
}

proc ButtonsGroupState { group state } {
    global buttons
    foreach button $buttons(group,$group) {
	$button configure -state $state
    }
    foreach item $buttons(groupMenu,$group) {
	set menub [lindex $item 0]
	set label [lindex $item 1]
	$menub.m entryconfigure $label -state $state
    }
}

proc Buttons_Current { curMsg } {
    # if curMsg is false, then disable inappropriate buttons
    # otherwise, reenable them.
    # This gets called before Buttons_DraftMode when entering
    # the drafts folder (i.e., buttons(draftMode) may be wrong)
    global buttons
    set buttons(curMsg) $curMsg
    if {$curMsg} {
	ButtonsGroupState current normal
	if $buttons(draftMode) {
	    ButtonsGroupState nodraft disabled
	    ButtonsGroupState comp normal
	}
    } else {
	ButtonsGroupState current disabled
	if $buttons(draftMode) {
	    ButtonsGroupState comp disabled
	}
    }
}

proc Buttons_DraftMode { inDraftMode } {
    # This procedure is called when entering the drafts folder
    # in order to dink the buttons so you can edit and send
    # a message in the drafts folder.  The inDraftMode
    # parameter is true when entering the drafts folder,
    # and it is false when leaving it.
    global buttons
    set buttons(draftMode) $inDraftMode
    if {$inDraftMode} {
	# Disable inappropriate buttons
	ButtonsGroupState nodraft disabled
	ButtonsGroupState comp normal
	# Override the Send button
	if [info exists buttons(comp)] {
	    set buttons(comp,label) [lindex [$buttons(comp) configure -text] 4]
	    set buttons(comp,cmd) [lindex [$buttons(comp) configure -command] 4]
	    $buttons(comp) configure -text EDIT -command Edit_Draft
	    if {! $buttons(curMsg)} {
		$buttons(comp) configure -state disabled
	    }
	}
    } else {
	# Reenable buttons
	ButtonsGroupState nodraft normal
	ButtonsGroupState comp normal
	# Restore Send button
	if {[info exists buttons(comp,cmd)] && \
	    [info exists buttons(comp,label)]} { 
	    $buttons(comp) configure -command $buttons(comp,cmd) \
		    -text $buttons(comp,label) -state normal
	    unset buttons(comp,cmd)
	    unset buttons(comp,label)
	}
    }
    return
}

proc Buttons_Range {} {
    ButtonsGroupState range normal
}

