# buttons.tcl
#
# Action buttons for EXMH.  These are divided into three sets:
# Main - global things like Help and Quit
# Folder - operations on folders like Pack, or Inc.
# Message - operations on the current message.
#
# Copyright (c) 1993 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

proc Buttons_Main { frame } {
    # Note that the unused space in $frame is used
    # by Exmh_MainLabel to hold the version string
    global buttons
    set buttons(mainF) $frame

    foreach b [option get $frame buttonlist {}] {
	Widget_AddButDef $frame $b
    }
}

proc Buttons_Folder { frame } {
    # Create the buttons for operations on items in MH folders
    # Note that the unsed space in $frame is used by
    # Folder_Label to display the status of the current folder.
    global buttons inc
    set buttons(folderF) $frame

    # Menu for extra stuff
    foreach M [option get $frame menulist {}] {
	set menub [Widget_AddMenuBDef $frame $M {right padx 1}]
	foreach e [option get $menub entrylist {}] {
	    set l [option get $menub l_$e {}]
	    set c [option get $menub c_$e {}]
	    set v [option get $menub v_$e {}]
	    case [option get $menub t_$e {}] {
		default {Widget_AddMenuItem $menub $l $c}
		check   {Widget_CheckMenuItem $menub $l $c $v}
		radio   {Widget_RadioMenuItem $menub $l $c $v}
		separator {Widget_AddMenuSeparator $menub}
	    }
	}
    }

    foreach b [option get $frame buttonlist {}] {
	if {$inc(style) == "none" && $b == "inc"} continue
	Widget_AddButDef $frame $b
    }
}

proc Buttons_Message { frame } {
    global buttons
    set buttons(msgF) $frame

    # Menu for extra stuff
    foreach M [option get $frame menulist {}] {
	set menub [Widget_AddMenuBDef $frame $M {right padx 1}]
	foreach e [option get $menub entrylist {}] {
		set l [option get $menub l_$e {}]
		set c [option get $menub c_$e {}]
		Widget_AddMenuItem $menub $l $c
	}
	foreach g [option get $frame groups {}] {
	    Buttons_GroupMenu $menub $g [option get $frame gm_$g {}]
	}
    }

    foreach b [option get $frame buttonlist {}] {
	Widget_AddButDef $frame $b
    }

    # The group assignments associate buttons with states.

    foreach g [option get $frame groups {}] {
	Buttons_Group $frame $g [option get $frame g_$g {}]
    }
}
