/* Copyright (c) 1993 by Sanjay Ghemawat */

#ifndef _CALENDARH
#define _CALENDARH

#include <stdio.h>
#include "basic.h"
#include "unparsed.h"

class Item;
class Lexer;
class pointerArray;

class Calendar {
  public:
    Calendar();			/* Create a new calendar */
    ~Calendar();

    /*
     * Item list.
     */
    int Size() const;			/* Number of items */
    Item* Get(int) const;		/* Get the ith item */
    void Add(Item*);			/* Add an item */
    void Remove(Item*);			/* Remove an item */

    /*
     * Included calendars.
     */
    void Include(char const*);
    void Exclude(char const*);

    int  NumIncludes() const;
    char const* GetInclude(int) const;

    /*
     * True iff this calendar is read-only.
     */
    int ReadOnly() const;
    void SetReadOnly(int);

    /*
     * Read/Write.
     */
    int Read(Lexer*);
    void Write(FILE*) const;
  protected:
    /*
     * Items.
     */
    pointerArray& items;

    /*
     * Included calendars.
     */
    pointerArray& includes;

    int readonly;

    /*
     * Extra things read from file but not understood.
     */
    UnparsedItems extra;
};

inline int Calendar::ReadOnly() const {
    return readonly;
}

inline void Calendar::SetReadOnly(int t) {
    readonly = t;
}

#endif /* _CALENDARH */
