# Copyright (c) 1993 by Sanjay Ghemawat
###############################################################################
# Text bindings
#

# Handle string in text window w.
proc text_handle {w str} {
    if {[cclass printable $str] || ($str == "\t")} {
	$w insert insert $str
	$w yview -pickplace insert
	return
    }

    if {$str == "\001"} {
	# Control-a
	$w mark set insert "insert linestart"
	$w yview -pickplace insert
	return
    }

    if {$str == "\002"} {
	# Control-b
	$w mark set insert "insert-1chars"
	$w yview -pickplace insert
	return
    }

    if {$str == "\004"} {
	# Control-d
	if [catch {$w delete sel.first sel.last}] {
	    # Delete next character
	    $w delete insert
	}
	$w yview -pickplace insert
	return
    }

    if {$str == "\005"} {
	# Control-e
	$w mark set insert "insert lineend"
	$w yview -pickplace insert
	return
    }

    if {$str == "\006"} {
	# Control-f
	$w mark set insert "insert+1chars"
	$w yview -pickplace insert
	return
    }

    if {$str == "\013"} {
	# Control-k
	$w delete insert "insert lineend"
	$w yview -pickplace insert
	return
    }

    if {$str == "\015"} {
	# Control-m
	$w insert insert "\n"
	$w yview -pickplace insert
	return
    }

    if {$str == "\016"} {
	# Control-n
	$w mark set insert "insert+1lines"
	$w yview -pickplace insert
	return
    }

    if {$str == "\020"} {
	# Control-p
	$w mark set insert "insert-1lines"
	$w yview -pickplace insert
	return
    }

    if {$str == "\177"} {
	# Delete
	$w delete insert-1chars insert
	$w yview -pickplace insert
	return
    }
}
