# Copyright (c) 1993 by Sanjay Ghemawat
##############################################################################
# ItemListing
#
# Description
# ===========
# Show item listing.

# For autoloading.
proc ItemListing {} {}

class ItemListing {} {
    set slot(nexttag) 1
    set slot(mainwindow) 0

    toplevel .$self -bd 0 -class Listing -geometry ""
    set g [option get .$self geometry Geometry]
    if {$g != ""} {
	wm geometry .$self $g
    }

    focus_interest .$self
    bind .$self <Any-Enter> [list focus_restrict .$self]

    wm title .$self "Calendar Items"
    wm iconname .$self "Items"
    wm protocol .$self WM_DELETE_WINDOW [list class_kill $self]

    # Done button
    frame .$self.bot -relief raised -bd 1
    frame .$self.bot.default -relief sunken -bd 1
    button .$self.bot.default.b -text Okay -command [list class_kill $self]
    pack append .$self.bot.default .$self.bot.default.b {right padx 3m pady 3m}
    pack append .$self.bot .$self.bot.default {right padx 3m pady 3m}

    # Display
    scrollbar .$self.scroll -relief raised -bd 1 -orient vertical\
	-command [list .$self.display yview]
    text .$self.display\
	-setgrid 1\
	-relief raised\
	-bd 1\
	-yscroll [list .$self.scroll set]\
	-width 50\
	-height 4\
	-wrap word

    # Pack it all up
    pack append .$self .$self.bot {bottom fillx}
    pack append .$self .$self.scroll {right filly}
    pack append .$self .$self.display {left expand fill}

    # Key bindings
    bind .$self <Control-c> [list class_kill $self]
    bind .$self <Return> [list class_kill $self]
    bind .$self.display <Double-1> [list $self null]
    bind .$self.display <Triple-1> [list $self null]

    # Tag displays
    .$self.display tag configure -date -font [pref smallHeadingFont]

    # Disallow edits
    .$self.display configure -state disabled
    $self resize
}

method ItemListing cleanup {} {
    if $slot(mainwindow) {
	destroy .
    } else {
	focus_disinterest .$self
	focus_unrestrict .$self
	destroy .$self
    }
}

# effects - Mark itemlisting as main window.  This causes the
#	    program to finish when the itemlisting is dismissed
method ItemListing mainwindow {} {
    set slot(mainwindow) 1
}

# effects - do nothing
method ItemListing null {} {
}

# effects - Fill listing with items in specified date range.
method ItemListing dayrange {start finish} {
    # Allow edits temporarily
    .$self.display configure -state normal

    set sep  ""
    set date ""
    cal listing $start $finish i d {
	$self insert {} $sep
	if {$date != $d} {
	    # New date
	    set date $d
	    $self insert {-date} "[date2text $date]\n"
	}

	$self insert {-item} [item2text $i "" "" 10000]
	set sep "\n"
    }

    # No more editing
    .$self.display configure -state disabled
    $self resize
}

# effects - Fill listing with items in specified calendar
method ItemListing calendar {calendar} {
    # Allow edits temporarily
    .$self.display configure -state normal

    set sep ""
    cal incalendar $calendar i {
	if [catch {set date [$i first]}] {
	    continue
	}

	set tag tag.$slot(nexttag)
	incr slot(nexttag)

	# Print date description
	set type [$i type]
	if {$type == ""} {
	    set str [date2text $date]
	} else {
	    set str $type
	}
	$self insert {} $sep
	$self insert [list -date $tag] "$str\n"
	$self insert [list $tag] "[item2text $i "" "" 10000]"
	set sep "\n"

	.$self.display tag bind $tag <Double-Button-1> [list $self view $date]
    }

    # No more editing
    .$self.display configure -state disabled
    $self resize
}

# effects - Adjust size of window to size of contents
method ItemListing resize {} {
    set end [.$self.display index end]
    if ![regexp {^([0-9]+)\.([0-9]+)$} $end junk line char] {
	# Could not get text size!
	# Use default height
	set height 20
    } else {
	set height $line
	if {$height < 4} {
	    set height 4
	}
	if {$height > 20} {
	    set height 20
	}
    }
    .$self.display configure -height $height
}

# effects - Generate DayView for specified date.
method ItemListing view {date} {
    [DayView] set_date $date
}

# effects - Insert string with specified tags.
method ItemListing insert {tags str} {
    set start [.$self.display index insert]
    .$self.display insert insert $str

    # Remove existing tags
    foreach t [.$self.display tag names $start] {
	.$self.display tag remove $t $start insert
    }

    # Add new tags
    foreach t $tags {
	.$self.display tag add $t $start insert
    }
}

# effects - Return toplevel window for listing
method ItemListing window {} {
    return .$self
}
