# .browsertkrc.tcl - configuration file for browser.tk
######################################################################

######################################################################
# cmd_view - view contents of a file
######################################################################

proc cmd_view {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {*.dvi}
        {exec xdvi $i &}
      {*.obj}
	{exec tgif $i &}
      {*.ps *.eps}
        {exec ghostview $i &}
      {*.gif *.p?m *.xbm}
	{exec xview $i &}
      {*.tiff}
        {exec xtiff $i &}
      {*.tar.Z}
	{tkb_more {Uncompressed archive contents} \
	[exec zcat $i | tar tBvf -]}
      {*.Z}
	{tkb_more {Uncompressed file} [exec zcat $i]}
      {*.tar}
	{tkb_more {Archive contents} [exec tar tvf $i]}
      {default}
	{tkb_more "Contents of `$i'" [exec cat $i]}

      }
    } else {
      j:alert "`$i' is a directory."
    }
  }
}

######################################################################
# cmd_edit - edit a file
######################################################################

proc cmd_edit {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {*.xbm}
		{exec bitmap $i &}
      {*.dvi *.gif *.jpg *.tiff *.Z *.tar core}
		{j:alert "I don't know how to edit this kind of file."}
      {*.obj}
		{exec tgif $i &}
      {default}
		{exec edit.tk $i &}

      }
    } else {
      j:alert "`$i' is a directory."
    }
  }
}

######################################################################
# cmd_print - send a file to the printer
######################################################################

# dependencies:
#	enscript
#	lpr -d (dvi2ps)

proc cmd_print {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {*.c *.h *.f *.tk}
	{exec enscript -2rGh $i &}
      {*.dvi}
	{exec lpr -d $i &}
      {*.tex}
	{j:alert "Process this file, and then print the .dvi file."}
      {*.latex}
	{j:alert "Process this file, and then print the .dvi file."}
      {*.Z *.tar}
	{j:alert "This file cannot be printed without further processing."}
      {core}
	{j:alert "You don't really want to print a core file, do you?"}
      {*.dvi *.gif *.jpg *.tiff *.xbm *.bdf *.p?m}
	{j:alert "I don't know how to print this kind of file."}
      {*.obj}
	{j:alert "Print this file from within TGIF."}
      {default}
	{lpr $i &}

      }
    } else {
      j:alert "`$i' is a directory."
    }
  }
}

######################################################################
# cmd_process - compile or otherwise process a file
######################################################################

# counter-intuitive to launch files here, but...
# maybe should put in generalised executable-launching mechanism
# how do you check whether an executable is an X app?  use nm?
# is nm portable?

# add:
#	troff

proc cmd_process {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {browser-test}
	{j:alert {Yup, you're using your own ticklish script.}}
      {[mM]akefile*}
		{tkb_more {Output of `make'} [exec make -f $i]}
      {Imakefile}
		{tkb_more {Output of `xmkmf'} [exec xmkmf]}
      {*.c}
		{tkb_more {Output of `cc'} [exec cc -o [file rootname $i] $i]}
      {*.tex}
		{tkb_more {Output of `tex'} [exec tex $i < /dev/null]}
      {*.latex}
		{tkb_more {Output of `latex'} [exec latex $i < /dev/null]}
      {*.Z}
		{exec zcat $i > [file rootname $i]; fillbrowser}
      {*.tar}
		{tkb_more "Output of `tar xvf $i'" [exec tar xvf $i]}
      {*.shar}
		{tkb_more {Output of `sh'} [exec sh $i]}
      {*.uu *.uud}
		{exec uudecode $i; fillbrowser}
      {*.tk}
		{exec $i}
      {*.obj}
		{j:alert "I can't process this file."}
      {default}
		{j:alert "I don't know what to do with this file."}

      }
    } else {
      j:alert "`$i' is a directory."
    }
  }
}




