# ~/.tk/edittkrc.tcl - user customisation file for edit.tk
#   this is a slightly-edited version of the ~/.tk/edittkrc.tcl I
#   use. ---j.
######################################################################

######################################################################
# additional Emacs-style keyboard bindings, supplementing the ones in
# .textbindings.tcl.  These have to be here because they are
# application-specific; they refer to procedures defined in edit.tk.

# do-nothing bindings:
bind Text <Control-x> {%W mark set insert insert}
bind Text <Control-u> {%W mark set insert insert} ;# naah!
bind Text <Escape> {%W mark set insert insert}
#
bind Text <Control-x><Control-s> {cmd_save}
bind Text <Control-x><Control-w> {cmd_saveas}
bind Text <Control-x><Control-f> {cmd_load}
bind Text <Control-x><Control-v> {cmd_load}
bind Text <Control-x><Control-c> {cmd_quit}
bind Text <Control-s> {cmd_find}
bind Text <Control-percent> {cmd_find}
bind Text <Control-u><Control-k> { ;# too simplistic - just an example.
  %W delete insert {insert lineend}
  %W delete insert
  %W delete insert {insert lineend}
  %W delete insert
  %W delete insert {insert lineend}
  %W delete insert
  %W delete insert {insert lineend}
  %W delete insert
}

######################################################################
# define the User menu:

if [winfo exists .menu.user] {
  destroy .menu.user
}

menubutton .menu.user -text {User} -menu .menu.user.m

menu .menu.user.m
.menu.user.m add command -label {Source . . .} -command {
  source [j:fs {} {File to source:}]
}
.menu.user.m add command -label {Sign Official Email} -command {
  .main.t insert end "\n"
  .main.t insert end [exec cat $env(HOME)/.signature]
  .main.t insert end "\n"
}
.menu.user.m add command -label {Insert Date} -command {
  .main.t insert insert \
  [exec date | awk "\{print \$2\" \"\$3\", \"\$6\}"]
}
.menu.user.m add command -label {Sign Personal Email} -command {
  .main.t insert end "\n"
  .main.t insert end [exec cat $env(HOME)/.signature.personal]
  .main.t insert end "\n\n"
  .main.t insert end [exec fortune]
  .main.t insert end "\n"
}
.menu.user.m add separator
.menu.user.m add command -label {Monochrome} -command {
  .main.t configure -selectbackground black
  .main.t configure -selectforeground white
}
.menu.user.m add command -label {NeXT} -command {
  .main.t configure -selectbackground grey66
  .main.t configure -selectforeground black
}
.menu.user.m add command -label {Colour} -command {
  .main.t configure -selectbackground grey80
  .main.t configure -selectforeground black
}
.menu.user.m add separator
.menu.user.m add command -label {Very Large} -command {
  .main.t configure -font {-*-lucidatypewriter-medium-r-normal-sans-18-*}
}
.menu.user.m add command -label {Large} -command {
  .main.t configure -font {-*-lucidatypewriter-medium-r-normal-sans-14-*}
}
.menu.user.m add command -label {Medium} -command {
  .main.t configure -font {-*-lucidatypewriter-medium-r-normal-sans-12-*}
}
.menu.user.m add command -label {Small} -command {
  .main.t configure -font {-*-lucidatypewriter-medium-r-normal-sans-10-*}
}
.menu.user.m add command -label {Very Small} -command {
  .main.t configure -font {-*-clean-medium-r-normal-*-8-*}
}
.menu.user.m add command -label {Barely Legible} -command {
  .main.t configure -font {-*-clean-medium-r-normal--6-*}
}
.menu.user.m add separator
.menu.user.m add command -label {New xterm} -command {
  exec xterm &
}
.menu.user.m add command -label {New browser.tk} -command {
  exec browser.tk &
}
.menu.user.m add separator
.menu.user.m add command -label {Process Man Source} -command {
  tke_pipe {nroff -Tdumb -man}
}
pack append .menu .menu.user right

######################################################################
# change appearance of selected text:

global TEXTSB TEXTSF
set TEXTSB grey66
set TEXTSF black

######################################################################
# window icon:

global env
set iconbitmap "$env(HOME)/xbm/xtypewriter.xbm"
if [file isfile $iconbitmap] {
  wm iconbitmap . "@$iconbitmap"
}
