#
# utils.tcl - Various utility routines for implementing IDEAL and
#	      IDEAL tools.
#
# Copyright 1992, 1993 Virginia Polytechnic Institute and State University.
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by Virginia Polytechnic
#      Institute and State University.
# 4. Neither the name of the University nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# Portions of this software
# Copyright 1992 Regents of the University of California
# Permission to use, copy, modify, and distribute this
# software and its documentation for any purpose and without
# fee is hereby granted, provided that this copyright
# notice appears in all copies.  The University of California
# makes no representations about the suitability of this
# software for any purpose.  It is provided "as is" without
# express or implied warranty.
#
# $RCSfile: utils.tcl,v $
# $Author: cstruble $
# $Date: 93/05/13 18:37:36 $
# $Locker:  $
# $Revision: 1.2 $
# $State: Exp $
#
# $Log:	utils.tcl,v $
# Revision 1.2  93/05/13  18:37:36  cstruble
# Added copyright message.
# 
# Revision 1.1  93/05/12  13:57:10  cstruble
# Initial revision
# 
#
# Created: Aug. 31, 1992
#
# March 19, 1993
#       Craig Struble - Modified left, right and delete keybindings to clear
#       or delete selections respectively.
# 
# March 17, 1993
#       Craig Struble - Added left and right key press bindings for
#       text cells. Easily used in other text items on canvases.
#
# Sep. 21, 1992
#	Add basic editing procedures for text item editing
#
# Aug. 31, 1992
#      Created functions to scroll two windows in the x and y directions.
#

proc scroll_y_2 {win1 win2 view_num} {
	$win1 yview $view_num
	$win2 yview $view_num
}

proc scroll_x_2 {win1 win2 view_num} {
	$win1 xview $view_num
	$win2 xview $view_num
}


proc textB1Press {w x y} {
    $w icursor current @$x,$y
    $w focus current
    focus $w
    $w dtag ctext
    $w select clear
    $w select from current @$x,$y
    $w addtag ctext withtag current
}

proc textB1Move {w x y} {
    $w select to current @$x,$y
}

proc textBs {w} {
    catch {$w dchars ctext sel.first sel.last} delerror

    if {"$delerror" == ""} {return}

    set char [expr {[$w index ctext insert] - 1}]
    if {$char >= 0} {$w dchar ctext $char}
}

proc textLeft {w} {
    set char [expr {[$w index ctext insert] - 1}]
    if {$char >= 0} {$w icursor ctext $char}
    $w select clear
    $w select from ctext insert
}

proc textRight {w} {
    set char [expr {[$w index ctext insert] + 1}]
    set last [$w index ctext end]
    if {$char <= $last} {$w icursor ctext $char}
    $w select clear
    $w select from ctext insert
}

