/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

#define MAINPROGRAM

#include <string.h>
#include <ctype.h>
#include <stdio.h>
/* #include <stdlib.h> */
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <pwd.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"

#ifndef LINT
static char RCSid_ot[] =
    "$RCSfile: otBlankTemplate.c,v $ $Revision: 1.1.2.4 $ $Date: 1993/09/16 15:38:19 $";
#endif


/*
 *			m a i n
 *
 */
int
main(argc, argv, envp)
int argc;
char ** argv;
char ** envp;
{
    OTControlBlock * cb; 
    OTTemplate *tStruct, *tStruct2;
    char *cp1;
    OTProject proj;
    OTErr prjErr, wrtErr, initErr, tmpErr;

    OTErr errCode = OT_SUCCESS;

    /*
     * Initialize TCL, control blocks, read environment variables and
     * preparse command line for project and template file names 
     */
    if ( errCode = otInitialInit(&argc, argv) ) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "otInitialInit: %s\n", cp1);
	exit(1);
    }
    cb = otCB;

    if ( prjErr = otReadProject( cb->cb_project ) ) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "otReadProject: %s\n", cp1);
	exit(1);
    }

    if ( initErr = otInitTemplate( ) ) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "otInitTemplate(): %s\n", cp1);
	exit(1);
    }

    if (tmpErr = otWriteTemplateToFilename(cb->cb_ecb->ecb_blankStruct,"foo")){
    	cp1 = otGetPostedMessage();
	fprintf(stderr, "otWriteTemplateToFilename: %s\n", cp1);
	exit(1);
    }

    exit(1);
    

}
