/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 *	otError.c
 *
 */

/*
#include <stdlib.h>
*/
#include <stdio.h>
#include <varargs.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"

#ifndef LINT
static char RCSid_otError[] = "$RCSfile: otError.c,v $ $Revision: 1.1.4.4 $ $Date: 1994/03/08 17:50:03 $";
#endif

typedef struct
{
    OTErr erm_code;
    char  *erm_string;
} errMsg;

char  holdMsg[LONGVALUE];	/* for holding delayed output */
char  presentMsg[LONGVALUE];	/* for delivering delayed output */
static char *getOtErrString();

/*
 * List of functions defined in otError.c.
 *
 *	char *	otGetPostedMessage()
 *	int	otPutPostedMessage(char *msg)
 *	
 * NB. This is temporary code presented until the ODE developer has
 * finished the error handling routines, which are functionally quite similar
 * but potentially more powerful.
 *
 * Adding error messages?
 *
 *	add an error code to the enumerated type OTErr in ot.h
 *	add an error string to the array errorMessages[] in this file
 */


static errMsg errorMessages[] = {
	/* success           */

    { OT_SUCCESS, 		"success" 				     },
    { OT_TEMPLATE_UNCHANGED,	"%s unchanged" 			             },
    { OT_OBJECT_CREATED,	"Created %s number %s"			     },
    { OT_OBJECT_UPDATED,	"Updated %s number %s"			     },
    { OT_OBJECT_DELETED,	"Deleted %s number %d"                       },
    { OT_TRANSMISSION_CONCLUDED,"Transmission concluded"                     },
    { OT_NOMATCH,		"No match"				     },
    { OT_NO_OBJECT_MATCH,	"No %ss match"				     },
    { OT_TCL_NOPROC, 		"No such TCL procedure defined"              },
    { OT_INFORMATION,	 	"%s"					     },
    
	/* validation errors */
    { OT_TEMPLATE_READ,		"can't read template file (%s)" 	     },
    { OT_NUMBER_PLACE_HOLDER,
         "ENTER operation requires place holder for %s number (nnnnnn)" },
    { OT_INVALID,		"%s"		 			     },
    { OT_MANDATORY_FIELD, 	"%s: Mandatory field (value missing)"	     },
    { OT_NOT_MULTIPLE,		"%s: Not a multiple value field"	     },
    { OT_ILLEGAL_DATE_FORMAT,	"Illegal date format %s"		     },
    { OT_ILLEGAL_DATE_COMPAR,	"Illegal date comparison character %c"       },
    { OT_NO_CLOSING_NOTE, 	"No closing note" 			     },
    { OT_TEMPLATE_LONG,		"template is too long"			     },
    { OT_NOTES_TOOMANY,		"template has too many notes"		     },
    { OT_NDATA_TOOMANY,		"template has too many notedata lines"	     },
    { OT_FIELDNAME_NOT_FOUND,	"fieldname not found"                        },
    { OT_IDNUMFIELD_NOT_FOUND,	"IDNUM field not found"                      },
    { OT_NO_OPERATION,		"No operation is specified"		     },
    { OT_INVALID_BYLINE,	"invalid byline"                             },
    { OT_INVALID_FIELD_DATE,	"'%s' (your value '%s') must conform to format mm/dd/yy" },
    { OT_INVALID_FIELD_ENUM,	"'%s' (your value '%s') must be one of %s"   },
    { OT_INVALID_FIELD_ENUMTYPE,"'%s' (your value '%s') must be of type %s"  },
    { OT_INVALID_FIELD_NUM,	"'%s' (your value '%s') must be an integer"  },
    { OT_INVALID_FIELD_IDNUM,	"'%s' (your value '%s') must be %s"  	     },
    { OT_INVALID_FIELD_ELEM,	"'%s' (your value '%s') must be one of: %s"  },
    { OT_LHS_INVALID,		"Template format does not match metatemplate"},
    { OT_LHS_MANDATORY,		"%s must be mandatory (type in parentheses)" },
    { OT_LHS_MANDATORY_USER,	"%s: mandatory field missing in user template"},
    { OT_LHS_ONE_IDNUM,		"Only one idnum per form"},
    { OT_LHS_TYPE,		"%s: type information (%s) does not match metatemplate (%s)" },
    { OT_LHS_OPT,		"%s: metatemplate makes it an optional field" },
    { OT_LHS_DEGREE,		"%s: metatemplate degree is %s" },
    { OT_LHS_BOTHVAL_MISSING,	"%s: user value \"%s\" missing from both metatemplate and original template" },
    { OT_LHS_VAL_MISSING,	"%s: metatemplate value \"%s\" missing from user template" },
    { OT_LHS_NOTPRESENT, 	"%s: user value \"%s\" not present in metatemplate" },
    { OT_UNKNOWN_SORT_FLD,      
"no field \"%s\" in the layout specification \"%s\" to sort on\n" },
    { OT_NO_SORT_PIPE,		"couldn't setup sort -- doing regular report" },
    { OT_DUPLICATE_FIELD,	"%s: appears twice in template" }, 
    { OT_FIELDNAME_LONG,	"%s: header label exceeds limit" },
    { OT_NDKEYWORD_LONG,	"%s: user-defined notedata keyword exceeds limit" },
    { OT_NO_CR_IN_DBFILE,	"%s number %d not found in the db file %s"   },
   
     /* warning level     */
    { OT_TCL,			"TCL error: %s" 			     },
    { OT_TCL_CALLER,		"TCL error in %s: %s" 			     },
    { OT_PROJECT_NOT_FOUND, 	"Project %s not found"			     },
    { OT_PROJECT_READ,	 	"Error in reading project %s (%s)"	     },
    { OT_PROJECT_TYPE_FILENAME, "No filename for type %s"		     },
    { OT_PROJECT_NAME_CONFLICT, "Project definition file name conflict"      },
    { OT_OBJECT_NOT_FOUND,	"%s %d not found"			     },
    { OT_TCLPROJDEF,		"TCL error in project definition file in: %s (%s)"},
    { OT_TCLCMDSTRING,		"TCL error in command string in: %s (%s)"    },
    { OT_TCLCMDFILE,		"TCL error in %s, line %d: %s"               },
    { OT_UNKNOWN_PROJECT_FLD,	"unknown field in project description file %s"},
    { OT_PROJECT_SYNTAX,	"syntax error in project description file %s"},
    { OT_TYPE_FILE,		"can't open type file (%s)" 		     },
    { OT_TYPE_FILE_CONTENTS,	"no types specified in %s" 		     },

    { OT_ILLEGAL_OPERATION,     "Illegal operation: (%s)"                    },
    { OT_ILLEGAL_NOTIFICATION,  "Illegal notification value: (%s)"           },
    { OT_ILLEGAL_APPEND,	"Illegal value for append indicator: (%s)"   },

    { OT_METATEMPLATE_READ, 	"can't read meta project info (%s)" 	     },
    { OT_METATEMPLATE_LONG,	"metatemplate is too long"		     },
    { OT_METATEMPLATE_EOL,	"premature EOF for field %s in metatemplate" },
    { OT_OTRC,		 	"Error in .otrc: %s"			     },
    { OT_UNKNOWN_HOST,	 	"client connect error: unknown host (%s)"    },
    { OT_SOCKET, 		"client connect error: socket"		     },
    { OT_CONNECT, 		"client connect error: connect, errno %d"    },

    { OT_HOST_UNSPECIFIED,	"client connect error: host unspecified"     },
    { OT_PORT_UNSPECIFIED,	"client connect error: port unspecified"     },
    { OT_SOCKET_OPEN, 		"client connect error: couldn't open socket" },
    { OT_LOG_APPEND,	   	"can't append to log file (%s)"		     },
    { OT_MAKE_SUM,     		"ot_make_sum returned error code %d"	     },
    { OT_TEMPLATE_NAME, 	"Template name exceeds limit"		     },
    { OT_GETPWUID,	     	"getpwuid() failed"			     },
    { OT_WHO_ARE_YOU,	
	"I don't know who you are;  OT_USER, USER, or LOGNAME must be set"   },
    { OT_TEMPLATE_EDIT,
	"edit of file failed (command '%s %s'): check %s?" 	     	     },
    { OT_TEMPLATE_FIND, 	"can't find template file %s"		     },
    { OT_NUMBER_HIGH,		
	"specified %s number %d is too high for the %s project"		     },
    { OT_USERVAL_TOO_LONG, 	"user value (%s) exceeds length limit"	     },
    { OT_TOO_MANY_PROJECTS, 	"too many projects"                          },
    { OT_NOT_RESERVED_NDATA,	"%s is not a reserved notedata keyword"	     },
    { OT_OTQM_CORRUPT_QI,       "(otqm) queue item (%s) fgets() %s returned NULL"  },
    { OT_OTQM_QI_ERROR,		"(otqm) queue item %s is skipped"            },
    { OT_OTQM_DB_EOF,		"(otqm) premature EOF in the dbfile (%s)"    },

    { OT_RCS_CO,
	"RCS checkout failed: someone may be editing %s file (%s)"	     },
    { OT_TEMPLATE_COPY_TMP, 	"can't copy template file (%s) to temporary file (%s)" },
    { OT_TEMPLATE_MOVE_DB, 	"can't move your template (%s) to database area"  },
    { OT_TEMPLATE_COPY_DB, 	
	"can't copy temporary template (%s%s) to database area (%s%s)"       },
    { OT_RCS_CI,		"can't check in file (%s)"		     },
    { OT_RCS_ADMIN,     	"couldn't admin new %s file (%s)"	     },
    { OT_TEMPLATE_UPDATE, 	"couldn't open template file (%s) to update %s" },
    { OT_RCS_DELTA,	 	"error in delta'ing %s file (%s)"	     },
    { OT_GET_NUMBER,	 	"failed to get proper %s number"	     },
    { OT_OPENDIR_LOCATION, 	"opendir() error in %s"		             },
    { OT_RCS_DELETE,		
	 "RCS delete failed: someone may be editing %s number %d"   },
    { OT_RCS_UNLOCK,		"failed to remove RCS lock from a file (%s)" },

    { OT_TEMPLATE_WRITE,	"cannot write template to file %s"	     },
    { OT_NO_DIR,		"directory %s does not exist"                },
    { OT_OTQM_QLIST,	"failed to process %s queue (see server.log file)"   },
    { OT_FILE_OPEN,		"can't open file (%s) in %s"		     },
    { OT_RENAME_FILE,		"can't move file (%s) into (%s) in %s"	     },
    { OT_DBFILE_TOP_NUM,      "illegal top %s number (%s) in the db file %s" },
    
     /* system level      */
    
    { OT_MALLOC, 		"memory allocation error"		     },
    { OT_MALLOC_LOCATION,	"memory allocation error in %s"		     },
    { OT_PCLOSE,	 	"pclose() error"			     },
    { OT_STAT,		"stat() error on file \"%s\" -- file does not exist" },
    { OT_POPEN,			"error during stat() in otNotify"	     },
    { OT_SETRLIMIT,		"error setting memory limits"		     },
    { OT_OTTYPE,		"OT internal error: otType out of range"     },
    { OT_REGEXP,	 	"internal regexp error (%d) -- see tools group" },
    { OT_NEED_FULL_PATH, 	"need to know temporary file (%s) full path" },
    { OT_CREATE_DIR,		"error creating directory %s"	             },
    { OT_CREATE_LOCK_FILE,	"failed to create %s lock file %s" 	     },
    { OT_REMOVE_LOCK_FILE,	"failed to remove lock file (%s) in %s"	     },
    { OT_CREATE_FILE,		"can't create %s file (%s)"                  },
    
    
     /*
      * These are on a 'system level' because they cause an exit,
      * but they are not for the Motif interface.  I may create another
      * category.
      */
    { OT_NEED_PROJECT,		"must specify a project with -p<name> or the OT_PROJECT environment variable"},

    { OT_VALIDATE_USAGE, 	"Validate operation requires template file"  },
    { OT_APPEND_USAGE,          "Append function (-k) requires specification of template" },
    { OT_DELETE_USAGE,		"Delete operation (-d) requires an object number (-n)"	},
    { OT_DIFFERENT_PROJ,	"Project name in Template (%s) does not match the project (%s)" },
    { OT_ENTER_NUMBER,		"No %s number specification on enter operation" },
    { OT_DIFFERENT_NUMBER,      "%s number in template (%d) doesn't match passed %s number (%d)" },
    { OT_UPDATE_NUMBER, 	"%s number required for update"		     },
    { OT_NUMBER_FILE_READ,	"can't read %s number file"                  },
    { OT_MULTIPLE_PROJECTS, 	"cannot specify multiple projects"	     },
    { OT_MULTIPLE_ALTERNATE,	"cannot specify multiple alternate templates" },
    { OT_ILLEGAL_NUMERIC_SEARCH,
	  "Illegal search criteria (%s) for a numeric field (%s)"  },
    { OT_MULTIPLE_RANGES, 	
     "More than one range is in the search criteria (%s) for the '%s' field" },
    { OT_ILLEGAL_RANGE, 	"Illegal number range (%s)"                  },
    { OT_ILLEGAL_ID_NUMBER,	"Illegal %s number (%s)"		     },
    { OT_OPEN_INPUT,		"couldn't open input file %s"		     },
    { OT_ILLEGAL_SEARCH_SYNTAX,  
    	   "Missing the \"=value\" part of the field \"%s\" in the -s option" },
    { OT_UNKNOWN_FIELD,		"unknown field: %s, try \"-d\" for options"   },
    { OT_ONE_FILENAME_ONLY, 	"only one filename allowed (%s is the second)"},
    { OT_NOT_REGULAR_FILE, 	"\"%s\" is not a regular file"		      },
    { OT_UNKNOWN_LAYOUT,	"unknown field \"%s\" in the layout spec: %s" },
    { OT_OTCLI_USAGE,		
"usage: %s -eu [-k file] [-x update_string] | -d | -t | -v [-s] [-p<projectname>] [-n<number>] [-a<name>] [file]"  },
    { OT_OTB_CLI_USAGE,  	"for correct usage, please enter %s -h"      },
    { OT_OTQM_USAGE,		"usage: otqm [-p<OTproj>]"                   },
    { OT_CLI_ZERO_NUMBER,	"%s argument must be greater than 0"         },
    { OT_ARGUMENT_NO_VALUE,     "no value is given for the %s argument"      },
    { OT_OTMAKESUM_USAGE,	"usage: %s <project> <path>"		     },
    { OT_FULL_PATH,		"your path (%s) must be a fully-qualified pathname"},
    { OT_OTMAKESUM_SUMMARY,	"couldn't create Summary file (%s)"},
    { OT_SUMFILE_READ,		"couldn't read %s for Summary"  },
    { OT_SUMFILE_RENAME,	"couldn't rename temp Sum file (%s) to the real thing (%s)"},
    { OT_OTQM_FATAL_ERROR,	"otqm is TERMINATED - FATAL errors"	     },
    { OT_INTERNAL_ERROR, 	"Internal error in %s"			     },
    { OT_INTERNAL_REGEXP,	"Internal regexp() error code %d"	     },
    { OT_GENERAL_ERROR,         "%s"                                         },
    { OT_MAX,			""}

};


/*
 *                     o t P u t P o s t e d M e s s a g e
 *
 * Save a posted message in a statically reserved area of memory.
 */
void
otPutPostedMessage(errCode, va_alist)
OTErr errCode;
va_dcl
{
    register char *cp;
    va_list args;
    char *fmt;

    fmt = getOtErrString(errCode);
    if (holdMsg[0] != 0)
        strcat(holdMsg, "\n");
    cp = (char *)(holdMsg + strlen(holdMsg));
    va_start(args);

    vsprintf(cp, fmt, args);
    va_end(args);

}


/*
 *                       o t G e t P o s t e d M e s s a g e 
 *
 * Accept a char pointer and return a copy of the delayed warning message.
 */
char *
otGetPostedMessage()
{
    char *cp;
    int len;

    len = strlen(holdMsg);
    if (len <= 0) {
	presentMsg[0] = 0;
	cp = 0;
    }
    else {
	strcpy(presentMsg, holdMsg);
	holdMsg[0] = 0;
	cp = presentMsg;
    }
    return cp;

}


/*
 *                        g e t O t E r r S t r i n g
 *
 * Return an OT error string for the associated error, with passed
 * user arguments.
 *
 */
static char *
getOtErrString(errCode)
OTErr errCode;
{
    int i;
    char *fmt;

    for (i = 0; errorMessages[i].erm_code != OT_MAX && 
	errorMessages[i].erm_code != errCode; i++);

    fmt = (errorMessages[i].erm_code == OT_MAX) ? "" : 
	errorMessages[i].erm_string;
    return fmt;        

}
