/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 *	otProject.c
 *
 */

/*
#include <stdlib.h>
*/
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"


OTErr get_project_base();
OTErr get_project_info();
OTErr readTclDefs();
OTErr readList();


#ifndef LINT
static char RCSid_otProject[] =
    "$RCSfile: otProject.c,v $ $Revision: 1.1.7.1 $ $Date: 1993/12/30 23:22:22 $";

#endif


/*
 *		List of functions defined in the otProject.c
 *
 *	otReadProject()
 *	otGetProjectBase()
 */


/*
 * NB: the proj pointer needs to be thrown away.  We read the current
 * project into the control block.
 * 	get rid of third argument for otReadProject in ot.h
 *      same is true of otReadTemplateFromFile...
 *      remove otProj from otGlobals.c - we access from otCB.
 */

OTErr
otReadProject(project)
char *  project;		/* project name */
{
    register int i, ch, tx;
    char file[PATHLEN];
    char metafile[PATHLEN];
    char field[NAMELEN];
    char line[500];
    OTCompMail * cMp;
    OTProject *proj;
    char *fileStr;
    char *prjdir, *tp;
    FILE * ifile;
    OTErr prjErr, tclErr, metaErr, setErr;
    OTControlBlock *control;

    control = otCB;

    /*
     * Free if this is a reassignment.
     */
    if ( control->cb_pcb->pcb_project ) {
	otFreeProject(control->cb_pcb->pcb_project);
	control->cb_pcb->pcb_project = 0;
    }

    /*
     * Store the project information in the (global) control block -
     * specifically, the private control block section.
     */
    if ( (control->cb_pcb->pcb_project = 
	(OTProject *)calloc(1, sizeof(OTProject))) == NULL ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otReadProject");
	return OT_MALLOC_LOCATION;
    }
    if ( (control->cb_pcb->pcb_project->enum_types = 
	(OTEnumType *)calloc(MAXTEMPLATE, sizeof(OTEnumType)) ) == NULL ) {
        free(control->cb_pcb->pcb_project);
        otPutPostedMessage(OT_MALLOC_LOCATION, "otReadProject");
	return OT_MALLOC_LOCATION;
    }
    proj = control->cb_pcb->pcb_project;

    /* Get the project master file */
    prjdir = 0;
    if ( prjErr =  otGetProjectBase(project, &prjdir ) ) {
        otPutPostedMessage(OT_PROJECT_NOT_FOUND, project);
	return OT_PROJECT_NOT_FOUND;
    }
    sprintf(file, "%s/%s/%s.def", prjdir, project, project);

    if (control->cb_altTname && control->cb_altTname[0])
	strcpy(metafile, control->cb_altTname);
    else
        sprintf(metafile, "%s/%s/%s.template.def", prjdir, project, project);

#ifdef SUPPORT_USER_OTRC
    /*
     * Make a copy of the project's TCL code.
     */
    if ( !otWriteFileToString(file, &fileStr) ) {
	if ( tp = strstr(fileStr, "\nproc") )
	    otCopyString(tp+1, proj->projTclCode);
	free(fileStr);
    }
#else
    proj->projTclCode = 0;
#endif

    if ( metaErr = otSetMetaTemplate( metafile) )
        return metaErr;

    if ((ifile = fopen(file, "r")) == NULL) {
        otPutPostedMessage(OT_PROJECT_READ, project, "error in fopen()");
	return OT_PROJECT_READ;
    }

    tx = 0;
    proj->notify = FALSE;               /* notification off by default */
    proj->blogSubmitter = FALSE;        /* ode2ot submitter notification off */
    strcpy(proj->object_name, "CR");    /* make "CR" the default object */
    strcpy(proj->proj_dir, prjdir);     /* save top project dir. name */
    if (prjdir)
	free(prjdir);
    strcpy(proj->compliance, "strict"); /* default compliance level */
    proj->block_silence = FALSE;	/* blocking silence off by default */

    while ((ch = getc(ifile)) != EOF) {	/* Now read it and setup structure */
	if (ch == '\n')
	    continue;           /* empty line */
	if (ch == '#')  {
	    while (((ch = getc(ifile)) != EOF) && (ch != '\n'))	;
	    continue;           /* skip comment line */
	}

	/* Get field name */
	for (i=0;  (ch != EOF) && (ch != ':') && (ch != '\n');  i++) {
	    field[i] = ch;
	    ch = getc(ifile);
	}
	field[i] = 0;

	if (!strncmp(field, "proc", 4)) {

	    fclose(ifile);
	    ifile = 0;
	    /*
	     * Delete any TCL commands which users should not be able to
	     * define.
	     */
	    (void)Tcl_DeleteCommand(control->cb_pcb->pcb_interp, 
		"validateDepend");
	    (void)Tcl_DeleteCommand(control->cb_pcb->pcb_interp,
		"notifyDepend");
	    (void)Tcl_DeleteCommand(control->cb_pcb->pcb_interp,
		"notifyExplicit");
	    (void)Tcl_DeleteCommand(control->cb_pcb->pcb_interp,
		"postProcess");
	    (void)Tcl_DeleteCommand(control->cb_pcb->pcb_interp,
		"generateBsubmitUpdateScript");
	    (void)Tcl_DeleteCommand(control->cb_pcb->pcb_interp,
		"detailHelpOverride");
	    (void)Tcl_DeleteCommand(control->cb_pcb->pcb_interp,
		"detailHelpAdd");

	    if ( tclErr = readTclDefs(file, control) ) {
	        return tclErr;
	    }
	    break;
	}
	else if (ch != ':') {
	    otPutPostedMessage( OT_UNKNOWN_PROJECT_FLD, field );
	    return OT_UNKNOWN_PROJECT_FLD;
	}

	/* The rest is the value */
	for (i=0;  TRUE;  ) {
	    if (i >= sizeof(line)) {
	        otPutPostedMessage( OT_PROJECT_SYNTAX, field );
		return OT_PROJECT_SYNTAX;
	    }
	    ch = getc(ifile);
	    if (!i && ((ch == ' ') || (ch == '\t')))
		continue;
	    if ((ch == '\n') || (ch == EOF))
		break;
	    line[i++] = ch;
	}
	line[i] = 0;

    /* Assign value to the right field */

	if (!strcmp(field, "project name"))
	    strcpy(proj->name, line);
	else if (!strcmp(field, "project leader"))
	    strcpy(proj->proj_leader, line);
	else if (!strcmp(field, "object name"))
	    strcpy(proj->object_name, line);
	else if (!strncmp(field, "odexm", 5))
	    strcpy(proj->odexmcli, line);
	else if (!strcmp(field, "ode2ot notify lead"))
	    strcpy(proj->blogMlist, line);
	else if (!strcmp(field, "ode2ot submitter notification")) {
	    if (!strcmp(line, "on"))
		proj->blogSubmitter = TRUE;
	}
	else if (!strcmp(field, "template compliance")) {
	    if ( (!strcmp(line, "strict")) || (!strcmp(line, "loose")) ) {
		strcpy(proj->compliance, line);
	    }
	}
	else if (!strcmp(field, "notify")) {
	    if (!strcmp(line, "on"))
		proj->notify = TRUE;
	} 
	else if (!strcmp(field, "block silence")) {
	    if (!strcmp(line, "on"))
		proj->block_silence = TRUE;
	}
	else if (!strcmp(field, "server host")) {
	    strcpy(proj->server_host, line);
	}
	else if (strspn(field, "component") == 9)    {
	    /* handle component mail lists */
		if (!(cMp = (OTCompMail *)malloc(sizeof(OTCompMail)))) {
		    otPutPostedMessage(OT_MALLOC_LOCATION, "otReadProject()");
		    return OT_MALLOC_LOCATION;
	        }
		if (proj->cMlist)
		    cMp->next = proj->cMlist;	/* insert into existing list */
		else
		    cMp->next = 0;		/* new list */
		proj->cMlist = cMp;		/* insert at head of list */
		cMp->compName = strdup(&field[10]);
		cMp->unames = strdup(line);
	}
	else if (!strncmp(field, "file type",9)) {
	    /* handle user-defined type */

	     proj->enum_types[tx].typename = strdup(&field[10]);
	     if (!line[0]) {
		 otPutPostedMessage(OT_PROJECT_TYPE_FILENAME, proj->enum_types[tx].typename);
		 return OT_PROJECT_TYPE_FILENAME;
	     }
	     else
	         proj->enum_types[tx].filename = strdup(line);
	     readList(proj->enum_types[tx].typename, 
	 	 proj->enum_types[tx].filename,
		 &(proj->enum_types[tx].list));
	     tx++;
	}
	else if (!strncmp(field, "type",4)) {
	    /* handle user-defined type */

	    proj->enum_types[tx].filename=(char *)0;
	    proj->enum_types[tx].typename = strdup(&field[5]);
	    proj->enum_types[tx].list = strdup(line);

	    tx++;
	}

	else if (!strcmp(field, "server port"))
	    proj->server_port = atoi(line);
	else if (!strcmp(field, "default layout"))
	    strcpy(proj->default_layout, line);
	else if (!strcmp(field, "all layout"))
	    strcpy(proj->all_layout, line);
	else {
	    otPutPostedMessage(OT_UNKNOWN_PROJECT_FLD, field);
	    return OT_UNKNOWN_PROJECT_FLD;
	}
    }

    DBUG_MED((stderr, "readProject name %s\tproj_leader %s\tobject_name %s\tproj_dir %s\n", proj->name, proj->proj_leader, proj->object_name, proj->proj_dir));
    DBUG_MED((stderr, "\tode2ot_notify %s\tode2ot_submitter_notify %d\n", proj->blogMlist, proj->blogSubmitter));
    DBUG_MED((stderr, "\traccess %s\twaccess %s\n", proj->raccess, proj->waccess));
    DBUG_MED((stderr, "\tserver_host %s\tserver_port %d\tnotify %d\tcompliance %s\n", proj->server_host, proj->server_port, proj->notify, proj->compliance));
    DBUG_MED((stderr, "\tdefault_layout %s\tall_layout %s\n", proj->default_layout, proj->all_layout));

    if ( ifile )
	fclose(ifile);              /* done with template */

    if ( strcmp(project, proj->name) ) {
        otPutPostedMessage( OT_PROJECT_NAME_CONFLICT );
	return OT_PROJECT_NAME_CONFLICT;
    }

    if ( setErr = otSetCBMember( "project", proj->name) )
        return setErr;
    if ( setErr = otSetCBMember( "notify", (proj->notify ? "on" : "off") ) )
        return setErr;

    return OT_SUCCESS;
}

/* readTclDefs - read TCL initialization code in project def file. */
OTErr
readTclDefs(prjDefFile, control)
char *prjDefFile;
OTControlBlock *control;
{
    OTErr err;
    char *fileStr, *cp;
    Tcl_Interp *interp;
    int result, j;

#ifdef notdef
    char line[COMMAND];
    char *cmd, *cp;
    int result, j;
    Tcl_DString command;
#endif

    err = otWriteFileToString(prjDefFile, &fileStr);
    interp = otCB->cb_pcb->pcb_interp;
    if ( err ) {
	if ( err == OT_STAT )
	    err = OT_SUCCESS;
    } else {
        cp = strstr(fileStr, "\nproc");
	if ( cp ) {
	    cp++;
	    result = Tcl_Eval(interp, cp);
	    if ( result == TCL_ERROR) {
		otPutPostedMessage(OT_TCL, interp->result);
		err = OT_TCL;
	    }
	}
    }
    free(fileStr);

    return err;

/* I left this here to illustrate what the code WAS. */

#ifdef notdef
    interp = control->cb_pcb->pcb_interp;
    Tcl_DStringInit(&command);
    while ( 1 ) {
	if (fgets(line, COMMAND, ifile) == NULL) 
	    break;
	
	cmd = Tcl_DStringAppend(&command, line, -1);
	if ( (line[0] != 0) && !Tcl_CommandComplete(cmd) )
	    continue;
	result = Tcl_Eval(interp, cmd);

	if (result != TCL_OK) {
	    cp = cmd;
	    for(j = 1; j < interp->errorLine; j++) {
	        while ( *cp != '\n' ) cp++;
	        cp++;
	    }
	    otPutPostedMessage( OT_TCLPROJDEF, cp, interp->result);
	    return OT_TCLPROJDEF;
	}
    }    
    return OT_SUCCESS;
#endif

}



/* read a meta template */

OTErr
readList(typename, fn, list)	/* read user-specified list fr file */
char *typename;
char *fn;
char **list;
{
    FILE *ifile;
    struct stat statbuf;
    register int ch, i;
    char line[NAMELEN];
    char *cp;

    DBUG_MAX((stderr, "readList fn = %s\n", fn));
    if (stat(fn, &statbuf) != 0) {
        otPutPostedMessage (OT_TYPE_FILE, fn);
	return OT_TYPE_FILE;
    }
    if ( (*list = (char *)calloc(statbuf.st_size + 10, sizeof(char))) == 0 ) {
        otPutPostedMessage(OT_MALLOC_LOCATION, "readList()");
	return OT_MALLOC_LOCATION;
    }
    if ( ! (ifile = fopen(fn, "r")) ) {
        otPutPostedMessage( OT_TYPE_FILE, fn);
	return OT_TYPE_FILE;	
    }

    while ( (ch = getc(ifile)) != EOF) {
	for (i=0;  (ch != '\n') && (ch != EOF);  i++) {
	    line[i] = ch;
	    ch = getc(ifile);
	}
	line[i] = 0;
	otTrimWs(&line[0]);
	if (!line[0])
	    continue;
	strcat(*list, line);
	strcat(*list, ",");
    }
    fclose(ifile);
    if (!strlen(*list)) {
        otPutPostedMessage(OT_TYPE_FILE_CONTENTS, fn);
	return OT_TYPE_FILE_CONTENTS;
    }

    cp = *list + strlen(*list) - 1;
    if (*cp == ',')
        *cp = 0;
    DBUG_MAX((stderr, "Type %s: |%s|\n", typename, *list));
    return OT_SUCCESS;
    
}




/*
 *                         o t G e t P r o j e c t B a s e
 *
 * Return root directory for project definition file, template definition file
 * and data directories.
 */
OTErr
otGetProjectBase(prj, prjdir)
char *prj;
char **prjdir;
{
    char *dbpath[MAXPATHDIR]; /* list of project directories */
    char *ot_dbpath;
    char *dp = 0;
    char *base = BASE;
    struct stat stat_buf;
    int db_index = 0;
    bool found;
    int i;

    found = FALSE;
    *prjdir = 0;
    for ( i = 0; i < MAXPATHDIR; i++ )
	dbpath[i] = (char *)0;

    if ( ot_dbpath = getenv("OT_DBPATH") ) {
	char *pp;

	if ( strlen(ot_dbpath) ) {
	    if (!(dp =  (char *)malloc((size_t)strlen(ot_dbpath) + 2))) {
	        otPutPostedMessage( OT_MALLOC_LOCATION, "get_project_base()" );
		return OT_MALLOC_LOCATION;
	    }
	    strcpy(dp, ot_dbpath);
	    for ( pp=strtok(dp, ":");  pp;  pp=strtok(0, ":") ) {
		dbpath[db_index++] = pp;
	    }
	}
    }
    dbpath[db_index] = BASE;

    /*
     * Walk through path in search of file with name identical to prj.
     */
    for( db_index = 0;  dbpath[db_index] && (found == FALSE);  db_index++ ) {
	char tmpdir[PATHLEN];

	sprintf(tmpdir, "%s/%s", dbpath[db_index], prj);

	if ( (stat(tmpdir, &stat_buf) == 0) && S_ISDIR(stat_buf.st_mode) )
	    found = TRUE;
    }
    
    if ( found ) {
        db_index--;
	if (!(*prjdir = (char *)malloc((size_t)strlen(dbpath[db_index]) + 2))) {
	    otPutPostedMessage( OT_MALLOC_LOCATION, "get_project_base()" );
	    return OT_MALLOC_LOCATION;
	}
	strcpy(*prjdir, dbpath[db_index]);
    }

    if (dp)
	free(dp);
    if ( !*prjdir )
        return OT_PROJECT_NOT_FOUND;
    else
	return OT_SUCCESS;
}

/*
 *                    o t G e t P r o j e c t I n f o
 *
 * Build an array of projects and their directory locations.
 * 
 */
OTErr
otGetProjectInfo(projects)
char **projects;
{
    OTErr prjErr = OT_SUCCESS;
    char *dp, *current_pbuf;
    char *dbpath[MAXPATHDIR];
    char *ot_dbpath;
    char *current_project, *end_projects;
    struct stat stat_buf;
    int db_index, i, j;
    int nprj = 0;
    int strcmp();

    dp = 0;
    *projects = 0;

    if (!(*projects = calloc(MAXPROJECTS, COMMAND + 1))) {
	otPutPostedMessage( OT_MALLOC_LOCATION, "otGetProjectInfo()" );
	prjErr = OT_MALLOC_LOCATION;
    }
    else {
	current_project = *projects;
	end_projects = *projects + (MAXPROJECTS * COMMAND);
    }
    
    for ( i = 0; i < MAXPATHDIR; i++ )
	dbpath[i] = (char *)0;

    if ( !prjErr ) {
	if ( ot_dbpath = getenv("OT_DBPATH") ) {
	    char *pp;

	    if (!(dp =  (char *)malloc((size_t)strlen(ot_dbpath) + 2))) {
	        otPutPostedMessage( OT_MALLOC_LOCATION, "otGetProjectInfo()" );
		prjErr = OT_MALLOC_LOCATION;
	    }
	    else {
		strcpy(dp, ot_dbpath);
		for ( db_index = 0, pp = strtok(dp, ":");
		     (db_index < MAXPATHDIR) && pp;
		      pp = strtok(0, ":") )
		    dbpath[db_index++] = pp;
	    }
	}
	dbpath[db_index] = BASE;
    }

    for( db_index = 0; !prjErr && dbpath[db_index];  db_index++ ) {

	DIR *d, *sd;
	char tmpdir[PATHLEN + 1], subdir[PATHLEN + 1];
	struct dirent *direntp, *subdirentp;

	if ( (d = opendir(dbpath[db_index])) == NULL ) {
	    otPutPostedMessage( OT_OPENDIR_LOCATION, dbpath[db_index] );
	    prjErr = OT_OPENDIR_LOCATION;
	    break;
	}

	DBUG_MED((stderr, "dbpath - %s\n", dbpath[db_index]));
	/*
	 * Access the subdirectories of the current OT_DBPATH directory
	 */
	while ( direntp = readdir(d) ) {

	    sprintf(subdir, "%s/%s", dbpath[db_index], direntp->d_name);

	    DBUG_MED((stderr, "Opening directory %s\n", subdir));
	    if ( sd = opendir(subdir) ) {

		OTProject *prj_pp;
		OTMetaTemplate *mTemplate;
	        char proj_defn[PATHLEN + 1], tmpl_defn[PATHLEN + 1];
		char fullpath_tmpl_defn[PATHLEN + 1];
		bool proj_defn_found, tmpl_defn_found;
		
		sprintf(proj_defn, "%s.def", direntp->d_name); 
		sprintf(tmpl_defn, "%s.template.def", direntp->d_name); 
		sprintf(fullpath_tmpl_defn, "%s/%s.template.def", subdir,
		    direntp->d_name);
		proj_defn_found = tmpl_defn_found = FALSE;
		
		while ( subdirentp = readdir(sd) ) {
		    if ( !strcmp(proj_defn, subdirentp->d_name) )
		        proj_defn_found = TRUE;
		    if (!strcmp(tmpl_defn, subdirentp->d_name) )
		        tmpl_defn_found = TRUE;
		}

		closedir(sd);
		
		if ( proj_defn_found && tmpl_defn_found ) {
		    if ( (current_project + sizeof(char *)) > end_projects ) {
			otPutPostedMessage( OT_TOO_MANY_PROJECTS );
			prjErr = OT_TOO_MANY_PROJECTS;
		    }
  		    else {
		        sprintf(current_project, "%s ", direntp->d_name); 
			current_project += strlen(direntp->d_name) + 1;
		    }
		}
	    }
	}
	closedir(d);
    }
    
    /* add sorting eventually */
    if (prjErr) {
	if (*projects)
	    free(*projects);
    }
    if (dp)
	free(dp);

    return prjErr;
}



void
otFreeProject(prjp)
OTProject *prjp;
{
    OTPrivateCB *pcp = otCB->cb_pcb;
    OTMetaTemplate *mp;
    OTEnumType *entp;
    OTCompMail *cmp1, *cmp2;
    int ret;

    if (prjp) {
        if ( prjp->enum_types ) {
	    entp = prjp->enum_types;
	    for ( ; entp->typename; entp++) {
		if (entp->typename)
		    free(entp->typename);
		if (entp->filename)
		    free(entp->filename);
		if (entp->list)
		    free(entp->list);
	    }
	    free( prjp->enum_types );
	}
	if (prjp->cMlist) {
	    cmp2 = prjp->cMlist;
	    do {
	        cmp1 = cmp2;
		if (cmp1->compName)
		    free(cmp1->compName);
		if (cmp1->unames)
		    free(cmp1->unames);
		cmp2 = cmp1->next;
		free(cmp1);
	    } while (cmp2);
	    prjp->cMlist = 0;
	}
	if (prjp->server_fields)
	    (void)free(prjp->server_fields);
	if (prjp->projTclCode)
	    (void)free(prjp->projTclCode);

	if (prjp->otmp) {
	    for(mp = prjp->otmp; mp->field[0]; mp++)
		if (mp->abbr && mp->abbr[0])
		    (void)Tcl_DeleteCommand(otCB->cb_pcb->pcb_interp, 
			mp->abbr);
	    (void)otFreeMetaTemplate(prjp->otmp);
	}
	free(prjp);
    }

}
