#
# Copyright (c) 1994 Open Software Foundation, Inc.
# 
# Permission is hereby granted to use, copy, modify and freely distribute
# the software in this file and its documentation for any purpose without
# fee, provided that the above copyright notice appears in all copies, and
# that both the copyright notice and this permission notice appear in
# supporting documentation.  Further, provided that the name of Open
# Software Foundation, Inc. ("OSF") not be used in advertising or
# publicity pertaining to distribution of the software without prior
# written permission from OSF.  OSF makes no representations about the
# suitability of this software for any purpose.  It is provided "AS IS"
# without express or implied warranty.
#

# osf1_osf1_maint.tcl
# 
# Defines procedures preAdjust and postAdjust.

# proc preAdjust generates a string which is sent to the server for
# evaluation before the 'TCL' form of the CR is sent to the destination server.
# The commands generated by preAdjust should include things like the
# following:
# - If any source project fields are missing in the destination project
# 	template, then you should define a null procedure with the name
#	of the abbreviation (keyword) for the field here.  For example,
#	if you are moving a CR from osf1 to osf1_maint, and osf1 has a
#	field with keyword "xnum" and osf1_maint has no such keyword, then
#	return the following in your string
#		proc xnum { args } { }
#	(The 'args' means there will be no argument count checking.)

proc preAdjust { } {

    return

}

#
# proc postAdjust generates a string which is sent to the server for
# evaluation after the 'TCL' form of the CR is sent to the destination server.
# Use this for things like the following:
# - You need to set the IDNUM field to 'nnnnnn' (which is required for enter
#   operations).  This is usually 'num' but could be given a project-specific
#   name.
# - If there are any fields in the source destination project metatemplate
#   which are missing in the destination project metatemplate, then you can
#   either 1) rely on default values set in the destination project 
#   metatemplate, or 2) override these defaults in a command you give here.

proc postAdjust { } {

    set changes {
proj set osf1_maint;
osf1cr set [num];
cc set {};
stat set open;
sstat set created;
cause set {};
rby set {};
revby set {};
fixby set {};
fixedin set {};
code set {};
num set nnnnnn;
}
    return $changes

}
