#! /bin/sh

#
# Copyright (c) 1994 Open Software Foundation, Inc.
# 
# Permission is hereby granted to use, copy, modify and freely distribute
# the software in this file and its documentation for any purpose without
# fee, provided that the above copyright notice appears in all copies, and
# that both the copyright notice and this permission notice appear in
# supporting documentation.  Further, provided that the name of Open
# Software Foundation, Inc. ("OSF") not be used in advertising or
# publicity pertaining to distribution of the software without prior
# written permission from OSF.  OSF makes no representations about the
# suitability of this software for any purpose.  It is provided "AS IS"
# without express or implied warranty.
#
#
# Script to unlock ot CR given the project name and the CR number
#
# To invoke the script:
#	otUnlockCr.sh  project  crNum
#

#set -x
debug=
#debug='echo'

if [ $# -ne 2 ] ; then
    echo Usage: $0 project crNumber
    exit 1
fi

if [ ! -d /project/ot/$1 ]  ; then
    echo Unknown project $1
    exit 1
fi

number=$2

if [ "$number" -le 0 ] ; then
    echo  second argument \(crNum\) should be a number
    exit 1
fi

numb=`echo $number | awk ' { print substr($1 + 1000000,6,2) }'` 
dir2=`echo $number | awk ' { print substr($1 + 1000000,4,2) }'` 
dir1=`echo $number | awk ' { print substr($1 + 1000000,2,2) }'` 

rcsfile=c$dir1$dir2$numb

#numb1=`echo $2 | awk ' { print $1 / 100 + 100 }' | sed 's/\..*//' |\
#	sed 's/1//'`

cd /project/ot/$1/d$dir1/d$dir2

echo 
ls -l $rcsfile*

if [ `echo -n xx` = "-n xx" ] ; then
    c="\c"
else
    n="-n"
fi

echo
echo "Please check file's modification time."
echo $n "Do you want to unlock CR # $number (Y/N)? $c"
read responce

if [ "$responce" = "Y" -o "$responce" = "y" ] ; then
    echo
    echo "Unlocking CR # $number"
    $debug rcs -u -q $rcsfile
    $debug rm -f *$rcsfile*
    $debug co -q $rcsfile

else
    echo
    echo "CR # $number is NOT unlocked"
fi
