
##  Returns user settable options for an item : {{name1 value1} ... }  ##

proc getOptions {itemid} {
  set options {}
  switch [[cv] type $itemid] {

    image {
      foreach cf [[cv] itemconfigure $itemid] {
	set name [string range [lindex $cf 0] 1 end]
	if {($name == "path") ||
	  ($name == "offset") ||
	  ($name == "tags")} { continue }
	lappend options [list $name [lindex $cf 4]]
      }
    }

    default {
      foreach cf [[cv] itemconfigure $itemid] {
	set name [string range [lindex $cf 0] 1 end]
	if {$name == "tags"} { continue }
	lappend options [list $name [lindex $cf 4]]
      }
    }
  }

  return $options
}	

proc getSwitches {itemid} {
  set switches {}
  switch [[cv] type $itemid] {

    image {
      foreach cf [[cv] itemconfigure $itemid] {
	set name [lindex $cf 0]
	if {($name == "-path") ||
	  ($name == "-tags")} { continue }
	lappend switches $name [lindex $cf 4]
      }
    }

    bitmap {
      foreach cf [[cv] itemconfigure $itemid] {
	set name [lindex $cf 0]
	if {($name == "-bitmap")} { continue }
	lappend switches $name [lindex $cf 4]
      }
    }
    
    default {
      foreach cf [[cv] itemconfigure $itemid] {
	if {[lempty [lindex $cf 4]]} { continue }
	
	set name [lindex $cf 0]
	if {$name == "-tags"} { continue }
	if {$name == "-stipple"} {
	  set value "\[mkbitmap [llast [split [lindex $cf 4] "/"]]\]"
	  set switches "$switches $name $value"
	} else {
	  lappend switches $name [lindex $cf 4]
	}
      }
    }
  }

  return $switches
}	

########  ########

proc Configure {} {
  set items [[cv] find withtag s]
  switch [llength $items] {
    0 { warn "No item selected" }
    1 { buildConfigDialog $items }
    default { warn "Select one single item" }
  }
}

proc buildConfigDialog {item} {

  toplevel .configDg
  
  # Window manager configurations
  global tkVersion
  wm positionfrom .configDg ""
  wm sizefrom .configDg ""
  wm maxsize .configDg 1000 900
  wm minsize .configDg 10 10
  wm title .configDg {Picasso Load}

  #### Title  ####

  label .configDg.titleLb \
    -text "Object Type : [[cv] type $item]"

  pack append .configDg \
    .configDg.titleLb {top pady 10 frame n}

  ####  Config options  ####

  set options [getOptions $item]
      
  set entries {}
  foreach opt $options {
    set name [lindex $opt 0]
    
    frame .configDg.opt${name}Fr -borderwidth 0

    label .configDg.opt${name}Fr.optLb \
      -relief flat \
      -width 10 \
      -anchor e \
      -text "${name}:"

    entry .configDg.opt${name}Fr.optEn \
      -relief sunken \
      -width 40

    .configDg.opt${name}Fr.optEn insert 0 [lindex $opt 1]

    pack append .configDg.opt${name}Fr \
      .configDg.opt${name}Fr.optLb {left frame w padx 8} \
      .configDg.opt${name}Fr.optEn {left expand fill padx 4}

    pack .configDg.opt${name}Fr \
      -expand 1 -fill x -side top

    lappend entries .configDg.opt${name}Fr.optEn
  }

  ####  Buttons frame  ####

  frame .configDg.butFr -borderwidth 0

  button .configDg.butFr.applyBt \
    -text {Apply} \
    -command "setConfigFromDialog $item" \
    -relief raised

  button .configDg.butFr.doneBt \
    -text {Done} \
    -command "setConfigFromDialog $item; focus .; destroy .configDg" \
    -relief raised

  button .configDg.butFr.cancelBt \
    -text {Cancel} \
    -command { focus .; destroy .configDg } \
    -relief raised

  #  packing  #
  pack append .configDg.butFr \
    .configDg.butFr.applyBt {left fill expand} \
    .configDg.butFr.doneBt {left fill expand} \
    .configDg.butFr.cancelBt {left fill expand}

  pack append .configDg \
    .configDg.butFr {top fillx pady 10 frame s}

  #  focus  #
  focus [lindex $entries 0]
  circEntryBind {<Return> <Tab> <Control-n>} {<Control-p>} \
    $entries
}

proc setConfigFromDialog {item} {

  set options {}
  set widgets [winfo children .configDg]

  foreach child [winfo children .configDg] {
    if {[regexp {configDg[.]opt([^.]+)Fr} $child foo name]} {
      lappend options "-$name"
      lappend options [.configDg.opt${name}Fr.optEn get]
    }
  }

  eval "[cv] itemconfigure $item $options"
  update
  redrawFrames
  if {[[cv] type $item] == "image"} {
    .configDg.optwidthFr.optEn delete 0 end
    .configDg.optwidthFr.optEn insert 0 \
      [lindex [[cv] itemconfigure $item -width] 4]
    .configDg.optheightFr.optEn delete 0 end
    .configDg.optheightFr.optEn insert 0 \
      [lindex [[cv] itemconfigure $item -height] 4]
  }
}
