proc _canvasprint {canvas} {
    # hacked from Alan Brighton unfinished routine for treewidget
    set frame .printframe
    catch {destroy $frame}
    toplevel $frame
    wm title $frame "Print Options"
    global canvasPrintDevice canvasPrintColormode canvasPrintToFileName \
           canvasPrintXsize canvasPrintYsize canvasPrintPoster

    set f $frame.f1
    pack append $frame \
        [frame $f] {top fillx}
    pack append $f \
        [label $f.printer -text "Printer Name" -width 15] {left pady 10} \
        [entry $f.printerEntry -width 20 -relief sunken -textvariable canvasPrintDevice] {fillx pady 10}
        bind $f.printerEntry <Return> "destroy $frame; _canvasprintapply $canvas"
        set cannvasPrintDevice ""
        if {[info exists env(LPDEST)]} {set cannvasPrintDevice $env(LPDEST)}
        if {"$canvasPrintDevice" == ""} {set canvasPrintDevice n3bh}

    set f $frame.f3
    pack append $frame \
        [frame $f] {top fillx}
    pack append $f \
        [label $f.printtofile -text "Print to File" -width 15] {left pady 10} \
        [entry $f.printtofilename -width 20 -relief sunken -textvariable canvasPrintToFileName] {fillx pady 10}
        bind $f.printtofilename <Return> "destroy $frame; _canvasprintapply $canvas"
        set canvasPrintToFileName ""

    set f $frame.f2
    pack append $frame \
        [frame $f] {top fillx}
    pack append $f \
        [radiobutton $f.color -text "Color" -variable canvasPrintColormode \
            -relief flat -value color] {left expand fillx frame sw pady 4} \
        [radiobutton $f.grey -text "Gray" -variable canvasPrintColormode \
            -relief flat -value gray] {left expand fillx frame se pady 4} \
        [radiobutton $f.mono -text "Mono" -variable canvasPrintColormode \
            -relief flat -value mono] {left expand fillx frame se pady 4}
    set canvasPrintColormode gray
    $f.grey select

    set canvasPrintPoster 0
    scan [$canvas bbox all] "%d %d %d %d" x1 y1 x2 y2
    set canvasPrintXsize  [expr "($x2-$x1)/1224+1"]
    set canvasPrintYsize  [expr "($y2-$y1)/1584+1"]
    set f $frame.f5
    pack append $frame \
       [frame $f] {top fillx}
    pack append $f \
        [radiobutton $f.poster -text "Poster" -variable canvasPrintPoster \
            -relief flat -value 1] {left pady 4} \
        [label $f.xposter1 -text "Width pages"] {left} \
        [entry $f.xposter2 -width 3 -relief sunken -textvariable canvasPrintXsize] {left fillx} \
        [label $f.yposter1 -text "Height pages"] {left} \
        [entry $f.yposter2 -width 3 -relief sunken -textvariable canvasPrintYsize] {left fillx}

    set f $frame.f4
    pack append $frame \
        [frame $f] {bottom expand fill}
    pack append $f \
        [button $f.apply -bd 5 -text "APPLY" -command "destroy $frame; _canvasprintapply $canvas"] \
            {left expand fillx frame sw pady 4} \
        [button $f.cancel -bd 5 -text "CANCEL" -command "destroy $frame"] \
            {left expand fillx frame se pady 4}
}

proc _canvasprintapply {canvas} {
   global canvasPrintDevice canvasPrintColormode canvasPrintToFileName \
          canvasColorMap canvasPrintXsize canvasPrintYsize canvasPrintPoster
   set canvasColorMap(grey) "0.0 0.0 0.0 setrgbcolor"
   scan [$canvas bbox all] "%d %d %d %d" x1 y1 x2 y2
   set xstart $x1
   set ystart $y1
   set width  [expr $x2-$x1]
   set height [expr $y2-$y1]
   puts stdout "* ($x1,$y1) ($x2,$y2) $width x $height"
   if {$canvasPrintPoster} {
      puts stdout "  $canvasPrintXsize x $canvasPrintYsize Poster"
      set dx [expr "$width/$canvasPrintXsize"]
      set dy [expr "$height/$canvasPrintYsize"]
      for {set j 0} {$j < $canvasPrintYsize} {incr j} {
         for {set i 0} {$i < $canvasPrintXsize} {incr i} {
            set x1 [expr "$i*$dx+$xstart-20"]
            set y1 [expr "$j*$dy+$ystart-20"]
            set x2 [expr "($i+1)*$dx+$xstart+20"]
            set y2 [expr "($j+1)*$dy+$ystart+20"]
            set width  [expr $x2-$x1]
            set height [expr $y2-$y1]
            puts stdout "  ($x1,$y1) ($x2,$y2) $width x $height"
            if {$width > $height} {
               set xasp [expr $width.0/11.0]
               set yasp [expr $height.0/8.5]
               if {$xasp > $yasp} {
                  set t2 "-rotate 1 -pagewidth 11.0i -height $height -width $width"
               } else {
                  set t2 "-rotate 1 -pageheight 8.5i -height $height -width $width"
               }
            } else {
               set t2 "-pageheight 11.0i -height $height -width $width"
            }
            set cmd "$canvas postscript -colormode $canvasPrintColormode -x $x1 -y $y1 $t2"
            if {"$canvasPrintToFileName" == ""} {
               set fd [open "|lp -d$canvasPrintDevice" w]
               puts $fd [eval "$cmd"]
               close $fd
            } else {
               eval "$cmd -file ${canvasPrintToFileName}_${i}.${j}"
            }
         }
      }
   } else {
      set t2 "-height $height -width $width"
      set cmd "$canvas postscript -colormode $canvasPrintColormode -x $x1 -y $y1 $t2"
      if {"$canvasPrintToFileName" == ""} {
         set fd [open "|lp -d$canvasPrintDevice" w]
         puts $fd [eval "$cmd"]
         close $fd
      } else {
         eval "$cmd -file $canvasPrintToFileName"
      }
   }
}
