#
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: faxit.t,v 1.1.1.1 1994/05/13 04:52:16 andy Exp $
#
# Fax a file(s).
#


proc faxit { w } {

    global resolution
    global cover
    global poll
    global notify_complete
    global notify_retry

    # Get cover sheet information
    foreach f {phone name company location regard comments} {
	set c $w.cover.e.e_$f
	switch -exact -- [winfo class $c] Text {
	    set $f [$c get 0.0 end]
	} Entry {
	    set $f [$c get]
	} default {}
    }

    # If no phone number then abort the request	
    if {$phone == ""} {
	tk_dialog .err "Ooops!" "There's no fax phone number." {} 0 OK
	return
    }

    # Now get scheduling information
    set tries [$w.schedule.retries.e_try get]
    set delay_hrs [$w.schedule.time.e_hour get] 
    set delay_min [$w.schedule.time.e_min get] 

    # Now get fax options
    append options $resolution $cover $poll 

    # Make command. I currently ignore the following options: -k -s -h -v 
    append faxcmd "sendfax "
    set delay [expr $delay_hrs * 60 + $delay_min]
    if {$delay > 0} {
	append faxcmd " -a \"now + $delay minutes\""
    }

    if {$comments != ""} {
	append faxcmd " -c \"$comments\""
    }

    if {$regard != ""} {
	append faxcmd " -r \"$regard\""
    }

    if {$company != ""} {
	append faxcmd " -x \"$company\""
    }

    if {$location != ""} {
	append faxcmd " -y \"$location\""
    }

    if {$name != ""} {
	# This MUST appear.
	append faxcmd " -d \"$name@$phone\""

	# Make an ID string for later usage
	append faxcmd " -i \"$name@$company\"" 
    } else {
	# This MUST appear.
	append faxcmd " -d $phone"
    }

    if {$tries > 0} {
	append faxcmd " -t $tries"
    }

    append faxcmd $options $notify_complete $notify_retry

    # Finally get the files to fax.
    set sz [$w.docs.bx size] 
    if {$sz > 0} {
	for {set i 0} {$i < $sz} {incr i} {
	    append faxcmd " [$w.docs.bx get $i]"
	}
	# Exec it
	if {[catch {eval exec $faxcmd} err]} {
	    tk_dialog .err "Ooops!" "$err" {} 0 OK
	}
    } else {
	tk_dialog .err "Ooops!" "There's no files to fax." {} 0 OK
    }
}
