# save.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script calls a FSBox and write the textbody or the selected part to
# a file
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
#### proc savetext ####
#----------------------------------------------------------------------------
proc savetext {window filename} {
set f [open $filename w]
puts $f [ $window get 1.0 end]
close $f
.butt.label configure -text "Saving a textbody...done" -foreground #000000
} 

# Saves the bodypart of the message in a file
proc save {} {
global bg1 bg2 actbg
.butt.label configure -text "Saving a textbody..." -foreground #3d55ff
global fsBoxMessage
set window [focus]
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
  set fsBoxMessage "Save textbody"
  set filename [FSBox]
  if [file isdirectory $filename] {
  return
  } else {
    if [file isfile $filename] {
      toplevel .save 
      label .save.l -text "File exists!" -background $bg1 -foreground red \
	-font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*"
      label .save.l2  -text "$filename" -background $bg1
      pack .save.l -side top -fill x 
      pack .save.l2 -side top -fill x
      frame .save.butt -background $bg1 
      pack .save.butt -fill both
      button .save.butt.ok -text Save -background $bg1 -activebackground \
	$actbg 	-command "destroy .save; savetext $window $filename"
      button .save.butt.cancel -text Cancel -background $bg1 -activebackground \
	$actbg -command "destroy .save; \
	.butt.label configure -text \"Saving a textbody...Cancelled\" \
	-foreground #000000"
      pack .save.butt.ok .save.butt.cancel -side left -expand yes -pady 5
      return
    } else {
      set f [open $filename w]
      puts $f [ $window get 1.0 end]
      close $f
     .butt.label configure -text "Saving a textbody...done" -foreground #000000
     }
   }
  }
}

#-----------------------------------------------------------------------------#
# Saves selected part from the mail in a file
#-----------------------------------------------------------------------------#
proc savetextsel {window filename} {
set f [open $filename w]
puts $f [ $window get sel.first sel.last]
close $f
.butt.label configure -text "Saving selected text...done" -foreground #000000
}

proc saveselected {} {
global bg1 bg2 actbg
.butt.label configure -text "Saving selected text..." -foreground #3d55ff
global fsBoxMessage
set window [focus]
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
  set fsBoxMessage "Save selected text"
  set filename [FSBox]
  if [file isdirectory $filename] {
  return
  } else {
    if [file isfile $filename] {
      toplevel .save
      label .save.l -text "File exists!" -background $bg1 -foreground red \
        -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*"
      label .save.l2  -text "$filename" -background $bg1
      pack .save.l -side top -fill x
      pack .save.l2 -side top -fill x
      frame .save.butt -background $bg1
      pack .save.butt -fill both
      button .save.butt.ok -text Save -background $bg1 -activebackground \
        $actbg  -command "destroy .save; savetextsel $window $filename"
      button .save.butt.cancel -text Cancel -background $bg1 -activebackground \
        $actbg -command "destroy .save; \
        .butt.label configure -text \"Saving selected text...Cancelled\" \
        -foreground #000000"
      pack .save.butt.ok .save.butt.cancel -side left -expand yes -pady 5
      return
    } else {
      set f [open $filename w]
      puts $f [ $window get sel.first sel.last]
      close $f
     .butt.label configure -text "Saving selected text...done" \
	-foreground #000000
     }
   }
  }
}
