# tkxpilots Version 2.0pl0 - funky interface to xpilots
# Copyright (C) 1993-1994 Richard Oak.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

proc set_shots num {
	global maxPlayerShots

	set maxPlayerShots $num

	if {$maxPlayerShots != 0} {
		set fg black
		set state normal
	} else {
		set fg gray50
		set state disabled
	}

	.mainpanel.misc.a.slid.shtmas.txt configure -foreground $fg
        .mainpanel.misc.a.slid.shtmas.scale configure -foreground $fg -state \
		$state
	.mainpanel.misc.a.slid.shtspd.txt configure -foreground $fg
        .mainpanel.misc.a.slid.shtspd.scale configure -foreground $fg -state \
                $state
        .mainpanel.misc.a.slid.shtlif.txt configure -foreground $fg
        .mainpanel.misc.a.slid.shtlif.scale configure -foreground $fg -state \
                $state
	.mainpanel.misc.a.slid.firrep.txt configure -foreground $fg
        .mainpanel.misc.a.slid.firrep.scale configure -foreground $fg -state \
                $state
	.mainpanel.misc.a.check.shtgrv configure -foreground $fg -state \
                $state

}

proc set_lives {} {
	global limitedLives

	if {$limitedLives == 1} {
		.mainpanel.misc.a.slid.lives.txt configure -foreground black
		.mainpanel.misc.a.slid.lives.scale configure -foreground \
			black -state normal
	} else {
		.mainpanel.misc.a.slid.lives.txt configure -foreground gray50
		.mainpanel.misc.a.slid.lives.scale configure -foreground \
                        gray50 -state disabled
	}
}

proc set_extra {} {
	global extraBorder

	if {$extraBorder == 1} {
		.mainpanel.misc.a.check.ebnce deselect
		.mainpanel.misc.a.check.ewrap deselect
	}
}

proc set_bounce {} {
	global edgeBounce

	if {$edgeBounce == 1} {
		.mainpanel.misc.a.check.ewrap deselect
		.mainpanel.misc.a.check.extra deselect
	}
}

proc set_wrap {} {
	global edgeWrap

	if {$edgeWrap == 1} {
		.mainpanel.misc.a.check.extra deselect
		.mainpanel.misc.a.check.ebnce deselect
	}
}

proc mk_misc {} {
	global shipMass shotsMass shotspeed shotLife fireRepeatRate \
		maxPlayerShots shotsGravity idleRun noQuit contactPort \
		reportToMetaServer limitedVisibility limitedLives \
		onePlayerOnly timing edgeWrap edgeBounce extraBorder \
		framesPerSecond gameDuration worldLives playerMinimumStartFuel\
		contactPort team_to_join

	set w .mainpanel.misc.a
	
	frame $w
	frame $w.slid

	frame $w.slid.shpmas
	label $w.slid.shpmas.txt -text "Ship mass (x10)"
	scale $w.slid.shpmas.scale -orient horizontal -from 0 -to 500 -command \
		"set shipMass" -bg Bisque1 -relief flat -length 200
	pack $w.slid.shpmas.txt $w.slid.shpmas.scale -side top -fill both \
		-expand yes
	$w.slid.shpmas.scale set $shipMass

	frame $w.slid.shtmas
	label $w.slid.shtmas.txt -text "Shot mass (x10)"
	scale $w.slid.shtmas.scale -orient horizontal -from 0 -to 50 -command \
                "set shotsMass" -bg Bisque1 -relief flat -length 200
        pack $w.slid.shtmas.txt $w.slid.shtmas.scale -side top -fill both \
                -expand yes
        $w.slid.shtmas.scale set $shotsMass

        frame $w.slid.shtspd
	label $w.slid.shtspd.txt -text "Shot speed (x10)"
	scale $w.slid.shtspd.scale -orient horizontal -from 0 -to 500 -command \
                "set shotspeed" -bg Bisque1 -relief flat -length 200
        pack $w.slid.shtspd.txt $w.slid.shtspd.scale -side top -fill both \
                -expand yes
        $w.slid.shtspd.scale set $shotspeed

	frame $w.slid.shtlif
	label $w.slid.shtlif.txt -text "Shot life"
	scale $w.slid.shtlif.scale -orient horizontal -from 0 -to 150 -command \
                "set shotLife" -bg Bisque1 -relief flat -length 200
        pack $w.slid.shtlif.txt $w.slid.shtlif.scale -side top -fill both \
                -expand yes
	$w.slid.shtlif.scale set $shotLife

	frame $w.slid.firrep
	label $w.slid.firrep.txt -text "Fire repeat rate"
	scale $w.slid.firrep.scale -orient horizontal -from 0 -to 10 -command \
                "set fireRepeatRate" -bg Bisque1 -relief flat -length 200
        pack $w.slid.firrep.txt $w.slid.firrep.scale -side top -fill both \
                -expand yes
        $w.slid.firrep.scale set $fireRepeatRate

	frame $w.slid.maxsht
	label $w.slid.maxsht.txt -text "Max player shots"
	scale $w.slid.maxsht.scale -orient horizontal -from 0 -to 500 -command \
                "set_shots" -bg Bisque1 -relief flat -length 200
        pack $w.slid.maxsht.txt $w.slid.maxsht.scale -side top -fill both \
                -expand yes
	$w.slid.maxsht.scale set $maxPlayerShots

	frame $w.slid.lives
	label $w.slid.lives.txt -text "Lives"
        scale $w.slid.lives.scale -orient horizontal -from 0 -to 10 -command \
                "set worldLives" -bg Bisque1 -relief flat -length 200
        pack $w.slid.lives.txt $w.slid.lives.scale -side top -fill both \
                -expand yes
        $w.slid.lives.scale set $worldLives

	frame $w.slid.fps
	label $w.slid.fps.txt -text "Frames per second"
	scale $w.slid.fps.scale -orient horizontal -from 1 -to 25 -command \
		"set framesPerSecond" -bg Bisque1 -relief flat -length 200
        pack $w.slid.fps.txt $w.slid.fps.scale -side top -fill both \
                -expand yes
        $w.slid.fps.scale set $framesPerSecond

	frame $w.slid.pizza
	label $w.slid.pizza.txt -text "Game duration"
	scale $w.slid.pizza.scale -orient horizontal -from 0 -to 60 -command \
		"set gameDuration" -bg Bisque1 -relief flat -length 200
	pack $w.slid.pizza.txt $w.slid.pizza.scale -side top -fill both \
		-expand yes
	$w.slid.pizza.scale set $gameDuration

	frame $w.slid.fuel
	label $w.slid.fuel.txt -text "Min start fuel"
	scale $w.slid.fuel.scale -orient horizontal -from 50 -to 1500 \
		-command "set playerMinimumStartFuel" -bg Bisque1 -relief \
		flat -length 200
	pack $w.slid.fuel.txt $w.slid.fuel.scale  -side top -fill both \
                -expand yes
	$w.slid.fuel.scale set $playerMinimumStartFuel

	pack $w.slid.shpmas $w.slid.shtmas $w.slid.shtspd $w.slid.shtlif \
		$w.slid.firrep $w.slid.maxsht $w.slid.lives $w.slid.fps \
		$w.slid.pizza $w.slid.fuel -side top -side top -fill both \
	 	-expand yes

	frame $w.check

	checkbutton $w.check.extra -text "Extra border" -variable extraBorder \
		-relief flat -anchor w -command "set_extra"
	checkbutton $w.check.ebnce -text "Edge bounce" -variable edgeBounce \
		-relief flat -anchor w -command "set_bounce"
	checkbutton $w.check.ewrap -text "Edge wrap" -variable edgeWrap \
		-relief flat -anchor w -command "set_wrap"
	checkbutton $w.check.oneplayer -text "One player only" -variable \
		onePlayerOnly -relief flat -anchor w
	checkbutton $w.check.shtgrv -text "Shots affected by gravity" -variable\
		shotsGravity -anchor w -relief flat
	checkbutton $w.check.raw -text "Raw mode" -variable rawMode -anchor w \
		-relief flat
	checkbutton $w.check.noquit -text "No quit" -variable noQuit -anchor \
		w -relief flat
	checkbutton $w.check.report -text "Report to the MetaServer" -variable \
		reportToMetaServer -anchor w -relief flat
	checkbutton $w.check.limvis -text "Limited visibility" -variable \
		limitedVisibility -anchor w -relief flat
	checkbutton $w.check.limliv -text "Limited lives" -variable \
		limitedLives -anchor w -relief flat -command "set_lives"
	checkbutton $w.check.race -text "Race Mode" -variable \
		timing -anchor w -relief flat

	pack $w.check.extra $w.check.ebnce $w.check.ewrap $w.check.oneplayer \
		$w.check.shtgrv $w.check.raw $w.check.noquit $w.check.report \
		$w.check.limvis $w.check.limliv $w.check.race -side top -fill \
		both -expand yes 

	frame $w.ent

	frame $w.ent.port
	label $w.ent.port.txt -text "Contact port"
	entry $w.ent.port.ent -relief sunken
	pack $w.ent.port.txt $w.ent.port.ent -side top
	$w.ent.port.ent insert 0 $contactPort

	set num_teams 9

	frame $w.ent.team
	label $w.ent.team.txt -text "Team to join"
	pack $w.ent.team.txt -side top
	for {set num 0} {$num <= $num_teams} {set num [expr $num + 1]} {
		radiobutton $w.ent.team.$num -text $num -variable team_to_join \
			-value $num -relief flat
		pack $w.ent.team.$num -side top
	}

	pack $w.ent.port $w.ent.team -side top

	pack $w.slid $w.check $w.ent -side left -fill both -expand yes

	pack $w

	set_lives
}
