    #include "ttc.l.h"
    #include "ext_ttc.h"
    #include "ttc.tab.h"
    int field_number = 0 ;
    int frame = 0 ;

%x procName progArgs 
%x command commandArgs commandList field commandSub variableSub
%x quoted_field braced_field array_field backslash_sub

%{
fieldStack 
   argStack[500] ;


extern int
  num_procs ;
int 
  push() , pop() , argStackCtr = -1 , tmp_int ;
  

int cmd_mode = 0 , array_mode = 0 ; /* either TRUE or FALSE. determines what action should */
	             /* occur during field parsing when ')' is encountered */

extern YYSTYPE yylval ;

extern char
  flex_name_1 [] , raw_text [] , * raw ;
char 
  tmp_char , tmp_string[10000] ;

extern Tcl_Interp 
  * shared_interp ;
%}


VISIBLE_CHAR 	([!-~])
ID		[0-9A-Z_-z]+
WHITESPACE	[ \t]
QUOTE_MARK	\"
OPEN_BRACE	"{"
CLOSED_BRACE	"}"
VARIABLE_SUB    ("$"{ID})|("${"{ID}"}")
COMMAND_SUB     ("["{ID}{WHITESPACE}*"]")
TRIVIAL_LIST	{VISIBLE_CHAR}+
BRACED_LIST	({QUOTE_MARK}({WHITESPACE}*{LIST_OPT_1})+{QUOTE_MARK})
QUOTED_LIST7	({OPEN_BRACE}({WHITESPACE}*{LIST_OPT_1})+{CLOSED_BRACE})
LIST		{TRIVIAL_LIST}|{BRACED_LIST}|{QUOTED_LIST}



%%
"#".*$     /* procArgs is imprecise */
{WHITESPACE}+
"\n"
"proc"[ \t]+            BEGIN (procName) ; ++num_procs ; return PROC ;
<procName>[^ \t]+       BEGIN (progArgs) ;    ttv()    ; return PROC_NAME ;
<progArgs>[ \t]+.+/"{"	BEGIN (commandList) ; ttv()    ; return PROC_ARGS ;
<progArgs>[ \t]+.*/\"	BEGIN (commandList) ; ttv()    ; return PROC_ARGS ;


<commandList>"{"	push (command) ;               ; return '{' ;
<commandList>\"		push (command) ;               ; return '"' ;


<command>"#".*$
<command>"\n"+
<command>{WHITESPACE}+
<command>"}"		BEGIN (INITIAL) ;              ; return '}' ;
<command>{VISIBLE_CHAR}{1}    {
   unput(yytext[0]) ; 
   field_number = 0 ; 
   push (field) ; 
   reset_raw () ;
 }


<field>"$" {
  push (variableSub) ;             
  return '$' ;
}
<field>"["	{
  push (commandSub) ;
  return '[' ;
}
<field>"\\"   push (backslash_sub) ;

<field>\"	{
  push (quoted_field) ;
  yylval = strdup ("\\\"") ;
  reset_raw () ;
  return RAW_TEXT ;
}

<field>";" 	{
  ++field_number ; 
  reset_raw () ;
  pop () ; 
  return ';' ;
}
<field>"\n"+	{
  ++field_number ; 
  reset_raw () ;
  pop () ; 
  return '\n' ;
}
<field>"{"	{
  push (braced_field) ;    
  add_raw ("{") ; 
}
<field>{WHITESPACE}+	{
  ++field_number ;        
  reset_raw () ; 
  return ' ' ;
}
<field>[^\]\t\ $[\\;\n"{]+	{
  add_raw (yytext) ; 
  yylval = strdup (raw) ;
  reset_raw () ;
  return RAW_TEXT ;
}


<quoted_field>"$"  	push (variableSub) ; return '$' ;
<quoted_field>"["	push (commandSub)  ; return '[' ;
<quoted_field>"]"	{
  if (cmd_mode) {
    cmd_mode = 0 ;
    return ']' ;
  } else {
   add_raw (yytext) ;
   yylval = strdup (raw) ;
   reset_raw () ;
   return RAW_TEXT ;
 }
}

<quoted_field>"\""   add_raw ("\\")  ; add_raw ("\""); rtv (); pop() ; return RAW_TEXT ;
<quoted_field>"\\\"" add_raw ("\\\\"); add_raw ("\\\""); rtv (); return RAW_TEXT ;
<quoted_field>"\\"   push (backslash_sub) ;

<quoted_field>[^$[\\")]+    {
    add_raw (yytext) ; 
    yylval = (YYSTYPE) strdup(raw) ; 
    reset_raw () ;
    return RAW_TEXT ;
}


<backslash_sub>"b"  { 
  sprintf (tmp_string,"%c", 0x8) ; 
  add_raw (tmp_string) ; 
  pop () ; 
  return RAW_TEXT ;
}
<backslash_sub>f sprintf(tmp_string,"%c", 0xc) ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>n sprintf(tmp_string,"%c", 0xa) ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>r sprintf(tmp_string,"%c", 0xd) ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>t sprintf(tmp_string,"%c", 0x9) ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>v sprintf(tmp_string,"%c", 0xb) ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>"{" sprintf(tmp_string,"%c", '{') ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>"}" sprintf(tmp_string,"%c", '}') ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>"[" sprintf(tmp_string,"%c", '[');add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>"]" sprintf (tmp_string,"%c", ']'); add_raw(tmp_string);pop () ; return RAW_TEXT ;
<backslash_sub>"$" sprintf(tmp_string,"%c", '$') ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>" " sprintf(tmp_string,"%c", ' '); add_raw(tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>; sprintf(tmp_string,"%c", ';') ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>\n  pop () ; return RAW_TEXT ;
<backslash_sub>"\\" sprintf(tmp_string,"%c", 92) ; add_raw (tmp_string) ;pop () ; return RAW_TEXT ;
<backslash_sub>"000"  pop () ; return RAW_TEXT ;
<backslash_sub>[0-1][0-7][0-7]   sprintf (tmp_string,"%o", yytext) ; add_raw (tmp_string) ; pop () ; return RAW_TEXT ;
<backslash_sub>["]   sprintf (tmp_string,"%s", yytext) ; add_raw (tmp_string) ; pop () ; return RAW_TEXT ;



<braced_field>"\\{"	add_raw ("{") ;
<braced_field>"\\}"	add_raw ("}") ;
<braced_field>"\\\n"	
<braced_field>"{"	add_raw ("{") ; push (braced_field) ;
<braced_field>"}"	{
    add_raw ("}") ; 
    if (pop () == braced_field) { ; }
    else {yylval = strdup (raw) ; reset_raw () ; return RAW_TEXT ;}
  }
<braced_field>"\""     add_raw ("\\")   ; add_raw ("\"")   ;
<braced_field>"\\\""   add_raw ("\\\\") ; add_raw ("\\\"") ;
<braced_field>"\\"     add_raw ("\\\\") ;
<braced_field>{WHITESPACE}*"#".*$
<braced_field>{WHITESPACE}+ add_raw (yytext) ;
<braced_field>"\n" add_raw (yytext) ;
<braced_field>{VISIBLE_CHAR}{1} add_raw (yytext) ;


<commandSub>"$" {
  push (variableSub) ;             
  return '$' ;
}
<commandSub>"["	{
  push (commandSub) ;
  return '[' ;
}
<commandSub>"]"	{
  pop () ;
  return ']' ;
}

<commandSub>"\\"   push (backslash_sub) ;

<commandSub>\"	{
  push (quoted_field) ;
  yylval = strdup ("\\\"") ;
  reset_raw () ;
  return RAW_TEXT ;
}
<commandSub>{WHITESPACE}+	{
  ++field_number ;        
  reset_raw () ; 
  return ' ' ;
}
<commandSub>[^$\[\]\\\"\ \t]+   {
  add_raw (yytext) ; 
  yylval = strdup (raw) ;
  reset_raw () ;
  return RAW_TEXT ;
}



<variableSub>"{".+"}"    {

    sprintf (tmp_string, "source oop.string.tcl ; set x [chopRight \"%s\" 1] ; set x [chopLeft $x 1]" , yytext) ; 
    Tcl_Eval (shared_interp, tmp_string, 0, 0) ; 
    yylval = strdup (shared_interp->result) ;
    pop() ; 
    return SCALAR ;
}

<variableSub>[A-Za-z0-9_]+/"("  {
    array_mode = 1 ; 
    strcpy (flex_name_1,yytext) ;
    BEGIN (quoted_field) ; 
    return ARRAY_NAME ;
  }

<variableSub>[A-Za-z0-9_]+    {
  yylval = (YYSTYPE) yytext ;
  pop () ; 
  return SCALAR ;
}


%%

add_raw (string) char * string ; {

  int a , b ;
  char * new_space ;

  a = strlen (raw) ;
  b = strlen (string) ;
  
  new_space = (char *) malloc (a+b+1) ;
  strcpy (new_space , raw) ;
  strcat (new_space , string) ;

  free (raw) ;
  raw = new_space ;

}

reset_raw () {
  
  raw[0] = (char) NULL ;

   }

show_stack () {

  int i ;

  for (i=argStackCtr ; i >= 0 ; --i) {
    printf ("stack_level: %d  [*-/-*] sc: %d \n" , i , argStack[i].start_condition) ;
  }

}

push (argState) int argState ;  {

  ++argStackCtr ;
  argStack[argStackCtr].start_condition = argState ;

  printf ("------------ push \n") ;
  show_stack () ;

  BEGIN (argState) ;
}

pop  ()  {
   --argStackCtr ;

  printf ("------------ pop \n") ;
  show_stack () ;

   BEGIN ( current_start_condition () ) ;
   return  current_start_condition ()   ;
}

current_start_condition ()  {
   return (argStack[argStackCtr].start_condition) ;
}

/* yytext to yylval */
ttv () {

   yylval = (YYSTYPE) yytext ;

}     
/* raw to yylval */
rtv () {

   yylval = (YYSTYPE) strdup(raw) ;
   reset_raw () ;
   
}     
