/*
 * A simple netrek checker to see who is logged on and display the info in an
 * X window, the icon is also a flag for what is going on.
 *
 * (C) J.W.Hawtin 4/1/93
 * jwh@cs.bham.ac.uk
 * AKA Commodore wibble
 *
 * Permission is give to copy and change the code so long as it program is
 * never sold, when distributed the full source is made available, and this
 * header is never removed.

 *
 * Version 2
 *
 * 15/1/92
 *
 * Well the icon now works with OLWM as well as TWM!
 *
 * If it cannot check the players via the telnet port it will then try to
 * use ck_players, please note you must tell the program where it is and use
 * my modified (better) version. See #define below
 *
 */

#include <stdio.h>
#include <X11/X.h>
#include <X11/Xlib.h>   /* X.h and Xlib.h used for Xlib graphics */
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/font.h>
#include <xview/xv_xrect.h>
#include <xview/svrimage.h>
#include <xview/icon.h>
#include <xview/notify.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <string.h>
#include <strings.h>
#include <signal.h>

#define TIME           5
#define TMODE          4
#define CKPLAYERS      "/home/cgneiss/cgjwh/bin/ck_players"
#define NTSERVER       "netrek.cs.bham.ac.uk"
#define PORT           2591
#define NTPORT         2592

void my_repaint_proc();

int time;
int tmode;
char ntserver[80];
char title[100];
int port;
int ntport;

#define GC_KEY  10 /* any arbitrary number -- used for XV_KEY_DATA */

#define MAXSTRLEN 1024
#define LIST_SIZE 16*MAXSTRLEN

/* For some odd systems, which don't put this in errno.h. */

extern int errno;
GC gc;
Window canvas_win;
static int sock, finished;
Display *dpy;

Notify_value netrek_check();
int number_old;
int count;

char message[LIST_SIZE];
char tmp_message[LIST_SIZE];
struct itimerval timer;

Server_image  netrek_image[24];
Icon          check_icon;
Frame         frame;

short icon0[] =  {
#include "0.icon"
};

short icon1[] =  {
#include "1.icon"
};

short icon2[] =  {
#include "2.icon"
};

short icon3[] =  {
#include "3.icon"
};

short icon4[] =  {
#include "4.icon"
};

short icon5[] =  {
#include "5.icon"
};

short icon6[] =  {
#include "6.icon"
};

short icon7[] =  {
#include "7.icon"
};

short icon8[] =  {
#include "8.icon"
};

short icon9[] =  {
#include "9.icon"
};

short icon10[] =  {
#include "10.icon"
};

short icon11[] =  {
#include "11.icon"
};

short icon12[] =  {
#include "12.icon"
};

short icon13[] =  {
#include "13.icon"
};

short icon14[] =  {
#include "14.icon"
};

short icon15[] =  {
#include "15.icon"
};

short icon16[] =  {
#include "16.icon"
};

short icon17[] =  {
#include "17.icon"
};

short icon18[] =  {
#include "18.icon"
};

short icon19[] =  {
#include "19.icon"
};

short icon20[] =  {
#include "20.icon"
};

short icon21[] =  {
#include "Tmode.icon"
};


short icon22[] =  {
#include "wait.icon"
};

short icon23[] =  {
#include "down.icon"
};

draw()
{
  char line[96];
  int count=0, chrs, y=12;

  sprintf(line,"Checking Server %s",ntserver);
  
  XDrawImageString(dpy, canvas_win, gc, 3, 12, line, strlen(line));

  line[95]='\0';
  while(message[count]!=0)
  {
    chrs=0;

    y+=12;
    
    while ((message[count]!='\0')&&(message[count]!='\n'))
    {
      if (chrs<95)
	line[chrs++]=message[count++];
    }
    line[chrs]='\0';

    XDrawImageString(dpy, canvas_win, gc, 3, y,
		line, chrs);
    if (message[count]='\n')
      count++;
  }
}

/*
 * Called every time the window needs repainting.
 */
void my_repaint_proc(canvas, pw, dpy, xwin, xrects)
Canvas          canvas;
Xv_Window       pw;
Display         *dpy;
Window          xwin;
Xv_xrectlist    *xrects;
{
  draw();
}

int connect_to(st,port)			/* Try to make a connection. */
char *st;
int port;
{
  struct in_addr host_address;
  struct sockaddr_in socket_address;
  int err;
    
  if (!get_host_address(st, &host_address)) { /* Can't do it. */
    return(0);
  }
  
  socket_address.sin_family = AF_INET;
  socket_address.sin_port = htons(port);
  bcopy(&host_address, &socket_address.sin_addr, sizeof(struct in_addr));
  
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    /*perror("% Couldn't open socket");*/
    return(0);
  }
  
  err = connect(sock, &socket_address, sizeof(struct sockaddr_in));
  if (err < 0) {
    /*perror("% Couldn't connect to socket");*/
    return(0);
  }
  
#ifdef FNDELAY
  fcntl(sock, F_SETFL, FNDELAY);    /* Do we need this? */
#endif

  return(1);				/* Success! */
}

int get_host_address(name, addr)	/* Get a host address. */
  register char *name;
  register struct in_addr *addr;
{
  struct hostent *blob;
  union {				/* %#@!%!@%#!@ idiot who designed */
    long signed_thingy;			/* the inetaddr routine.... */
    unsigned long unsigned_thingy;
  } thingy;

  if (*name == '\0') {
    fprintf(stderr, "%% No host address specified.\n");
    exit (0);
  }

  if ((*name >= '0') && (*name <= '9')) {	/* IP address. */
    addr->s_addr = inet_addr(name);
    thingy.unsigned_thingy = addr->s_addr;
    if (thingy.signed_thingy == -1) {
      fprintf(stderr, "%% Couldn't find host %s .\n", name);
      exit (0);
    }
  }
  else {				/* Host name. */
    blob = gethostbyname(name);

    if (blob == NULL) {
      fprintf(stderr, "%% Couldn't find host %s .\n", name);
      exit (0);
    }

    bcopy(blob->h_addr, addr, sizeof(struct in_addr));
  }

  return (1);				/* Success. */
}

disconnect()		 /* Disconnect from current world. */
{
  close(sock);
}

transmit(s, l)
  char *s;
  int l;
{
  register int err;

  err = send(sock, s, l, 0);
  if (err == -1)
    perror("send failed");  
}

receive(s)
register char *s;
{
  register int count;
  
  count = recv(sock, s, MAXSTRLEN, 0);
  if (count == -1)
    if (errno == EWOULDBLOCK)
      s[0] = '\0';
    else
      perror("recv failed");
  else
    s[count] = '\0';

  if (count <= 0)                       /* Check for end of message. */
    finished = TRUE;
}


int check_server()
{
  char s[MAXSTRLEN+10], line[100];
  fd_set readers, exceptions;
  int count, chrs = 0, ret;
  int connected=0;
  
  int player=0;    /* The number of full player sockets */
  int fed = 0, rom = 0,  ori = 0, kli = 0; /* number of real players on each */
  int ind = 0, oth = 0; 	     	   /* team (not robots) */
  int robot=0;                             /* number of robots */
  int all=0;                               /* number of full sockets (all) */
  int Tteams=0;                            /* Number of teams over T treshold*/

  tmp_message[0]='\0';
  finished = FALSE;
  
  if (connect_to(ntserver,port)==1)
  {
    sleep(2);
    while(finished==FALSE)
    {
      
      /* setup so multiplex checks socket */
      FD_ZERO(&exceptions);
      FD_ZERO(&readers);
      FD_SET(sock, &readers);   /* Check socket. */
      
      count = select(sock + 1, &readers, NULL, &exceptions, NULL);
      if (count == -1)
      {
	if (errno != EINTR)
	  perror("select");
      }
      else
	if (count!=0)
	{
	  if (FD_ISSET(sock, &readers))
	  {
	    receive(s);
	    strcat(tmp_message,s);
	  }
	}
    }
    disconnect();
    sprintf(message,"Connection obtained via info port %d\n\n%s",port,tmp_message);
    connected =1;
  }
  else
  {
    FILE *tmp;
    int count =0, tp;
    char cll[256];

    
    sprintf(cll,"%s %s %d",CKPLAYERS,ntserver,ntport);
    tmp = popen(cll,"r");
    while (!feof(tmp))
    {
      tp = getc(tmp);
      if (tp < (LIST_SIZE-1))
	tmp_message[count++]=tp;
    }
     tmp_message[count-1]=0;
    pclose(tmp);
    sprintf(message,"Using connection via Netrek port %d\n\n%s",ntport,tmp_message);

    if (strstr(tmp_message,"Queue with")!=NULL)
      return(22);

    if (strstr(tmp_message,"Nobody is currently playing this server")!=NULL)
      return(0);
  }

  count=0;
  
  line[95]='\0';
  while(message[count]!=0)
  {
    char buf[3];
    
    chrs=0;
    
    while ((message[count]!='\0')&&(message[count]!='\n'))
    {
      if (chrs<95)
	line[chrs++]=message[count++];
    }
    line[chrs]='\0';
    buf[2]=0;
    
    if (message[count]=='\n')
    {
      int count2=0;
      
      buf[2]=0;
      count++;
      while ((buf[2]!=':')&&(line[count2++]!=0))
      {
	buf[0]=buf[1];
	buf[1]=buf[2];
	buf[2]=line[count2];
	
	if (buf[2]==':')
	  if (strchr("FOKRI ",buf[0])!=NULL)
	    if (strchr("0123456789abcdefghij ",buf[1])!=NULL)
	    {
	      all++;
	      
	      if (strchr("0123456789abcdef",buf[1])!=NULL)
		player++;
	      
	      /* ok we have a valid slot, check if it is a robot */
	      if ((strstr(line,"Robot")!=NULL)
		  && (strstr(line,"Nowhere")!=NULL))
	      {
		/* Robot! */
		robot++;
	      }
	      else
	      {
		switch (buf[0])
		{
		case 'F':
		  if (++fed == tmode)
		    Tteams++;
		  break;
		case 'O':
		  if (++ori == tmode)
		    Tteams++;
		  break;
		case 'K':
		  if (++kli == tmode)
		    Tteams++;
		  break;
		case 'R':
		  if (++rom == tmode)
		    Tteams++;
		  break;
		case 'I':
		  ind++;
		  break;
		default:
		  oth++;
		  break;
		}
	      }
	    }
      }
    }
  }
  ret = fed + ori + kli + rom + ind;
  if (Tteams>1)
    ret = 21;
  if (player==16)
    ret = 22;
  /*
  printf("\n\nFed %d\n",fed);
  printf("Ori %d\n",ori);
  printf("Rom %d\n",rom);
  printf("Kli %d\n",kli);
  printf("Ind %d\n",ind);
  printf("Oth %d\n",oth);
  printf("Players slots full %d\n",player);
  printf("All slots %d\n",all);
  printf("Robots %d\n",robot);
  */
  if ((all==0) && (connected==0))
    return(23);
  else
    return ret;
}


Notify_value netrek_check(client, which)
Notify_client client;
int which;
{
  int number;
  
  count = ++count % (120 * time);

  if (count==1)
  {
    number = check_server();
    if (number != number_old)
    {

      xv_set(check_icon,
	     ICON_IMAGE, netrek_image[number],
	     WIN_RETAINED, TRUE,
	     NULL);
      
      xv_set(frame, FRAME_ICON, check_icon, NULL);
    }
    number_old = number;
    XClearWindow(dpy, canvas_win);
    draw();
  }
  return NOTIFY_DONE;
}

main(argc, argv)
int     argc;
char    *argv[];
{
    Canvas        canvas;
    XGCValues     gcvalues;
    Xv_Font       font;
    int n;
    char *name, *ptr;
    
    time = TIME;
    tmode = TMODE;
    strcpy(ntserver,NTSERVER);
    port = PORT;
    ntport = NTPORT;
    
    xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

    name = *argv++;
    argc--;
    while (*argv)
    {
      if (**argv == '-')
	++*argv;
      else
	break;
      
      argc--;
      ptr = *argv++;
      while (*ptr) {
	switch (*ptr)
	{
	case '?': printf("Usage: %s [-h hostname] [-p connect socketnum] [-t tmode level]\n       [-u update time]\n",name);
	  exit(0);
	  break;
	case 'p':
	  if (*argv)
	  {
	    ntport=atoi(*argv);
	    argv++;
	    argc--;
	  }
	  break;
	case 't':
	  if (*argv)
	  {
	    tmode=atoi(*argv);
	    argv++;
	    argc--;
	  }
	  break;
	case 'u':
	  if (*argv)
	  {
	    time=atoi(*argv);
	    argv++;
	    argc--;
	  }
	  if (time<2)
	    time=2;
	  break;
	case 'h':
	  strcpy(ntserver, *argv);
	  argc--;
	  argv++;
	  break;
     	default:
	  fprintf(stderr, "%s: unknown option '%c'\n", name, *ptr);
	  printf("Usage: %s [-h hostname] [-p connect socketnum] [-t tmode level]\n       [-u update time]\n",name);
	  exit(0);
	  break;
	}
	ptr++;
      }
    }
 {
   char *tmp;

   tmp = rindex(name,'/');
   if (tmp == NULL)
     strcpy(title,name);
   else
     strcpy(title,tmp+1);
 }
    strcat(title,"@");
    strcat(title,ntserver);
    frame = (Frame)xv_create(XV_NULL, FRAME, FRAME_LABEL, title, NULL);
    
    xv_set(frame, WIN_CONSUME_EVENTS, NULL, NULL);

    
    netrek_image[0] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon0,
					      NULL);
    
    netrek_image[1] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon1,
					      NULL);
    
    netrek_image[2] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon2,
					      NULL);
    
    netrek_image[3] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon3,
					      NULL);
    
    netrek_image[4] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon4,
					      NULL);

    netrek_image[5] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon5,
					      NULL);

    netrek_image[6] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon6,
					      NULL);

    netrek_image[7] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon7,
					      NULL);


    netrek_image[8] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon8,
					      NULL);

    netrek_image[9] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon9,
					      NULL);
    netrek_image[10] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon10,
					      NULL);
    
    netrek_image[11] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon11,
					      NULL);
    
    netrek_image[12] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon12,
					      NULL);
    
    netrek_image[13] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon13,
					      NULL);
    
    netrek_image[14] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon14,
					      NULL);

    netrek_image[15] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon15,
					      NULL);

    netrek_image[16] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon16,
					      NULL);

    netrek_image[17] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon17,
					      NULL);


    netrek_image[18] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon18,
					      NULL);

    netrek_image[19] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon19,
					      NULL);

    netrek_image[20] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon20,
					      NULL);

    netrek_image[21] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon21,
					      NULL);

    netrek_image[22] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					      XV_WIDTH, 64,
					      XV_HEIGHT,64,
					      SERVER_IMAGE_BITS, icon22,
					      NULL);

    netrek_image[23] = (Server_image)xv_create(NULL, SERVER_IMAGE,
					       XV_WIDTH, 64,
					       XV_HEIGHT,64,
					       SERVER_IMAGE_BITS, icon23,
					       NULL);
 
    count =0;

    timer.it_value.tv_usec = 500000;
    timer.it_interval.tv_usec = 500000;
    
    notify_set_itimer_func(frame, netrek_check,ITIMER_REAL, &timer, NULL);
    
    canvas = (Canvas)xv_create(frame, CANVAS,
        XV_WIDTH,               475,
        XV_HEIGHT,              350,
        CANVAS_X_PAINT_WINDOW,  TRUE,
        CANVAS_REPAINT_PROC,    my_repaint_proc,
        NULL);
    window_fit(frame);

    canvas_win = (Window) xv_get(canvas_paint_window(canvas), XV_XID);
    
    dpy = (Display *)xv_get(frame, XV_DISPLAY);
    font = (Xv_Font)xv_find(frame, FONT, FONT_NAME, "lucidatypewriter-10", NULL);
    if (!font) {
        fprintf(stderr, "%s: cannot use font: courier.\n", argv[0]);
        font = (Xv_Font)xv_get(frame, XV_FONT);
    }

    /* Create a GC to use with Xlib graphics -- set the fg/bg colors
     * and set the Font, which is the XV_XID of the XView font object.
     */
    gcvalues.font = (Font)xv_get(font, XV_XID);
    gcvalues.foreground = BlackPixel(dpy, DefaultScreen(dpy));
    gcvalues.background = WhitePixel(dpy, DefaultScreen(dpy));
    gcvalues.graphics_exposures = False;
    gc = XCreateGC(dpy, RootWindow(dpy, DefaultScreen(dpy)),
        GCForeground | GCBackground | GCFont | GCGraphicsExposures,
        &gcvalues);


    message[0]='\0';
    number_old=-1;


    check_icon = (Icon) xv_create(NULL, ICON,
				  ICON_IMAGE, netrek_image[23],
				  WIN_RETAINED, TRUE,
				  NULL);
    
    xv_set(frame, FRAME_ICON, check_icon, NULL);
    
    xv_main_loop(frame);
}
