# Program: xf
# Description: paste functions
#
# $Header: xfcut.tcl[2.3] Wed Mar 10 12:05:36 1993 garfield@garfield frozen $

##########
# Procedure: XFPasteFile
# Description: paste file to current path
# Arguments: xfW - the widget to paste to
#            xfFileName - the filename to paste from
#            {xfSaveAsProc} - paste with variable as pathname
# Returns: none
# Sideeffects: none
##########
proc XFPasteFile {xfW xfFileName {xfSaveAsProc 0}} {
  global xfPath
  global xfStatus

  # get the cutted widget name
  if {![catch "open $xfFileName r" xfInFile]} {
    set xfFileContents [read $xfInFile]
    close $xfInFile
    set xfLine [lindex [split $xfFileContents "\n"] 0]
    if {"[string trim $xfLine]" == ""} {
      XFProcError "Pastebuffer not in correct format"
      return
    }
    if {[string length [lindex $xfLine 0]] != 1 ||
        "[lindex $xfLine 0]" != "#"} {
      XFProcError "Pastebuffer not in correct format\nI got:\n[lindex $xfLine 0]"
      return
    }
    set xfCuttedName [lindex $xfLine 1]
    if {"$xfCuttedName" == ""} {
      XFProcError "Pastebuffer not in correct format."
      return
    }
    if {"$xfCuttedName" == "XFNoParsing"} {
      if {[catch "source $xfFileName" xfResult]} {
        XFProcError $xfResult
      }
      return
    }

    set xfPasteString ""
    set xfPasteElement [string range [lindex $xfCuttedName 0] \
          [expr [string last . [lindex $xfCuttedName 0]]+1] end]
    set xfNewPasteElement $xfPasteElement
    set xfPasteName "paste"
    set xfPasteNumber 0
    regexp {[A-Za-z0-9_-]+} $xfPasteElement xfPasteName
    regexp {[A-Za-z_-]+} $xfPasteElement xfPasteClass
    regexp {[0-9]+} $xfPasteElement xfPasteNumber
    set xfNewPasteElement [XFMiscGetUniqueName $xfPasteName $xfPasteClass $xfW]
    if {"$xfW" == "."} {
      set xfTopPath1 "."
      set xfTopPath2 "."
    } {
      if {$xfSaveAsProc} {
        set xfTopPath1 "\$insertWidgetPath."
        set xfTopPath2 "\$insertWidgetPath"
      } {
        set xfTopPath1 "$xfW."
        set xfTopPath2 "$xfW"
      }
    }
    if {$xfPasteNumber > $xfStatus(elementCounter)} {
      incr xfStatus(elementCounter)
    }
    set xfOldPath [string range [lindex $xfCuttedName 0] \
      0 [expr [string last . [lindex $xfCuttedName 0]]-1]]
    if {"$xfOldPath" == ""} {
      set xfOldPath .
    }

    set xfCuttedName [XFMiscExpandRegexp $xfCuttedName]
    set xfOldPath [XFMiscExpandRegexp $xfOldPath]
    foreach xfLine [split $xfFileContents "\n"] {
      if {[regsub -all "\[ 	\]+$xfCuttedName" $xfLine \
        "\ $xfTopPath1$xfNewPasteElement" xfLine] != 1} {
        regsub -all "\[	 \]+$xfOldPath" $xfLine "\ $xfTopPath2" xfLine
      }
      if {[regsub -all "\{$xfCuttedName" $xfLine \
        "\{$xfTopPath1$xfNewPasteElement" xfLine] != 1} {
        regsub -all "\{$xfOldPath" $xfLine "\{$xfTopPath2" xfLine
      }
      if {[regsub -all "\\\[$xfCuttedName" $xfLine \
        "\[$xfTopPath1$xfNewPasteElement" xfLine] != 1} {
        regsub -all "\\\[$xfOldPath" $xfLine "\[$xfTopPath2" xfLine
      }
      if {[regsub "^$xfCuttedName" $xfLine \
        "$xfTopPath1$xfNewPasteElement" xfLine] != 1} {
        regsub "^$xfOldPath" $xfLine "$xfTopPath2" xfLine
      }
      append xfPasteString "$xfLine\n"
    }

    if {[catch "$xfPasteString" xfResult]} {
      XFProcError $xfResult
    }
    XFMiscBindWidgetTree $xfTopPath1$xfNewPasteElement
    XFEditSetPath $xfStatus(path)
  }
}

##########
# Procedure: XFPasteUpdate
# Description: update the displayed pastebuffer
# Arguments: none
# Returns: none
# Sideeffects: none
##########
proc XFPasteUpdate {} {
  global xfPath
  global xfStatus

  if {![file exists $xfPath(tmp)/cb$xfStatus(uniqueId)]} {
    if {$xfStatus(pasteScriptDisplayed)} {
      set xfStatus(pasteScriptDisplayed) 0
      destroy .xfCutbuffer
    }
    if {$xfStatus(pasteTreeDisplayed)} {
      set xfStatus(pasteTreeDisplayed) 0
      destroy .xfCutPaste
    }
  } {
    if {$xfStatus(pasteScriptDisplayed)} {
      XFMiscSetText .xfCutbuffer.frame0.text1 \
        [exec cat $xfPath(tmp)/cb$xfStatus(uniqueId)]
    }
    if {$xfStatus(pasteTreeDisplayed)} {
      foreach xfCounter [winfo children .xfCutPaste.frame1] {
        destroy $xfCounter
      }
      XFPasteFile .xfCutPaste.frame1 $xfPath(tmp)/cb$xfStatus(uniqueId)
    }
  }
}

##########
# Procedure: XFPasteShowTree
# Description: show the current cutbuffer as tree
# Arguments: none
# Returns: none
# Sideeffects: none
##########
proc XFPasteShowTree {} {
  global xfPath
  global xfStatus

  # build widget structure
  XFTmpltToplevel .xfCutPaste 200x200 {XF current cut buffer}
  
  XFTmpltFrame .xfCutPaste.frame1

  XFTmpltFrame .xfCutPaste.frame2 0

  button .xfCutPaste.frame2.ok \
    -text {OK} \
    -command {
      global xfStatus
      set xfStatus(pasteTreeDisplayed) 0
      destroy .xfCutPaste}

  # paste tree
  XFPasteFile .xfCutPaste.frame1 $xfPath(tmp)/cb$xfStatus(uniqueId)

  # packing
  pack append .xfCutPaste.frame2 \
              .xfCutPaste.frame2.ok {left fill expand}
  pack append .xfCutPaste \
              .xfCutPaste.frame2 {bottom fill} \
              .xfCutPaste.frame1 {top fill expand}
}

# eof

