# tkIconPane.tcl
#
# Copyright (c) 1993 by Sven Delmas
# All rights reserved.
# See the file COPYRIGHT for the copyright notes.
#

if {![string compare "" [info commands tkiconpane]]} {

proc tkiconpane {pathName args} {# xf ignore me 7
  global auto_path env ip_priv

  # can we use mega widgets
  if {![string compare "" [info commands megawidget]]} {
    error "the megawidget widget is not available!"
  }

  # raise iconpane if it already exists and is a toplevel
  if {[string compare "" [info commands $pathName]]} {
    if {![string compare "toplevel" [winfo type $pathName]]} {
      raise $pathName
    }
    return
  }

  # find the library file for tkiconpane
  set initMegaName ""
  set initIconName ""
  set searchList ""
  if {[info exists env(XF_LOAD_PATH)]} {
    foreach dirName [split $env(XF_LOAD_PATH) :] {
      lappend searchList $dirName
    }
  }
  foreach dirName $auto_path {
    lappend searchList $dirName
  }
  foreach name $searchList {
    if {[file exists $name/tkMegaWidget.tcl]} {
      set initMegaName $name/tkMegaWidget.tcl
    }
    if {[file exists $name/tkIconPaneInt.tcl]} {
      set initIconName $name/tkIconPaneInt.tcl
    }
  }
  if {![string compare "" $initMegaName]} {
    error "Cannot locate internal tkMegaWidget.tcl file"
  }
  if {![string compare "" $initIconName]} {
    error "Cannot locate internal tkIconPaneInt.tcl file"
  }

  # initialize the data
  set ip_priv(clickCounter) 0
  set ip_priv(currentPane) $pathName 
  set ip_priv(drag&dropIconId) ""
  set ip_priv(drag&dropInterpreter) ""
  set ip_priv(drag&dropPath) ""
  set ip_priv(drag&dropType) 0

  # create the widget
  if {![string compare "-toplevel" [lindex $args 0]] &&
      ![string compare "1" [lindex $args 1]]} {
    if {[catch "topmegawidget $pathName -class TkIconPane -interpreter TkIconPane -crypting 0 -createcommand tkiconpane_create -libfile $initMegaName -userfile $initIconName" result]} {
      error $result
    }
    wm minsize $pathName 10 10
    wm maxsize $pathName 2000 2000
    raise $pathName
  } {
    if {[catch "megawidget $pathName -class TkIconPane -interpreter TkIconPane -crypting 0 -createcommand tkiconpane_create -libfile $initMegaName -userfile $initIconName" result]} {
      error $result
    }
  }
  eval $pathName config $args
}

proc tkiconpane_info {{type "path"} args} {
  global ip_priv

  set pathName $ip_priv(currentPane)
  case $type {
    {tkiconpanename} {
      return [lindex [$pathName config -name] 4]
    }
    {canvaspath} {
      return [lindex [$pathName config -canvaspath] 4]
    }
    {edgeinfo} {
      return [eval $pathName edgeinfo $args]
    }
    {iconinfo} {
      return [eval $pathName iconinfo $args]
    }
    {default} {
      return $pathName
    }
  }
  return ""
}

proc tkiconpane_updateMenu {{menuPath ""}} {
  if {[string compare "" $menuPath]} {
    set pathName [tkiconpane_info tkiconpane]
    $menuPath conf -activebackground \
      [lindex [$pathName config -activebackground] 4]
    $menuPath conf -activeforeground \
      [lindex [$pathName config -activeforeground] 4]
    $menuPath conf -background \
      [lindex [$pathName config -background] 4]
    $menuPath conf -foreground \
      [lindex [$pathName config -foreground] 4]
    $menuPath conf -font [lindex \
      [$pathName config -font] 4]
  }
}

proc tkiconpane_createEdgeMenu {name} {
  menu .emenu-$name \
    -postcommand "tkiconpane_updateMenu .emenu-$name"
}

proc tkiconpane_createIconMenu {name} {
  menu .imenu-$name \
    -postcommand "tkiconpane_updateMenu .imenu-$name"
}

proc tkiconpane_receiveIcon {interp pathName iconId} {
  global ip_priv

  set ip_priv(drag&dropIconId) $iconId
  set ip_priv(drag&dropInterpreter) $interp
  set ip_priv(drag&dropPath) $pathName
}

proc tkiconpane_dropPosition {pathName} {
  global ip_priv

  if {![$pathName confvalue -dragdrop]} {
    return ""
  }
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {$ip_priv(drag&dropType)} {
    set tmpPosition [blt_drag&drop location]
  } {
    set tmpPosition [drag&drop location]
  }
  set tmpX [$canvasPath canvasx [expr [lindex $tmpPosition 0]-[winfo rootx $canvasPath]]]
  set tmpY [$canvasPath canvasy [expr [lindex $tmpPosition 1]-[winfo rooty $canvasPath]]]
  return [list $tmpX $tmpY]
}

}

# eof
