/*
 *-----------------------------------------------------------------------------
 *  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the "Terms and Conditions of Distribution", given in the documentation
 *  to this software, are applicable and the above copyright message appears
 *  in each copy.
 *
 *-----------------------------------------------------------------------------
 *
 *
 *  This file contains the main functions of
 *  the sample application for demonstrating the use of the CTAXT interface
 *
 *  13.12.1993   hp      1st version
 *  21.12.1993   hp      check Tcl/Tk versions first
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include "ctaxt.h"




/*  
 *  external declarations
 */

extern Tcl_CmdProc reportCoords;
extern CTAXT_ExplEventProc handleEventExplicit;
extern CTAXT_TclExtProc extendTcl;




/*
 *  function prototypes
 */

int
createApplicationWorld _ANSI_ARGS_((Display **d,
				    Window *mainWin,
				    Window *topWin,
				    Window *tkParent1,
				    Window *tkParent2,
				    Window *tkParent3,
				    Widget *entry));




int
main (argc,argv)
  int argc;
  char **argv;
{
  Display *display;
  Widget entry;
  Window mainWindow,toplevelWindow,tkParent1,tkParent2,tkParent3;
  int result;


  /*  set up the applications world  */

  createApplicationWorld (&display,
			  &mainWindow,
			  &toplevelWindow,
			  &tkParent1,
			  &tkParent2,
			  &tkParent3,
			  &entry);

  /*  if the application needs to extend Tcl, the necessary calls to
      CTAXT_AddTclExtension() should be done now  */

  result = CTAXT_AddTclExtension ((CTAXT_TclExtProc) extendTcl,
				  (CTAXT_FreeTclExtProc) NULL,
				  (ClientData) NULL);
  if (result != CTAXT_OK) {
    fprintf (stderr,"\n%s\n",CTAXT_GetErrorMessage ());
    exit (1);
  }

  /*  inform CTAXT about application specific Tcl commands  */

  result = CTAXT_AddApplicationCommand ("reportCoords",
					(Tcl_CmdProc) reportCoords,
					(ClientData) entry,
					(Tcl_CmdDeleteProc) NULL,
					tkParent2,
					display);
  if (result != CTAXT_OK) {
    fprintf (stderr,"\n%s\n",CTAXT_GetErrorMessage ());
    exit (1);
  }

  /*  inform CTAXT about explicit event handler  */

  CTAXT_RegisterExplicitEventHandler ((CTAXT_ExplEventProc) 
				        handleEventExplicit);

  /*  create the two Tk main windows within the application's main window  */

  result = CTAXT_PutTclTkInWindow (mainWindow,
				   tkParent1,
				   display,
				   "Interp #1",
				   "startup1.tcl",
				   argc,
				   argv);
  if (result != CTAXT_OK) {
    fprintf (stderr,"\n%s\n",CTAXT_GetErrorMessage ());
    exit (1);
  }
  result = CTAXT_PutTclTkInWindow (mainWindow,
				   tkParent2,
				   display,
				   "Interp #2",
				   "startup2.tcl",
				   argc,
				   argv);
  if (result != CTAXT_OK) {
    fprintf (stderr,"\n%s\n",CTAXT_GetErrorMessage ());
    exit (1);
  }

  /*  check the Tcl/Tk versions  */

  result = CTAXT_CheckVersions ();
  if (result == CTAXT_FATAL_ERROR) {
    fprintf (stderr,"\n%s\n",CTAXT_GetErrorMessage ());
    exit (1);
  }
  if (result != CTAXT_OK) {
    fprintf (stderr,"\nWarning: %s\n",CTAXT_GetErrorMessage ());
  }

  /*  create the Tk main window within the application's toplevel window  */

  result = CTAXT_PutTclTkInWindow (toplevelWindow,
				   tkParent3,
				   display,
				   "Interp #3",
				   "startup3.tcl",
				   argc,
				   argv);
  if (result != CTAXT_OK) {
    fprintf (stderr,"\n%s\n",CTAXT_GetErrorMessage ());
    exit (1);
  }

  /*  finally, enter the event loop  */

  CTAXT_MainLoop ();

  exit (0);
}
