/*
 *-----------------------------------------------------------------------------
 *  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the "Terms and Conditions of Distribution", given in the documentation
 *  to this software, are applicable and the above copyright message appears
 *  in each copy.
 *
 *-----------------------------------------------------------------------------
 *
 *
 *  This file contains the application functions for Tcl extensions for
 *  the sample application for demonstrating the use of the CTAXT interface
 *
 *  13.12.1993   hp      1st version
 *  14.01.1994   hp      Fixed some bugs of incorrect casts like
 *                        (Tcl_CmdProc) proc --> (Tcl_CmdProc *) proc
 */


#include <stdio.h>
#include "ctaxt.h"




/*
 *  external declarations
 */

extern Tcl_CmdProc handleTkBackgroundError;




/*
 *  extendTcl ---
 *
 *  This function registers the function for Tk background error handling
 *  to the given Tcl interpreter
 *
 *  Arguments:
 *
 *    See the CTAXT documentation
 *
 *  Result: 
 *
 *    nobody cares for it
 *
 *  Side effects:
 *
 *    the Tcl interpreter will have a new "tkerror" command
 */

int 
extendTcl (interp,tkwin,clientData)
  Tcl_Interp *interp;
  Tk_Window tkwin;
  ClientData clientData;
{
  Tcl_CreateCommand (interp,
		     "tkerror",
		     (Tcl_CmdProc *) handleTkBackgroundError,
		     (ClientData) NULL,
		     (Tcl_CmdDeleteProc *) NULL);
  return (0);
}
