#
#------------------------------------------------------------------------------
#  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
#
#  Permission to use, copy, modify, and distribute this software and its
#  documentation for any purpose and without fee is hereby granted, provided
#  that the "Terms and Conditions of Distribution", given in the documentation
#  to this software, are applicable and the above copyright message appears in
#  each copy.
#
#------------------------------------------------------------------------------
#
#
#  This file contains the Tcl script for centring the rectangle in the
#  toplevel window of the application for demonstrating the use of the 
#  CTAXT interface
#
#  13.12.1993   hp      1st version
#




proc centreRectangle {canvas rectangle} {

  #
  #  get the current coordinates of the rectangle
  #

  set rectCoords [$canvas coords $rectangle]


  #
  #  calculate the centre of the rectangle
  #

  set rectCentreX [expr {([lindex $rectCoords 2]-[lindex $rectCoords 0])/2}]
  set rectCentreY [expr {([lindex $rectCoords 3]-[lindex $rectCoords 1])/2}]


  #
  #  calculate the new top left corner of the rectangle
  #

  set rectX [expr {[winfo width $canvas]/2-$rectCentreX}]
  set rectY [expr {[winfo height $canvas]/2-$rectCentreY}]

  #
  #  set the coordinates of the rectangle
  #

  $canvas coords $rectangle $rectX \
			    $rectY \
			    [expr {$rectX+$rectCentreX*2}] \
			    [expr {$rectY+$rectCentreY*2}]
}
