#!/usr/local/bin/cdplay -file
#
# cdplay.t -- tcl/tk script for playing a cdrom as an audio device
# on HP PA_RISC machines using HPUX >= 8.05
#
# It may work on other HP configurations also but I have 
# not tested it
#
# to run the player do..
#
# ./cdplay -file cdplay.t &
#
# or modify the top line of this script and make it executable
#
# the cdplay binary should be in the tar file you extracted this from
#
# this script that /dev/cdaudio is the name of the cd audio device
# so (as root) do something like
#
# 	ln /dev/rdsk/3s0 /dev/cdaudio
# 	chmod +rw /dev/cdaudio
#
# or edit the line below these comments to be something like
#
#	set Player "/dev/rdsk/3s0"
#
# the protections on your cd device may be such that you have to
# run cdplay as root if you do not chmod the device.
#
# This is just a bit of hackery I did between compiles of other
# stuff so it is a bit on the scatter brained side.
#
# left button on the Track button goes to the next track
# middle button on the Track button goes to the first
# right button on the Track button goes to the previous track
#
# the operation of the rest of the window should is obvious 
#
# quitting the window leaves the player running. you can then restart
# the window as if you never exited.
#
# if you add any neat things to this script let me know
#
# mike hoegeman, mh@awds.ismd.contel.com
#
set Player "/dev/cdaudio"

### -- timer functions
# proc timerstart {{timername} {procname} {interval 10000}}
#
# start a timer with name 'timername' which will run proc every 'interval'
# microseconds
#
proc timerstart {{timername} {procname} {interval 10000}} {
    if { $interval } {
	global IntervalFor__$timername
	if { [info exists IntervalFor__$timername] } {
	    error [format "timerstart: timer %s already exists" $timername]
	}
	set IntervalFor__$timername $interval
	after $interval timerstart $timername $procname 0
    } else {
	global IntervalFor__$timername
	if {[info exists IntervalFor__$timername]} {
	    $procname $timername
	    after [set IntervalFor__$timername] \
		  timerstart $timername $procname 0
	}
    }
}
# proc timerstop {timername}
#
# stop a timer with name 'timername' that was started by the timerstart
# tcl proc
#
proc timerstop {timername} {
    global IntervalFor__$timername
    if { [info exists IntervalFor__$timername] } {
	unset IntervalFor__$timername
    }
}

# get current play status of cd and display it in windows widgets
# return basic cd status e.g. playing paused etc...
set CurrentTrack 1
proc playstatus {{t ""}} {
    global CurrentTrack
    set l [split [cd_playstatus]]
    set status [lindex $l 0]
    set CurrentTrack [lindex $l 1]
    if {$status=="playing"} {
	.info.msgTrack config -text "Track: $CurrentTrack"
	.info.msgTime config -text "Time: [lindex $l 2]:[lindex $l 3]"
    }
    .info.msg config -text $status
    return $status
}

# go to next/prev/first track 
# then start playing 'howmany' tracks 
# from that position
proc nextTrack {{dir "next"} {howmany "end"}} {
    global CurrentTrack
    set l [split [cd_trackinfo]]
    set first [lindex $l 0]
    set last [lindex $l 1]
    case $dir next {
	if {$CurrentTrack==$last} { 
	    set CurrentTrack $first 
	} else { 
	    incr CurrentTrack 1
	}
    } prev {
	if {$CurrentTrack==$first} { 
	    set CurrentTrack $last 
	} else { 
	    incr CurrentTrack -1
	}
    } start {
	set CurrentTrack $first
    }
    cd_pause
    cd_search $CurrentTrack
    cd_play $howmany
    playstatus
    return $CurrentTrack
}

# toggle pause mode for the cd
set PauseState 0
proc pauseFlip {} {
    global  PauseState
    set PauseState [expr !$PauseState]
    if {$PauseState} { cd_pause } else { cd_continue }
    playstatus
}

# eject the cd and exit the program
proc eject {} {
    cd_eject
    destroy .
}

wm minsize . 200 58
wm geometry . 300x64
# frames to hold two sets of widgets bags
frame .info -bg black 
frame .ctrls -bg black 
message .info.msg -bd 2 -justify center -relief sunken \
    -font lucidasans-bold-14 -text ""  -aspect 8000
button .info.msgTrack -bd 2 -relief sunken \
	-padx 3 -pady 3 \
	-font lucidasans-bold-14 -text "Track" -command nextTrack
bind .info.msgTrack <ButtonRelease-3> {nextTrack prev}
bind .info.msgTrack <ButtonRelease-2> {nextTrack start}

message .info.msgTime -bd 2 -relief sunken \
	-font lucidasans-bold-14 -text "" -justify center -aspect 8000
checkbutton .ctrls.pause -bd 2 -relief sunken \
	-padx 3 -pady 3 \
	-font lucidasans-bold-14 -text Pause
button .ctrls.eject -bd 2 -relief sunken \
	-padx 3 -pady 3 \
	-font lucidasans-bold-14 -text "Eject" -command eject
bind .ctrls.pause <ButtonRelease-1> pauseFlip

pack append .info \
    .info.msg {left expand fillx } \
    .info.msgTrack {right expand fillx } \
    .info.msgTime {right expand fillx }
pack append .ctrls \
    .ctrls.pause {left expand fillx } \
    .ctrls.eject {left expand fillx }
pack append . .info {top expand fill} .ctrls {bottom expand fill}

cd_init $Player
if {[playstatus]!="playing"} {
    nextTrack start
}
timerstart playStatusTimer playstatus 1000
