# ----------------------------------------------------------------------
#  PURPOSE:  Handling counter operations via [incr Tcl].
#
#   AUTHOR:  Michael J. McLennan       Phone: (610)712-2842
#            AT&T Bell Laboratories   E-mail: michael.mclennan@att.com
#
#      RCS:  counter.tcl,v 1.1.1.1 1994/03/21 22:09:45 mmc Exp
# ----------------------------------------------------------------------
#               Copyright (c) 1993  AT&T Bell Laboratories
# ======================================================================
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that the copyright notice and warranty disclaimer appear in
# supporting documentation, and that the names of AT&T Bell Laboratories
# any of their entities not be used in advertising or publicity
# pertaining to distribution of the software without specific, written
# prior permission.
#
# AT&T disclaims all warranties with regard to this software, including
# all implied warranties of merchantability and fitness.  In no event
# shall AT&T be liable for any special, indirect or consequential
# damages or any damages whatsoever resulting from loss of use, data or
# profits, whether in an action of contract, negligence or other
# tortuous action, arising out of or in connection with the use or
# performance of this software.
# ======================================================================

# ----------------------------------------------------------------------
#  Simple "counter" class
# ----------------------------------------------------------------------
itcl_class counter {
    constructor {config} {}
    method config {config} {}

    method value {} {
        return $count
    }
    method ++ {{val unspec}} {
        if {$val == "unspec"} {set val $by}
        return [+= $val]
    }
    method -- {{val unspec}} {
        if {$val == "unspec"} {set val $by}
        return [-= $val]
    }
    method += {val} {
        return [incr count $val]
    }
    method -= {val} {
        return [incr count [expr -1*$val]]
    }
    public by 1
    protected count 0
}

# ----------------------------------------------------------------------
#  Add multiplying behavior to "counters"
# ----------------------------------------------------------------------
itcl_class multiplier {
    inherit counter

    constructor {config} {}
    method config {config} {}

    method ** {{val unspec}} {
        if {$val == "unspec"} {set val $by}
        return [*= $val]
    }
    method *= {val} {
        set count [expr $count*$val]
        return $count
    }
}

# ----------------------------------------------------------------------
#  Example usages
# ----------------------------------------------------------------------

counter c -by 2
c ++
c += 2
c config -by 1
c ++

multiplier m -by 2
m ++
m **
m *= 3
m --
