'\" 
'\" Copyright 1993 David Herron.
'\" Permission to use, copy, modify and distribute this software
'\" and its documentation for any purpose and without fee is
'\" hereby granted, provided that the above copyright notice
'\" appear in all copies.  David Herron makes no representations
'\" about the suitability of this software for any purpose save
'\" printing it out and using the paper as bird cage lining.
'\" 
.\" $Id: interp.man,v 1.3 1993/06/08 06:11:50 david Exp $
.\"
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"     Replacement for .TH in other man pages.  See below for valid
.\"     section names.
.\"
.\" .AP type name in/out [indent]
.\"     Start paragraph describing an argument to a library procedure.
.\"     type is type of argument (int, etc.), in/out is either "in", "out",
.\"     or "in/out" to describe whether procedure reads or modifies arg,
.\"     and indent is equivalent to second arg of .IP (shouldn't ever be
.\"     needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"     Give maximum sizes of arguments for setting tab stops.  Type and
.\"     name are examples of largest possible arguments that will be passed
.\"     to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"     Start box enclosure.  From here until next .BE, everything will be
.\"     enclosed in one large box.
.\"
.\" .BE
.\"     End of box enclosure.
.\"
.\" .VS
.\"     Begin vertical sidebar, for use in marking newly-changed parts
.\"     of man pages.
.\"
.\" .VE
.\"     End of vertical sidebar.
.\"
.\" .DS
.\"     Begin an indented unfilled display.
.\"
.\" .DE
.\"     End of indented unfilled display.
.\"
'\"     # Heading for Tcl/Tk man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"     # Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1  \\fI\\$2\\fP    (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1  \\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"     # define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"     # BS - start boxed text
'\"     # ^y = starting y location
'\"     # ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"     # BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"     Draw four-sided box normally, but don't draw top of
.\"     box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"     # VS - start vertical sidebar
'\"     # ^Y = starting y location
'\"     # ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"     # VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"     # Special macro to handle page bottom:  finish off current
'\"     # box/sidebar if in box/sidebar mode, then invoked standard
'\"     # page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"     Draw three-sided box if this is the box's first page,
.\"     draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h
'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"     # DS - begin display
.de DS
.RS
.nf
.sp
..
'\"     # DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS interp cmds
.BS
.SH NAME
interp, minterp \- Create and manipulate interpretors from TCL
.SH SYNOPSIS
\fBinterp\fP \fIsub-command\fP ?\fIoptions ...\fP?
.br
\fIinterp-name\fP \fB-exec\fP \fIcommand\fP
.br
\fIinterp-name method-name\fP ?\fIoptions ...\fP?
.BE

.SH DESCRIPTION
.PP
\fIMinterp\fP is an extension to TCL giving the ability to create and
manipulate multiple interpretors from a TCL program.  The immediate
benefit is in creating multiple name spaces reducing the chances for
name conflicts.  Interpretors can send messages (execute commands
anyway) to one another.  Through this ability any resource in one
interpretor can be reached and used by another.  Sufficient
flexibility is present to construct access controls at a fairly low
level of detail.

The \fIinterp\fP command is used to manipulate the list of all interpretors.
Using it one creates new interpretors, list of existing interpretors,
and so forth.

Each interpretor has a name associated with it.  This name is registered
as a command in each interpretor (managed by \fIminterp\fP) and is used
to gain access to that interpretor.

There is a concept of a \fImain interpretor\fP.  Since a program
starts out life with an interpretor already existing, it must be
treated somewhat specially.  Executing \fIinterp MainInterp\fP
initializes the \fIminterp\fP module, and places this interpretor
under sufficient control of \fIminterp\fP to enable everything to work
properly.  Programmers should assume that an interpretor named
MainInterp exists.

.SH "SUB-COMMANDS"
.PP
The \fIinterp\fP command by itself does nothing, and one of the following
sub-commands are required.

.TP
\fBnew\fP \fIinterp-name\fP
Create a new interpretor.  Returns the name as the result.  Creates a
command of the same name in all interpretors, this command is
described in more detail later.  The set of commands in this
interpretor are those of TCL with a few modifications as described
below.

Of course only one interpretor, of a particular name, can exist at a
time.  Care should be taken that the interpretor name chosen not
conflict with an already existing command somewhere.

Each interpretor has its own set of variable and procedure names.

.TP
\fBlist\fP
Return a TCL list of all currently existing interps.

.TP
\fBMainInterp\fP
Sets the current interpretor to be \fIMainInterp\fP.  This should only
be executed at the very beginning of the program.

.TP
\fBresult\fP \fIinterp-name\fP
Return the current \fIresult\fP in the named interp.

.TP
\fBcreateHook\fP ?\fIcommand\fP?
The create-hook is TCL code executed when any interp is created, allowing
for customization.

.TP
\fBexists\fP \fIinterp-name\fP
Tests for existance of the named interp.  Returns \fB1\fP if it does, and
\fB0\fP otherwise.

.TP
\fBthis\fP
Returns the name of the interpreter executing the command.  Purposely named
similarly to the \fIthis\fP variable in C++.

.TP
\fBlibrary\fP
Returns the default directory for searching for modules.

.SH "INTERPRETOR COMMANDS"
.PP
As previously stated, each interpretor has a name and this name is a
command used to access it.  The form of access is described here.

.TP
\fIinterp-name\fP \fB-exec\fP ?\fIcommand\fP?
This is the most wide open of access.  This executes any TCL command in
the named interpretor, and returns the result.  If the command results
in an error, then care is taken to copy the error information back
to the calling interpretor.  The \fB-AllowExec\fP command, described
below, governs the ability to use \fB-exec\fP.

.TP
\fIinterp-name method-name\fP ?\fIarguments ...\fP?
This allows execution of a single command in the named interpretor.
The \fImethod-name\fP must be in the list of names maintained by
the \fBMethod\fP commands described below.  

.SH "NEW COMMANDS IN THE INTERPRETOR"
The following allow code within an interpretor to control the behaviour
of the interpretor as seen from the outside.  These commands allow the
programmer to limit the amount of access outside functions have to things
inside the interpretor.  It also gives the ability to import functionality
from other interpretors.

Most have been named with \fB-\fP as the first character as a convention
that would reserve such names to \fIminterp\fP and limit possible conflict
with other command names.

.TP
\fB-AddMethod\fP \fImethod-name\fP
The \fIMethod\fP list contains the names of commands local to the interpretor
which can be executed using the \fIinterp-name method-name\fP form described
above.  \fB-AddMethod\fP adds the given name to the list.  The name does
not have to currently exist as a command.

.TP
\fB-DelMethod\fP \fImethod-name\fP
Deletes the name from the \fIMethod\fP list.

.TP
\fB-IsMethod\fP \fImethod-name\fP
Tests if the name is on the \fIMethod\fP list.

.TP
\fB-Methods\fP
Returns a TCL list of the \fIMethod\fP list.

.TP
\fB-execHere\fP \fIother-interpretor method-name\fP ?\fIarguments ...\fP?
Retrieves the named command from the named interpretor and executes
the command \fImethod-name arguments ...\fP in the current
interpretor.  The command being executed \fBis\fP in the same context,
namespace, and has full and complete access to the current interpretor
since it is executing \fBin\fP the current interpretor.  The command
\fImethod-name\fP does not need to be in the \fIMethod\fP list.

This is used primarily for importing (or inheriting) functionality
defined elsewhere.  It allows for the definition of a function to be
stored in one interpretor, and to be useful elsewhere.  This supports
the inheritance attribute of object oriented programming.  One
interpretor would be used to store the definition of a particular
class of operations.  Then each new instantiation of the class defines
functions which use \fB-execHere\fP to retrieve the definition of
the function.  Example

.br
\ \ \ \ proc fcn { ...args... } {
.br
\ \ \ \ \ \ \ \ return [-execHere interpretor-defining-class fcn ...args...]
.br
\ \ \ \ }
.br

.TP
\fB-AllowExec\fP ?\fIboolean\fP?
Controls or retrieves the value of the \fIAllowExec\fP flag in the
interpretor.  This controls whether \fB-exec\fP is allowed to work for
this interpretor.  If a boolean value of \fIfalse\fP or \fI0\fP is
given, then it does not work.  If \fItrue\fP or \fI1\fP is given then
it does work.  In any case the new value is returned.

.TP
\fB-destroyHook\fP ?\fIcommand\fP?
\fBNOT INSERTED INTO MainInterp.\fP  This is a command string which is
executed when the interpretor is deleted (see \fB-exit\fP).  This happens
just prior to removal of the resources owned by the interpretor and is
its last chance to do anything of significance.  If the command returns
error status, then the interpretor is not destroyed and an error indication
is returned to the caller.

.TP
\fB-exit\fP
\fBNOT INSERTED INTO MainInterp.\fP  Makes the current interpretor exit,
or kill itself.  Programmers will frequently desire to override the normal
TCL \fIexit\fP command to instead call \fB-exit\fP.

.SH KEYWORDS
multiple interpretors, encapsulation, abstraction, modularity, object oriented

.SH AUTHOR
David Herron <david@davids.mmdf.com (home)>

.SH BUGS
Knock on wood ...
