#
# prime number sieve in Tcl
#
# quick results -- 
#
# NArray Tcl                 46.0 secs
# GNU C (sieve.c)            8.92 secs
#   " -O2                    8.05 secs
#   " -O2 -funroll-loops     8.02 secs
# GNU C (isieve.c)           2.40 secs
#   " -O2                    0.88 secs
#   " -O2 -funroll-loops     0.88 secs
#

proc msg {msg} {
    puts "### $msg"
}

proc run body {
    if {[catch [list uplevel $body]] == 1} {
	global errorInfo
	puts stderr $errorInfo
    }
}

proc vtime {msg t_var body} {
    upvar $t_var t
    puts "### $msg"
    puts [set t [time [list uplevel $body]]]
    set t [lindex $t 0]
}

set debug 0
set n 25

run {
    if {$argc >= 1} {
	set n [lindex $argv 0]
    }
    msg "Creating sieve vector, n = $n"
    narray create sieve $n
    sieve debug $debug

    sieve aset 0 2
    sieve vset trial 3

    vtime "Runing sieve" t {
	sieve map {
	    if @0 > 0 {
		prime = 0;
		while !$prime {
		    prime = 1;
		    for {i = 0; $prime && $i < @0; i += 1} {
			if fmod($trial, $[-@0 + $i]) == 0 { prime = 0; }
		    }
		    if !$prime { trial += 2; }
		}
		[] = $trial;
	    }
	}
    }
    msg "Done in [expr $t / 1.0e6] secs"
    if {$argc >= 2} {
	msg "Results:"
	sieve debug 0
	pnarray sieve
	msg "Variables:"
	foreach var [sieve vars] {
	    puts [list $var = [sieve vref $var]]
	}
    }
}
