#
# $Id: util.tcl,v 1.2 1994/08/04 23:51:41 sls Exp $
#
# This software is copyright (C) 1994 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Various shorthand utility stuff
#
# util(verbose) -- if 1 then msg prints stuff
#

set util(verbose) 0

proc ifexists {var action {else_keyword ""} {else_clause ""}} {
    upvar $var v
    if [info exists v] {
	uplevel $action
	return
    }
    if {$else_keyword == "else"} {
	uplevel $else_clause
    }
}

proc ifnexists {var action {else_keyword ""} {else_clause ""}} {
    upvar $var v
    if ![info exists v] {
	uplevel $action
    }
    if {$else_keyword == "else"} {
	uplevel $else_clause
    }
}

proc msg_verbose {} {
    global util
    set util(verbose) 1
}

proc msg_quiet {} {
    global util
    set util(verbose) 0
}

proc msg {m} {
    global util
    if $util(verbose) {
	puts $m
    }
}

proc args {args tbl} {
    foreach var $tbl {
	upvar [string range $var 1 end] [lindex $var 0]
	if {[llength $var] == 2} {
	    set [lindex $var 0] [lindex $var 1]
	}
    }
    while {[llength $args]} {
	set arg [lindex $args 0]
	if {[lsearch -glob $tbl $arg*] != -1} {
	    set val [lindex $args 1]
	    if {$val != 0} {
		set $arg $val
	    }
	} else {
	    error "unknown argument $arg, should be one of: $tbl"
	}
	set args [lrange $args 2 end]
    }
}

proc append_line {var line} {
    upvar $var v
    append v "\n$line"
}

proc string_range {s p} {
    return [string range $s [lindex $p 0] [lindex $p 1]]
}

proc iswhite {s} {
    return [regexp "^( \t\n)*$" $s]
}

proc string_cap_first {s} {
    return [string toupper [string index $s 0]][string range $s 1 end]
}
